/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import name.abuchen.portfolio.snapshot.ReportingPeriod;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.EditReportingPeriodsDialog;
import name.abuchen.portfolio.ui.dialogs.ReportingPeriodDialog;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.SimpleAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Display;

public final class ReportingPeriodDropDown
extends DropDown
implements IMenuListener {
    private final PortfolioPart part;
    private final ReportingPeriodListener listener;
    private ReportingPeriod selected;
    private List<ReportingPeriod> periods;

    public ReportingPeriodDropDown(PortfolioPart part, ReportingPeriodListener listener) {
        super("x", null, 4, null);
        this.part = part;
        this.listener = Objects.requireNonNull(listener);
        this.selected = part.getSelectedPeriod();
        this.periods = part.getReportingPeriods();
        this.setMenuListener(this);
        this.setLabel(this.selected.toString());
        this.setToolTip(this.selected.toInterval(LocalDate.now()).toString());
    }

    public void menuAboutToShow(IMenuManager manager) {
        for (ReportingPeriod period : this.periods) {
            Action action = this.createActionFor(period);
            action.setChecked(period.equals(this.selected));
            manager.add((IAction)action);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new SimpleAction(Messages.LabelReportingAddPeriod, a -> {
            ReportingPeriodDialog dialog = new ReportingPeriodDialog(Display.getDefault().getActiveShell(), this.selected);
            if (dialog.open() == 0) {
                ReportingPeriod period = dialog.getReportingPeriod();
                this.doSelect(period);
                if (!this.periods.contains(period)) {
                    this.periods.add(period);
                }
                if (this.listener != null) {
                    this.listener.reportingPeriodUpdated();
                }
            }
        }));
        manager.add((IAction)new SimpleAction(Messages.MenuReportingPeriodManage, a -> {
            EditReportingPeriodsDialog dialog = new EditReportingPeriodsDialog(Display.getDefault().getActiveShell());
            dialog.setReportingPeriods(this.periods);
            if (dialog.open() == 0) {
                this.periods.clear();
                this.periods.addAll(dialog.getReportingPeriods());
                if (this.periods.isEmpty()) {
                    this.periods.add(this.selected);
                }
                if (!this.periods.contains(this.selected)) {
                    this.doSelect(this.periods.get(0));
                    this.listener.reportingPeriodUpdated();
                }
            }
        }));
    }

    private void doSelect(ReportingPeriod period) {
        this.selected = period;
        this.part.setSelectedPeriod(period);
        this.setLabel(period.toString());
        this.setToolTip(this.selected.toInterval(LocalDate.now()).toString());
    }

    private Action createActionFor(ReportingPeriod period) {
        return new SimpleAction(period.toString(), a -> {
            this.doSelect(period);
            if (this.listener != null) {
                this.listener.reportingPeriodUpdated();
            }
        });
    }

    public ReportingPeriod getSelectedPeriod() {
        return this.selected;
    }

    @FunctionalInterface
    public static interface ReportingPeriodListener {
        public void reportingPeriodUpdated();
    }
}

