/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public final class SWTHelper {
    public static final String EMPTY_LABEL = "";

    private SWTHelper() {
    }

    public static Control widestWidget(Control ... widgets) {
        int width = 0;
        Control answer = null;
        int ii = 0;
        while (ii < widgets.length) {
            int w;
            if (widgets[ii] != null && (w = widgets[ii].computeSize((int)-1, (int)-1).x) >= width) {
                answer = widgets[ii];
                width = w;
            }
            ++ii;
        }
        return answer;
    }

    public static int widest(Control ... widgets) {
        int width = 0;
        int ii = 0;
        while (ii < widgets.length) {
            int w;
            if (widgets[ii] != null && (w = widgets[ii].computeSize((int)-1, (int)-1).x) >= width) {
                width = w;
            }
            ++ii;
        }
        return width;
    }

    public static int dateWidth(Drawable drawable) {
        GC gc = new GC(drawable);
        Point extentText = gc.stringExtent("YYYY-MM-DD");
        gc.dispose();
        return extentText.x;
    }

    public static int stringWidth(Drawable drawable, String text) {
        GC gc = new GC(drawable);
        Point extentText = gc.stringExtent(text);
        gc.dispose();
        return extentText.x;
    }

    public static int lineHeight(Control drawable) {
        GC gc = new GC((Drawable)drawable);
        gc.setFont(drawable.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return fontMetrics.getHeight();
    }

    public static int amountWidth(Drawable drawable) {
        return SWTHelper.stringWidth(drawable, "12345678,00");
    }

    public static int currencyWidth(Drawable drawable) {
        return SWTHelper.stringWidth(drawable, "XXXX");
    }

    public static void placeBelow(Control referenceItem, Label label, Control value) {
        FormData data = new FormData();
        if (label != null) {
            data.top = new FormAttachment(value, 0, 0x1000000);
            label.setLayoutData((Object)data);
        }
        data = new FormData();
        data.top = new FormAttachment(referenceItem, 5);
        data.left = new FormAttachment(referenceItem, 0, 16384);
        data.right = new FormAttachment(referenceItem, 0, 131072);
        value.setLayoutData((Object)data);
    }

    public static void placeBelow(Control referenceItem, Control value) {
        SWTHelper.placeBelow(referenceItem, null, value);
    }

    public static void clearLabel(Label ... labels) {
        Label[] labelArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            Label label = labelArray[n2];
            label.setText(EMPTY_LABEL);
            ++n2;
        }
    }

    public static int getPackedWidth(Control item) {
        item.pack();
        return item.getBounds().width;
    }

    public static ComboViewer createComboViewer(Composite parent) {
        if ("win32".equals(Platform.getOS())) {
            return new ComboViewer(new CCombo(parent, 0x800808));
        }
        return new ComboViewer(parent, 8);
    }
}

