/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.util.AbstractCSVExporter;
import name.abuchen.portfolio.ui.util.viewers.SharesLabelProvider;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableViewerCSVExporter
extends AbstractCSVExporter {
    private final TableViewer viewer;

    public TableViewerCSVExporter(TableViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    protected Shell getShell() {
        return this.viewer.getTable().getShell();
    }

    @Override
    protected void writeToFile(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), STRATEGY);){
            int columnCount = this.viewer.getTable().getColumnCount();
            TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                printer.print((Object)column.getText());
                ++n2;
            }
            printer.println();
            SharesLabelProvider[] labelProvider = new SharesLabelProvider[columnCount];
            int ii = 0;
            while (ii < columnCount) {
                CellLabelProvider p = this.viewer.getLabelProvider(ii);
                if (p instanceof SharesLabelProvider) {
                    labelProvider[ii] = (SharesLabelProvider)p;
                }
                ++ii;
            }
            TableItem[] tableItemArray = this.viewer.getTable().getItems();
            int n3 = tableItemArray.length;
            n = 0;
            while (n < n3) {
                TableItem item = tableItemArray[n];
                int ii2 = 0;
                while (ii2 < columnCount) {
                    if (labelProvider[ii2] != null) {
                        Long value = labelProvider[ii2].getValue(item.getData());
                        printer.print((Object)(value != null ? Values.Share.format((Object)value) : ""));
                    } else {
                        printer.print((Object)item.getText(ii2));
                    }
                    ++ii2;
                }
                printer.println();
                ++n;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

