/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.chart;

import java.text.DecimalFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.chart.AbstractChartToolTip;
import name.abuchen.portfolio.ui.util.swt.ColoredLabel;
import name.abuchen.portfolio.util.Pair;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IBarSeries;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public class TimelineChartToolTip
extends AbstractChartToolTip {
    private LocalResourceManager resourceManager;
    private Function<Object, String> xAxisFormat;
    private DecimalFormat valueFormat = new DecimalFormat("#,##0.00");
    private boolean categoryEnabled = false;
    private boolean reverseLabels = false;
    private String showToolTipOnlyForDatesInThisDataSeries = null;
    private Set<String> excludeFromTooltip = new HashSet<String>();
    private List<BiConsumer<Composite, Object>> extraInfoProvider = new ArrayList<BiConsumer<Composite, Object>>();

    public TimelineChartToolTip(Chart chart) {
        super(chart);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)chart);
    }

    public void enableCategory(boolean enabled) {
        this.categoryEnabled = enabled;
    }

    public void reverseLabels(boolean reverseLabels) {
        this.reverseLabels = reverseLabels;
    }

    public void setXAxisFormat(Function<Object, String> format) {
        this.xAxisFormat = format;
    }

    public void setValueFormat(DecimalFormat valueFormat) {
        this.valueFormat = valueFormat;
    }

    public void addSeriesExclude(String seriesId) {
        this.excludeFromTooltip.add(seriesId);
    }

    public void showToolTipOnlyForDatesInDataSeries(String seriesId) {
        this.showToolTipOnlyForDatesInThisDataSeries = seriesId;
    }

    public void addExtraInfo(BiConsumer<Composite, Object> extraInfoProvider) {
        this.extraInfoProvider.add(extraInfoProvider);
    }

    @Override
    protected Object getFocusObjectAt(Event event) {
        return this.categoryEnabled ? this.getFocusCategoryAt(event) : this.getFocusDateAt(event);
    }

    private Integer getFocusCategoryAt(Event event) {
        IAxis xAxis = this.getChart().getAxisSet().getXAxes()[0];
        int coordinate = (int)xAxis.getDataCoordinate(event.x);
        String[] categories = xAxis.getCategorySeries();
        if (coordinate < 0) {
            coordinate = 0;
        } else if (coordinate > categories.length - 1) {
            coordinate = categories.length - 1;
        }
        return coordinate;
    }

    private Date getFocusDateAt(Event event) {
        IAxis xAxis = this.getChart().getAxisSet().getXAxes()[0];
        long time = (long)xAxis.getDataCoordinate(event.x);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (this.showToolTipOnlyForDatesInThisDataSeries == null) {
            return cal.getTime();
        }
        ISeries timeSeries = this.getChart().getSeriesSet().getSeries(this.showToolTipOnlyForDatesInThisDataSeries);
        if (timeSeries == null) {
            return cal.getTime();
        }
        int line = Arrays.binarySearch(timeSeries.getXDateSeries(), cal.getTime());
        if (line >= 0) {
            return cal.getTime();
        }
        if ((line = -line - 1) == 0) {
            return timeSeries.getXDateSeries()[line];
        }
        int length = timeSeries.getXDateSeries().length;
        if (line >= length) {
            return timeSeries.getXDateSeries()[length - 1];
        }
        long target = cal.getTimeInMillis();
        Date left = timeSeries.getXDateSeries()[line - 1];
        Date right = timeSeries.getXDateSeries()[line];
        return target - left.getTime() < right.getTime() - target ? left : right;
    }

    @Override
    protected void createComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        RowLayout layout = new RowLayout(512);
        layout.center = true;
        container.setLayout((Layout)layout);
        Composite data = new Composite(container, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(data);
        Label left = new Label(data, 0);
        left.setText(this.categoryEnabled ? this.getChart().getAxisSet().getXAxis(0).getTitle().getText() : Messages.ColumnDate);
        Label right = new Label(data, 0);
        right.setText(this.formatXAxisData(this.getFocusedObject()));
        List<Pair<ISeries, Double>> values = this.computeValues(this.getChart().getSeriesSet().getSeries());
        if (this.reverseLabels) {
            Collections.reverse(values);
        }
        if (this.isAltPressed()) {
            Collections.sort(values, (l, r) -> ((Double)r.getValue()).compareTo((Double)l.getValue()));
        }
        for (Pair<ISeries, Double> value : values) {
            ISeries series = (ISeries)value.getKey();
            Color color = series instanceof ILineSeries ? ((ILineSeries)series).getLineColor() : ((IBarSeries)series).getBarColor();
            ColoredLabel cl = new ColoredLabel(data, 0);
            cl.setBackdropColor(color);
            cl.setText(series.getId());
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)cl);
            right = new Label(data, 131072);
            right.setText(this.valueFormat.format(value.getRight()));
            GridDataFactory.fillDefaults().align(0x1000008, 4).applyTo((Control)right);
        }
        Object focus = this.getFocusedObject();
        this.extraInfoProvider.forEach(provider -> provider.accept(container, focus));
        Label hint = new Label(data, 0);
        hint.setText(Messages.TooltipHintPressAlt);
        hint.setFont(this.resourceManager.createFont(FontDescriptor.createFrom((Font)data.getFont()).increaseHeight(-3).withStyle(2)));
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)hint);
    }

    private List<Pair<ISeries, Double>> computeValues(ISeries[] allSeries) {
        ArrayList<Pair<ISeries, Double>> values = new ArrayList<Pair<ISeries, Double>>();
        ISeries[] iSeriesArray = allSeries;
        int n = allSeries.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                double value;
                ISeries series;
                block5: {
                    int line;
                    block4: {
                        series = iSeriesArray[n2];
                        if (this.excludeFromTooltip.contains(series.getId())) break block3;
                        if (!this.categoryEnabled) break block4;
                        line = (Integer)this.getFocusedObject();
                        if (line >= series.getYSeries().length) break block3;
                        value = series.getYSeries()[line];
                        break block5;
                    }
                    line = Arrays.binarySearch(series.getXDateSeries(), this.getFocusedObject());
                    if (line < 0) break block3;
                    value = series.getYSeries()[line];
                }
                values.add((Pair<ISeries, Double>)new Pair((Object)series, (Object)value));
            }
            ++n2;
        }
        return values;
    }

    private String formatXAxisData(Object obj) {
        if (this.xAxisFormat != null) {
            return this.xAxisFormat.apply(obj);
        }
        if (this.categoryEnabled && obj instanceof Integer) {
            return this.getChart().getAxisSet().getXAxis(0).getCategorySeries()[(Integer)obj];
        }
        if (obj instanceof Date) {
            return Values.Date.format((Object)((Date)obj).toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        }
        return String.valueOf(obj);
    }
}

