/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.chart;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.Range;

public class ZoomMouseWheelListener
implements Listener {
    private static final double ZOOM_RATIO = 0.1;
    private final Chart chart;

    public static void attachTo(Chart chart) {
        ZoomMouseWheelListener listener = new ZoomMouseWheelListener(chart);
        chart.getPlotArea().addListener(37, (Listener)listener);
    }

    private ZoomMouseWheelListener(Chart chart) {
        this.chart = chart;
    }

    public void handleEvent(Event event) {
        IAxis[] iAxisArray = this.chart.getAxisSet().getYAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            double coordinate = axis.getDataCoordinate(event.y);
            Range range = axis.getRange();
            double lower = 0.0;
            double upper = 0.0;
            if (event.count > 0) {
                lower = range.lower + 0.2 * (coordinate - range.lower);
                upper = range.upper + 0.2 * (coordinate - range.upper);
            } else {
                lower = (range.lower - 0.2 * coordinate) / 0.8;
                upper = (range.upper - 0.2 * coordinate) / 0.8;
            }
            axis.setRange(new Range(lower, upper));
            ++n2;
        }
        this.chart.redraw();
    }
}

