/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import com.ibm.icu.text.MessageFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.viewers.PropertyEditingSupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class DateEditingSupport
extends PropertyEditingSupport {
    private static final DateTimeFormatter[] formatters = new DateTimeFormatter[]{DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM), DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT), DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG), DateTimeFormatter.ofPattern("d.M.yyyy"), DateTimeFormatter.ofPattern("d.M.yy"), DateTimeFormatter.ISO_DATE};

    public DateEditingSupport(Class<?> subjectType, String attributeName) {
        super(subjectType, attributeName);
        if (!LocalDate.class.isAssignableFrom(this.descriptor().getPropertyType())) {
            throw new RuntimeException(String.format("Property %s needs to be of type date", attributeName));
        }
    }

    @Override
    public CellEditor createEditor(Composite composite) {
        TextCellEditor textEditor = new TextCellEditor(composite);
        ((Text)textEditor.getControl()).setTextLimit(20);
        return textEditor;
    }

    @Override
    public final Object getValue(Object element) throws Exception {
        LocalDate date = (LocalDate)this.descriptor().getReadMethod().invoke(this.adapt(element), new Object[0]);
        return Values.Date.format((Object)date);
    }

    @Override
    public final void setValue(Object element, Object value) throws Exception {
        Object subject = this.adapt(element);
        LocalDate newValue = null;
        DateTimeFormatter[] dateTimeFormatterArray = formatters;
        int n = formatters.length;
        int n2 = 0;
        while (n2 < n) {
            DateTimeFormatter formatter = dateTimeFormatterArray[n2];
            try {
                newValue = LocalDate.parse(String.valueOf(value), formatter);
                break;
            }
            catch (DateTimeParseException dateTimeParseException) {
                ++n2;
            }
        }
        if (newValue == null) {
            throw new IllegalArgumentException(MessageFormat.format((String)Messages.MsgErrorNotAValidDate, (Object[])new Object[]{value}));
        }
        LocalDate oldValue = (LocalDate)this.descriptor().getReadMethod().invoke(subject, new Object[0]);
        if (!newValue.equals(oldValue)) {
            this.descriptor().getWriteMethod().invoke(subject, newValue);
            this.notify(element, newValue, oldValue);
        }
    }
}

