/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.ui.util.viewers.PropertyEditingSupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.widgets.Composite;

public class ListEditingSupport
extends PropertyEditingSupport {
    private ComboBoxCellEditor editor;
    private List<Object> comboBoxItems;

    public ListEditingSupport(Class<?> subjectType, String attributeName, List<?> options) {
        super(subjectType, attributeName);
        for (Object option : options) {
            if (option != null) continue;
            throw new IllegalArgumentException();
        }
        this.comboBoxItems = new ArrayList(options);
    }

    public boolean canBeNull(Object element) {
        return false;
    }

    @Override
    public final CellEditor createEditor(Composite composite) {
        this.editor = new ComboBoxCellEditor(composite, new String[0], 8);
        return this.editor;
    }

    @Override
    public final void prepareEditor(Object element) {
        boolean canBeNull = this.canBeNull(element);
        if (canBeNull) {
            if (this.comboBoxItems.isEmpty() || this.comboBoxItems.get(0) != null) {
                this.comboBoxItems.add(0, null);
            }
        } else if (!this.comboBoxItems.isEmpty() && this.comboBoxItems.get(0) == null) {
            this.comboBoxItems.remove(0);
        }
        String[] names = new String[this.comboBoxItems.size()];
        int index = 0;
        for (Object item : this.comboBoxItems) {
            String string = names[index++] = item == null ? "" : item.toString();
        }
        this.editor.setItems(names);
    }

    @Override
    public final Object getValue(Object element) throws Exception {
        Object property = this.descriptor().getReadMethod().invoke(this.adapt(element), new Object[0]);
        int ii = 0;
        while (ii < this.comboBoxItems.size()) {
            Object item = this.comboBoxItems.get(ii);
            if (item != null && item.equals(property)) {
                return ii;
            }
            if (item == null && property == null) {
                return ii;
            }
            ++ii;
        }
        return 0;
    }

    @Override
    public final void setValue(Object element, Object value) throws Exception {
        Object subject = this.adapt(element);
        int index = (Integer)value;
        if (index < 0) {
            return;
        }
        Object newValue = this.comboBoxItems.get(index);
        Object oldValue = this.descriptor().getReadMethod().invoke(subject, new Object[0]);
        if (newValue != null && !newValue.equals(oldValue) || newValue == null && oldValue != null) {
            this.descriptor().getWriteMethod().invoke(subject, newValue);
            this.notify(element, newValue, oldValue);
        }
    }
}

