/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.AccountTransferEntry;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MutableMoney;
import name.abuchen.portfolio.money.Quote;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AccountTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.AccountTransferDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.OpenDialogAction;
import name.abuchen.portfolio.ui.dialogs.transactions.SecurityTransactionDialog;
import name.abuchen.portfolio.ui.handlers.ImportCSVHandler;
import name.abuchen.portfolio.ui.handlers.ImportPDFHandler;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.ConfirmAction;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.LogoManager;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.DateTimeEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.SharesLabelProvider;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.util.viewers.TransactionOwnerListEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.TransactionTypeEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ValueEditingSupport;
import name.abuchen.portfolio.ui.views.AbstractListView;
import name.abuchen.portfolio.ui.views.AccountBalanceChart;
import name.abuchen.portfolio.ui.views.AccountContextMenu;
import name.abuchen.portfolio.ui.views.actions.ConvertTransferToDepositRemovalAction;
import name.abuchen.portfolio.ui.views.columns.AttributeColumn;
import name.abuchen.portfolio.ui.views.columns.CalculatedQuoteColumn;
import name.abuchen.portfolio.ui.views.columns.CurrencyColumn;
import name.abuchen.portfolio.ui.views.columns.IsinColumn;
import name.abuchen.portfolio.ui.views.columns.NameColumn;
import name.abuchen.portfolio.ui.views.columns.NoteColumn;
import name.abuchen.portfolio.ui.views.columns.SymbolColumn;
import name.abuchen.portfolio.ui.views.columns.WknColumn;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class AccountListView
extends AbstractListView
implements ColumnEditingSupport.ModificationListener {
    private static final String FILTER_INACTIVE_ACCOUNTS = "filter-redired-accounts";
    private TableViewer accounts;
    private TableViewer transactions;
    private AccountBalanceChart accountBalanceChart;
    @Inject
    private ExchangeRateProviderFactory exchangeRateProviderFactory;
    private Map<AccountTransaction, Money> transaction2balance = new HashMap<AccountTransaction, Money>();
    private AccountContextMenu accountMenu = new AccountContextMenu(this);
    private ShowHideColumnHelper accountColumns;
    private ShowHideColumnHelper transactionsColumns;
    private boolean isFiltered = false;

    @Override
    protected String getDefaultTitle() {
        return Messages.LabelAccounts;
    }

    @PostConstruct
    public void setup() {
        this.isFiltered = this.getPreferenceStore().getBoolean(FILTER_INACTIVE_ACCOUNTS);
    }

    @Override
    protected int getSashStyle() {
        return 513;
    }

    private void resetInput() {
        this.accounts.setInput((Object)(this.isFiltered ? this.getClient().getActiveAccounts() : this.getClient().getAccounts()));
    }

    @Override
    protected void addButtons(ToolBarManager manager) {
        this.addNewButton(manager);
        this.addFilterButton(manager);
        this.addConfigButton(manager);
    }

    private void addNewButton(ToolBarManager manager) {
        SimpleAction.Runnable newAccountAction = a -> {
            Account account = new Account();
            account.setName(Messages.LabelNoName);
            account.setCurrencyCode(this.getClient().getBaseCurrency());
            this.getClient().addAccount(account);
            this.markDirty();
            this.resetInput();
            this.accounts.editElement((Object)account, 0);
        };
        manager.add((IContributionItem)new DropDown(Messages.MenuCreateAccountOrTransaction, Images.PLUS, 0, menuListener -> {
            menuListener.add((IAction)new SimpleAction(Messages.AccountMenuAdd, newAccountAction));
            menuListener.add((IContributionItem)new Separator());
            Account account = (Account)this.accounts.getStructuredSelection().getFirstElement();
            new AccountContextMenu(this).menuAboutToShow(menuListener, account, null);
        }));
    }

    private void addFilterButton(ToolBarManager manager) {
        Action filter = new Action(){

            public void run() {
                AccountListView.this.isFiltered = !AccountListView.this.isFiltered;
                AccountListView.this.getPart().getPreferenceStore().setValue(AccountListView.FILTER_INACTIVE_ACCOUNTS, AccountListView.this.isFiltered);
                this.setImageDescriptor(AccountListView.this.isFiltered ? Images.FILTER_ON.descriptor() : Images.FILTER_OFF.descriptor());
                AccountListView.this.resetInput();
            }
        };
        filter.setImageDescriptor(this.isFiltered ? Images.FILTER_ON.descriptor() : Images.FILTER_OFF.descriptor());
        filter.setToolTipText(Messages.AccountFilterRetiredAccounts);
        manager.add((IAction)filter);
    }

    private void addConfigButton(ToolBarManager manager) {
        manager.add((IContributionItem)new DropDown(Messages.MenuShowHideColumns, Images.CONFIG, 0, mm -> {
            MenuManager m = new MenuManager(Messages.LabelAccounts);
            this.accountColumns.menuAboutToShow((IMenuManager)m);
            mm.add((IContributionItem)m);
            m = new MenuManager(Messages.LabelTransactions);
            this.transactionsColumns.menuAboutToShow((IMenuManager)m);
            mm.add((IContributionItem)m);
        }));
    }

    @Override
    public void notifyModelUpdated() {
        this.resetInput();
        Account account = (Account)((IStructuredSelection)this.accounts.getSelection()).getFirstElement();
        if (this.getClient().getAccounts().contains(account)) {
            this.accounts.setSelection((ISelection)new StructuredSelection((Object)account));
        } else {
            this.accounts.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    @Override
    public void onModified(Object element, Object newValue, Object oldValue) {
        if (element instanceof AccountTransaction) {
            AccountTransaction t = (AccountTransaction)element;
            if (t.getCrossEntry() != null) {
                t.getCrossEntry().updateFrom((Transaction)t);
            }
            this.accounts.refresh(true);
            this.updateOnAccountSelected((Account)this.transactions.getData(Account.class.toString()));
        }
        this.markDirty();
    }

    @Override
    protected void createTopTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.accounts = new TableViewer(container, 65536);
        ColumnEditingSupport.prepare((ColumnViewer)this.accounts);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.accounts, (int)2);
        this.accountColumns = new ShowHideColumnHelper(String.valueOf(AccountListView.class.getSimpleName()) + "@top2", this.getPreferenceStore(), this.accounts, layout);
        Column column = new NameColumn("0", Messages.ColumnAccount, 0, 150, this.getClient());
        column.setLabelProvider((CellLabelProvider)new NameColumn.NameColumnLabelProvider(this.getClient()){

            public Color getForeground(Object e) {
                boolean isRetired = ((Account)e).isRetired();
                return isRetired ? Display.getDefault().getSystemColor(16) : null;
            }
        });
        column.getEditingSupport().addListener(this);
        this.accountColumns.addColumn(column);
        column = new Column("1", Messages.ColumnBalance, 131072, 80);
        column.setDescription(Messages.ColumnBalance_Description);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return Values.Amount.format((Object)((Account)e).getCurrentAmount(LocalDateTime.now().with(LocalTime.MAX)));
            }
        });
        ColumnViewerSorter.create(o -> Long.valueOf(((Account)o).getCurrentAmount(LocalDateTime.now().with(LocalTime.MAX)))).attachTo(column);
        this.accountColumns.addColumn(column);
        column = new CurrencyColumn();
        column.setEditingSupport(new CurrencyColumn.CurrencyEditingSupport(){

            @Override
            public boolean canEdit(Object element) {
                return ((Account)element).getTransactions().isEmpty();
            }
        });
        this.accountColumns.addColumn(column);
        column = new NoteColumn();
        column.getEditingSupport().addListener(this);
        this.accountColumns.addColumn(column);
        this.addAttributeColumns(this.accountColumns);
        this.accountColumns.createColumns();
        this.accounts.getTable().setHeaderVisible(true);
        this.accounts.getTable().setLinesVisible(true);
        this.accounts.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.resetInput();
        this.accounts.refresh();
        this.hookContextMenu((Control)this.accounts.getTable(), this::fillAccountsContextMenu);
    }

    private void addAttributeColumns(ShowHideColumnHelper support) {
        AttributeColumn.createFor(this.getClient(), Account.class).forEach(column -> {
            column.getEditingSupport().addListener(this);
            support.addColumn((Column)column);
        });
    }

    private void fillAccountsContextMenu(IMenuManager manager) {
        Account account = (Account)((IStructuredSelection)this.accounts.getSelection()).getFirstElement();
        if (account == null) {
            return;
        }
        this.accountMenu.menuAboutToShow(manager, account, null);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new SimpleAction(Messages.AccountMenuImportCSV, a -> ImportCSVHandler.runImport(this.getPart(), Display.getDefault().getActiveShell(), this.getContext(), null, null, this.getClient(), account, null)));
        manager.add((IAction)new SimpleAction(Messages.AccountMenuImportPDF, a -> ImportPDFHandler.runImport(this.getPart(), Display.getDefault().getActiveShell(), this.getClient(), account, null)));
        manager.add((IAction)new SimpleAction(account.isRetired() ? Messages.AccountMenuActivate : Messages.AccountMenuDeactivate, a -> {
            account.setRetired(!account.isRetired());
            this.markDirty();
            this.resetInput();
        }));
        manager.add((IAction)new ConfirmAction(Messages.AccountMenuDelete, MessageFormat.format(Messages.AccountMenuDeleteConfirm, account.getName()), a -> {
            this.getClient().removeAccount(account);
            this.markDirty();
            this.resetInput();
        }));
    }

    @Override
    protected void createBottomTable(Composite parent) {
        CTabFolder folder = new CTabFolder(parent, 2048);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(Messages.TabTransactions);
        item.setControl(this.createTransactionTable((Composite)folder));
        item = new CTabItem(folder, 0);
        item.setText(Messages.TabAccountBalanceChart);
        this.accountBalanceChart = new AccountBalanceChart((Composite)folder);
        folder.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.accountBalanceChart.updateChart((Account)this.accounts.getStructuredSelection().getFirstElement(), this.exchangeRateProviderFactory)));
        item.setControl((Control)this.accountBalanceChart);
        this.accounts.addSelectionChangedListener(event -> {
            Account account = (Account)((IStructuredSelection)event.getSelection()).getFirstElement();
            this.updateOnAccountSelected(account);
            this.transactions.setData(Account.class.toString(), (Object)account);
            this.transactions.setInput((Object)(account != null ? account.getTransactions() : new ArrayList(0)));
            this.transactions.refresh();
        });
        folder.setSelection(0);
        if (this.accounts.getTable().getItemCount() > 0) {
            this.accounts.setSelection((ISelection)new StructuredSelection(this.accounts.getElementAt(0)), true);
        }
    }

    protected Control createTransactionTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.transactions = new TableViewer(container, 65538);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.transactions, (int)2);
        ColumnEditingSupport.prepare((ColumnViewer)this.transactions);
        this.transactionsColumns = new ShowHideColumnHelper(String.valueOf(AccountListView.class.getSimpleName()) + "@bottom5", this.getPreferenceStore(), this.transactions, layout);
        Column column = new Column("0", Messages.ColumnDate, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return Values.DateTime.format((Object)((AccountTransaction)e).getDateTime());
            }

            public Color getForeground(Object element) {
                return AccountListView.this.colorFor((AccountTransaction)element);
            }
        });
        ColumnViewerSorter.create((Comparator<? extends Object>)new AccountTransaction.ByDateAmountTypeAndHashCode()).attachTo(column, 1024);
        new DateTimeEditingSupport(AccountTransaction.class, "dateTime").addListener(this).attachTo(column);
        this.transactionsColumns.addColumn(column);
        column = new Column("1", Messages.ColumnTransactionType, 0, 100);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                AccountTransaction t = (AccountTransaction)e;
                return t.getType().toString();
            }

            public Color getForeground(Object element) {
                return AccountListView.this.colorFor((AccountTransaction)element);
            }
        });
        column.setSorter(ColumnViewerSorter.create(AccountTransaction.class, "type"));
        new TransactionTypeEditingSupport(this.getClient()).addListener(this).attachTo(column);
        this.transactionsColumns.addColumn(column);
        column = new Column("2", Messages.ColumnAmount, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                AccountTransaction t = (AccountTransaction)e;
                long v = t.getAmount();
                if (t.getType().isDebit()) {
                    v = -v;
                }
                return Values.Money.format(Money.of((String)t.getCurrencyCode(), (long)v), AccountListView.this.getClient().getBaseCurrency());
            }

            public Color getForeground(Object element) {
                return AccountListView.this.colorFor((AccountTransaction)element);
            }
        });
        column.setSorter(ColumnViewerSorter.create((o1, o2) -> {
            AccountTransaction accountTransaction1 = (AccountTransaction)o1;
            long transactionAmount1 = accountTransaction1.getAmount();
            if (accountTransaction1.getType().isDebit()) {
                transactionAmount1 = -transactionAmount1;
            }
            AccountTransaction accountTransaction2 = (AccountTransaction)o2;
            long transactionAmount2 = accountTransaction2.getAmount();
            if (accountTransaction2.getType().isDebit()) {
                transactionAmount2 = -transactionAmount2;
            }
            return Long.compare(transactionAmount1, transactionAmount2);
        }));
        this.transactionsColumns.addColumn(column);
        column = new Column("3", Messages.Balance, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Money balance = AccountListView.this.transaction2balance.get(e);
                return balance != null ? Values.Money.format(balance, AccountListView.this.getClient().getBaseCurrency()) : null;
            }
        });
        column.setSorter(ColumnViewerSorter.create((o1, o2) -> {
            Money m1 = this.transaction2balance.get(o1);
            Money m2 = this.transaction2balance.get(o2);
            return m1.compareTo(m2);
        }));
        this.transactionsColumns.addColumn(column);
        column = new Column("4", Messages.ColumnSecurity, 0, 250);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                AccountTransaction t = (AccountTransaction)e;
                return t.getSecurity() != null ? String.valueOf(t.getSecurity()) : null;
            }

            public Color getForeground(Object element) {
                return AccountListView.this.colorFor((AccountTransaction)element);
            }

            public Image getImage(Object e) {
                AccountTransaction t = (AccountTransaction)e;
                return LogoManager.instance().getDefaultColumnImage(t.getSecurity(), AccountListView.this.getClient().getSettings());
            }
        });
        column.setSorter(ColumnViewerSorter.create(AccountTransaction.class, "security"));
        this.transactionsColumns.addColumn(column);
        column = new IsinColumn();
        column.setVisible(false);
        column.getEditingSupport().addListener(this);
        this.transactionsColumns.addColumn(column);
        column = new SymbolColumn();
        column.setVisible(false);
        column.getEditingSupport().addListener(this);
        this.transactionsColumns.addColumn(column);
        column = new WknColumn();
        column.setVisible(false);
        column.getEditingSupport().addListener(this);
        this.transactionsColumns.addColumn(column);
        column = new Column("5", Messages.ColumnShares, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new SharesLabelProvider(){

            @Override
            public Long getValue(Object e) {
                AccountTransaction t = (AccountTransaction)e;
                if (t.getCrossEntry() instanceof BuySellEntry) {
                    return ((BuySellEntry)t.getCrossEntry()).getPortfolioTransaction().getShares();
                }
                if (t.getType() == AccountTransaction.Type.DIVIDENDS && t.getShares() != 0L) {
                    return t.getShares();
                }
                return null;
            }

            @Override
            public Color getForeground(Object element) {
                return AccountListView.this.colorFor((AccountTransaction)element);
            }
        });
        new ValueEditingSupport(AccountTransaction.class, "shares", Values.Share){

            @Override
            public boolean canEdit(Object element) {
                AccountTransaction t = (AccountTransaction)element;
                return t.getType() == AccountTransaction.Type.DIVIDENDS;
            }
        }.addListener(this).attachTo(column);
        this.transactionsColumns.addColumn(column);
        column = new CalculatedQuoteColumn("6", this.getClient(), e -> {
            AccountTransaction t = (AccountTransaction)e;
            if (t.getCrossEntry() instanceof BuySellEntry) {
                PortfolioTransaction pt = ((BuySellEntry)t.getCrossEntry()).getPortfolioTransaction();
                return pt.getGrossPricePerShare();
            }
            if (t.getType() == AccountTransaction.Type.DIVIDENDS && t.getShares() != 0L) {
                long perShare = Math.round((double)t.getGrossValueAmount() * Values.Share.divider() * (double)Values.Quote.factorToMoney() / (double)t.getShares());
                return Quote.of((String)t.getCurrencyCode(), (long)perShare);
            }
            return null;
        }, element -> this.colorFor((AccountTransaction)element));
        this.transactionsColumns.addColumn(column);
        column = new Column("7", Messages.ColumnOffsetAccount, 0, 120);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                AccountTransaction t = (AccountTransaction)e;
                return t.getCrossEntry() != null ? t.getCrossEntry().getCrossOwner((Transaction)t).toString() : null;
            }

            public Color getForeground(Object element) {
                return AccountListView.this.colorFor((AccountTransaction)element);
            }

            public Image getImage(Object e) {
                AccountTransaction t = (AccountTransaction)e;
                return t.getCrossEntry() != null ? LogoManager.instance().getDefaultColumnImage(t.getCrossEntry().getCrossOwner((Transaction)t), AccountListView.this.getClient().getSettings()) : null;
            }
        });
        new TransactionOwnerListEditingSupport(this.getClient(), TransactionOwnerListEditingSupport.EditMode.CROSSOWNER).addListener(this).attachTo(column);
        this.transactionsColumns.addColumn(column);
        column = new NoteColumn("8");
        column.getEditingSupport().addListener(this);
        this.transactionsColumns.addColumn(column);
        this.transactionsColumns.createColumns();
        this.transactions.getTable().setHeaderVisible(true);
        this.transactions.getTable().setLinesVisible(true);
        this.transactions.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.hookContextMenu((Control)this.transactions.getTable(), this::fillTransactionsContextMenu);
        this.hookKeyListener();
        return container;
    }

    private Color colorFor(AccountTransaction t) {
        return t.getType().isDebit() ? Colors.theme().redForeground() : Colors.theme().greenForeground();
    }

    private void hookKeyListener() {
        this.transactions.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 101 && e.stateMask == SWT.MOD1) {
                    Account account = (Account)AccountListView.this.transactions.getData(Account.class.toString());
                    AccountTransaction transaction = (AccountTransaction)((IStructuredSelection)AccountListView.this.transactions.getSelection()).getFirstElement();
                    if (account != null && transaction != null) {
                        AccountListView.this.createEditAction(account, transaction).run();
                    }
                }
            }
        });
    }

    private void fillTransactionsContextMenu(IMenuManager manager) {
        Account account = (Account)this.transactions.getData(Account.class.toString());
        if (account == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.transactions.getSelection();
        AccountTransaction transaction = (AccountTransaction)selection.getFirstElement();
        if (transaction != null) {
            Action action = this.createEditAction(account, transaction);
            action.setAccelerator(SWT.MOD1 | 0x45);
            manager.add((IAction)action);
            manager.add((IContributionItem)new Separator());
        }
        this.accountMenu.menuAboutToShow(manager, account, transaction != null ? transaction.getSecurity() : null);
        if (!selection.isEmpty()) {
            this.fillTransactionsContextMenuList(manager, selection);
        }
        if (transaction != null) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new Action(Messages.AccountMenuDeleteTransaction){

                public void run() {
                    Object[] selection = ((IStructuredSelection)AccountListView.this.transactions.getSelection()).toArray();
                    Account account = (Account)AccountListView.this.transactions.getData(Account.class.toString());
                    if (selection == null || selection.length == 0 || account == null) {
                        return;
                    }
                    Object[] objectArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object transaction = objectArray[n2];
                        account.deleteTransaction((Transaction)((AccountTransaction)transaction), AccountListView.this.getClient());
                        ++n2;
                    }
                    AccountListView.this.markDirty();
                    AccountListView.this.transaction2balance.clear();
                    AccountListView.this.updateBalance(account);
                    AccountListView.this.accounts.refresh();
                    AccountListView.this.transactions.setInput((Object)account.getTransactions());
                }
            });
        }
    }

    private void fillTransactionsContextMenuList(IMenuManager manager, IStructuredSelection selection) {
        ArrayList<AccountTransaction> accountTxCollection = new ArrayList<AccountTransaction>(selection.size());
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            accountTxCollection.add((AccountTransaction)it.next());
        }
        boolean allTransfer = true;
        for (AccountTransaction tx : accountTxCollection) {
            allTransfer &= tx.getType() == AccountTransaction.Type.TRANSFER_IN || tx.getType() == AccountTransaction.Type.TRANSFER_OUT;
        }
        if (allTransfer) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new ConvertTransferToDepositRemovalAction(this.getClient(), accountTxCollection));
        }
    }

    private Action createEditAction(Account account, AccountTransaction transaction) {
        if (transaction.getCrossEntry() instanceof BuySellEntry) {
            BuySellEntry entry = (BuySellEntry)transaction.getCrossEntry();
            return new OpenDialogAction(this, Messages.MenuEditTransaction).type(SecurityTransactionDialog.class, d -> d.setBuySellEntry(entry)).parameters(entry.getPortfolioTransaction().getType());
        }
        if (transaction.getCrossEntry() instanceof AccountTransferEntry) {
            AccountTransferEntry entry = (AccountTransferEntry)transaction.getCrossEntry();
            return new OpenDialogAction(this, Messages.MenuEditTransaction).type(AccountTransferDialog.class, d -> d.setEntry(entry));
        }
        return new OpenDialogAction(this, Messages.MenuEditTransaction).type(AccountTransactionDialog.class, d -> d.setTransaction(account, transaction)).parameters(transaction.getType());
    }

    private void updateOnAccountSelected(Account account) {
        this.updateBalance(account);
        this.accountBalanceChart.updateChart(account, this.exchangeRateProviderFactory);
    }

    private void updateBalance(Account account) {
        this.transaction2balance.clear();
        if (account == null) {
            return;
        }
        ArrayList tx = new ArrayList(account.getTransactions());
        Collections.sort(tx, new AccountTransaction.ByDateAmountTypeAndHashCode());
        MutableMoney balance = MutableMoney.of((String)account.getCurrencyCode());
        for (AccountTransaction t : tx) {
            switch (t.getType()) {
                case DEPOSIT: 
                case INTEREST: 
                case DIVIDENDS: 
                case FEES_REFUND: 
                case TAX_REFUND: 
                case SELL: 
                case TRANSFER_IN: {
                    balance.add(t.getMonetaryAmount());
                    break;
                }
                case REMOVAL: 
                case INTEREST_CHARGE: 
                case FEES: 
                case TAXES: 
                case BUY: 
                case TRANSFER_OUT: {
                    balance.subtract(t.getMonetaryAmount());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.transaction2balance.put(t, balance.toMoney());
        }
    }
}

