/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import com.google.common.primitives.Doubles;
import java.lang.invoke.LambdaMetafactory;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.util.chart.TimelineChart;
import name.abuchen.portfolio.ui.views.ChartLineSeriesAxes;
import name.abuchen.portfolio.ui.views.SecuritiesChart;

public class BollingerBands {
    public static final int MIN_AVERAGE_PRICES_PER_WEEK = 2;
    private int BollingerBandsDays;
    private double BollingerBandsFactor;
    private Security security;
    private SecuritiesChart.ChartInterval interval;
    private ChartLineSeriesAxes BollingerBandsLowerBand;
    private ChartLineSeriesAxes BollingerBandsMiddleBand;
    private ChartLineSeriesAxes BollingerBandsUpperBand;
    private int calculatedMinimumDays;
    private List<SecurityPrice> prices;
    private List<LocalDate> datesBollingerBands;
    private List<Double> valuesBollingerBandsLowerBands;
    private List<Double> valuesBollingerBandsMiddleBands;
    private List<Double> valuesBollingerBandsUpperBands;

    public BollingerBands(int BollingerBandsDays, double BollingerBandsFactor, Security security, SecuritiesChart.ChartInterval interval) {
        this.BollingerBandsDays = BollingerBandsDays;
        this.BollingerBandsFactor = BollingerBandsFactor;
        this.security = security;
        this.interval = interval;
        this.BollingerBandsLowerBand = new ChartLineSeriesAxes();
        this.BollingerBandsMiddleBand = new ChartLineSeriesAxes();
        this.BollingerBandsUpperBand = new ChartLineSeriesAxes();
        this.datesBollingerBands = new ArrayList<LocalDate>();
        this.valuesBollingerBandsLowerBands = new ArrayList<Double>();
        this.valuesBollingerBandsMiddleBands = new ArrayList<Double>();
        this.valuesBollingerBandsUpperBands = new ArrayList<Double>();
        this.calculatedMinimumDays = this.getMinimumDaysForBollingerBands();
        this.calculateBollingerBands();
    }

    public ChartLineSeriesAxes getLowerBand() {
        return this.BollingerBandsLowerBand;
    }

    public ChartLineSeriesAxes getMiddleBand() {
        return this.BollingerBandsMiddleBand;
    }

    public ChartLineSeriesAxes getUpperBand() {
        return this.BollingerBandsUpperBand;
    }

    /*
     * Unable to fully structure code
     */
    private void calculateBollingerBands() {
        if (this.security == null) {
            return;
        }
        this.prices = this.security.getPricesIncludingLatest();
        if (this.prices == null || this.prices.size() < this.BollingerBandsDays + 3) {
            return;
        }
        startPrice = this.getStartPriceFromStartDate();
        if (startPrice == null) {
            return;
        }
        index = this.prices.indexOf(startPrice);
        if (index < this.prices.size()) ** GOTO lbl36
        return;
        while (!(date = this.prices.get(index).getDate()).isAfter(this.interval.getEnd())) {
            if (index >= this.BollingerBandsDays && (filteredPrices = this.getFilteredList(isBefore = (nextDate = this.prices.get(index).getDate()).plusDays(1L), isAfter = this.prices.get(index - this.BollingerBandsDays + 2).getDate())).size() >= this.calculatedMinimumDays) {
                sum = filteredPrices.stream().mapToLong((ToLongFunction<SecurityPrice>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)J, getValue(), (Lname/abuchen/portfolio/model/SecurityPrice;)J)()).sum();
                QuotePriceAverage = sum / Values.Quote.divider() / (double)filteredPrices.size();
                tempQuotePriceVariance = 0.0;
                i = 0;
                while (i < filteredPrices.size()) {
                    tempQuotePriceVariance += ((double)filteredPrices.get(i).getValue() / Values.Quote.divider() - QuotePriceAverage) * ((double)filteredPrices.get(i).getValue() / Values.Quote.divider() - QuotePriceAverage);
                    ++i;
                }
                StandardDeviationBollingerBands = Math.sqrt(tempQuotePriceVariance / (double)(filteredPrices.size() - 1)) * this.BollingerBandsFactor;
                valueBollingerBandsLowerBands = QuotePriceAverage;
                valueBollingerBandsUpperBands = QuotePriceAverage;
                valueBollingerBandsLowerBands = valueBollingerBandsLowerBands - StandardDeviationBollingerBands;
                valueBollingerBandsUpperBands = valueBollingerBandsUpperBands + StandardDeviationBollingerBands;
                this.valuesBollingerBandsLowerBands.add(valueBollingerBandsLowerBands);
                this.valuesBollingerBandsMiddleBands.add(QuotePriceAverage);
                this.valuesBollingerBandsUpperBands.add(valueBollingerBandsUpperBands);
                this.datesBollingerBands.add(date);
            }
            ++index;
lbl36:
            // 2 sources

            if (index < this.prices.size()) continue;
        }
        tmpDates = TimelineChart.toJavaUtilDate(this.datesBollingerBands.toArray(new LocalDate[0]));
        this.BollingerBandsLowerBand.setDates(tmpDates);
        this.BollingerBandsLowerBand.setValues(Doubles.toArray(this.valuesBollingerBandsLowerBands));
        this.BollingerBandsMiddleBand.setDates(tmpDates);
        this.BollingerBandsMiddleBand.setValues(Doubles.toArray(this.valuesBollingerBandsMiddleBands));
        this.BollingerBandsUpperBand.setDates(tmpDates);
        this.BollingerBandsUpperBand.setValues(Doubles.toArray(this.valuesBollingerBandsUpperBands));
    }

    public int getMinimumDaysForBollingerBands() {
        int weeks = this.BollingerBandsDays / 7;
        int minDays = weeks * 2;
        return minDays > 0 ? minDays : 1;
    }

    public SecurityPrice getStartPriceFromStartDate() {
        int index = Math.abs(Collections.binarySearch(this.prices, new SecurityPrice(this.interval.getStart(), 0L), new SecurityPrice.ByDate()));
        if (index >= this.prices.size()) {
            return null;
        }
        return this.determineStartPrice(this.interval.getStart());
    }

    public SecurityPrice getStartPrice() {
        LocalDate BollingerBandsPeriodEnd = this.prices.get(0).getDate().plusDays((long)this.BollingerBandsDays - 1L);
        int index = Math.abs(Collections.binarySearch(this.prices, new SecurityPrice(BollingerBandsPeriodEnd, 0L), new SecurityPrice.ByDate()));
        if (index >= this.prices.size()) {
            return null;
        }
        return this.determineStartPrice(BollingerBandsPeriodEnd);
    }

    private SecurityPrice determineStartPrice(LocalDate BollingerBandsPeriodEnd) {
        List<SecurityPrice> filteredPrices = null;
        LocalDate isBefore = BollingerBandsPeriodEnd.plusDays(1L);
        LocalDate isAfter = BollingerBandsPeriodEnd.minusDays(this.BollingerBandsDays);
        LocalDate lastDate = this.prices.get(this.prices.size() - 1).getDate();
        filteredPrices = this.getFilteredList(isBefore, isAfter);
        int i = 1;
        while (!this.checkListIsValidForBollingerBands(filteredPrices)) {
            if (isBefore.plusDays(i).isAfter(lastDate) || isAfter.plusDays(i).isAfter(lastDate)) {
                return null;
            }
            filteredPrices = this.getFilteredList(isBefore.plusDays(i), isAfter.plusDays(i));
            ++i;
        }
        return filteredPrices.get(filteredPrices.size() - 1);
    }

    private boolean checkListIsValidForBollingerBands(List<SecurityPrice> filteredPrices) {
        return filteredPrices.size() >= this.calculatedMinimumDays;
    }

    private List<SecurityPrice> getFilteredList(LocalDate isBefore, LocalDate isAfter) {
        return this.prices.stream().filter(p -> p.getDate().isAfter(isAfter) && p.getDate().isBefore(isBefore)).collect(Collectors.toList());
    }
}

