/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import com.google.common.primitives.Doubles;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.util.chart.TimelineChart;
import name.abuchen.portfolio.ui.views.ChartLineSeriesAxes;
import name.abuchen.portfolio.ui.views.SecuritiesChart;

public class ExponentialMovingAverage {
    private int rangeEMA;
    private double smoothingFactor;
    private Security security;
    private SecuritiesChart.ChartInterval interval;
    private ChartLineSeriesAxes result;

    public ExponentialMovingAverage(int rangeEMA, Security security, SecuritiesChart.ChartInterval interval) {
        this.rangeEMA = rangeEMA;
        this.smoothingFactor = 2.0 / (double)(this.rangeEMA + 1);
        this.security = security;
        this.interval = Objects.requireNonNull(interval);
        this.result = new ChartLineSeriesAxes();
        this.calculateEMA();
    }

    public ChartLineSeriesAxes getEMA() {
        return this.result;
    }

    private void calculateEMA() {
        if (this.security == null) {
            return;
        }
        List prices = this.security.getPricesIncludingLatest();
        if (prices == null) {
            return;
        }
        int index = Collections.binarySearch(prices, new SecurityPrice(this.interval.getStart(), 0L), new SecurityPrice.ByDate());
        if (index < 0) {
            index = -index - 1;
        }
        if (index >= prices.size()) {
            return;
        }
        ArrayList<LocalDate> datesEMA = new ArrayList<LocalDate>();
        ArrayList<Double> valuesEMA = new ArrayList<Double>();
        double ema = (double)((SecurityPrice)prices.get(index)).getValue() / Values.Quote.divider();
        int i = 0;
        while (i < prices.size()) {
            LocalDate date = ((SecurityPrice)prices.get(i)).getDate();
            if (date.isAfter(this.interval.getEnd())) break;
            ema = (double)((SecurityPrice)prices.get(i)).getValue() / Values.Quote.divider() * this.smoothingFactor + ema * (1.0 - this.smoothingFactor);
            if (!date.isBefore(this.interval.getStart())) {
                valuesEMA.add(ema);
                datesEMA.add(date);
            }
            ++i;
        }
        this.result.setDates(TimelineChart.toJavaUtilDate(datesEMA.toArray(new LocalDate[0])));
        this.result.setValues(Doubles.toArray(valuesEMA));
    }
}

