/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import com.ibm.icu.text.MessageFormat;
import java.time.LocalDate;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.ClientSnapshot;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.util.ClientFilterDropDown;
import name.abuchen.portfolio.ui.util.EmbeddedBrowser;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.util.ColorConversion;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.json.simple.JSONObject;

public class HoldingsPieChartView
extends AbstractFinanceView {
    private static final String ID_WARNING_TOOL_ITEM = "warning";
    private CurrencyConverter converter;
    private EmbeddedBrowser browser;
    private ClientFilterDropDown clientFilter;
    private ClientSnapshot snapshot;

    @PostConstruct
    protected void contruct(ExchangeRateProviderFactory factory) {
        this.converter = new CurrencyConverterImpl(factory, this.getClient().getBaseCurrency());
        this.clientFilter = new ClientFilterDropDown(this.getClient(), this.getPreferenceStore(), HoldingsPieChartView.class.getSimpleName(), filter -> this.notifyModelUpdated());
        Client filteredClient = this.clientFilter.getSelectedFilter().filter(this.getClient());
        this.snapshot = ClientSnapshot.create((Client)filteredClient, (CurrencyConverter)this.converter, (LocalDate)LocalDate.now());
    }

    @Override
    protected String getDefaultTitle() {
        return Messages.LabelStatementOfAssetsHoldings;
    }

    @Override
    public void notifyModelUpdated() {
        Client filteredClient = this.clientFilter.getSelectedFilter().filter(this.getClient());
        this.snapshot = ClientSnapshot.create((Client)filteredClient, (CurrencyConverter)this.converter, (LocalDate)LocalDate.now());
        this.browser.refresh();
        this.updateWarningInToolBar();
    }

    @Override
    protected void addButtons(ToolBarManager toolBar) {
        toolBar.add((IContributionItem)this.clientFilter);
    }

    @Override
    protected Control createBody(Composite parent) {
        this.browser = this.make(EmbeddedBrowser.class, new Object[0]);
        this.browser.setHtmlpage("/META-INF/html/pie.html");
        this.updateWarningInToolBar();
        return this.browser.createControl(parent, b -> {
            LoadDataFunction loadDataFunction = new LoadDataFunction((Browser)b, "loadData");
        });
    }

    private void updateWarningInToolBar() {
        boolean hasNegativePositions = this.snapshot.getAssetPositions().anyMatch(p -> p.getValuation().isNegative());
        ToolBarManager toolBar = this.getToolBarManager();
        if (hasNegativePositions) {
            if (toolBar.find(ID_WARNING_TOOL_ITEM) == null) {
                SimpleAction warning = new SimpleAction(Messages.HoldingsWarningAssetsWithNegativeValuation, Images.ERROR_NOTICE.descriptor(), a -> {
                    String details = String.join((CharSequence)"\n", this.snapshot.getAssetPositions().filter(p -> p.getValuation().isNegative()).map(p -> String.valueOf(p.getDescription()) + " " + Values.Money.format(p.getValuation())).collect(Collectors.toList()));
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelError, (String)MessageFormat.format((String)Messages.HoldingsWarningAssetsWithNegativeValuationDetails, (Object[])new Object[]{Values.Money.format(this.snapshot.getMonetaryAssets()), details}));
                });
                warning.setId(ID_WARNING_TOOL_ITEM);
                toolBar.insert(0, (IContributionItem)new ActionContributionItem((IAction)warning));
                toolBar.update(true);
            }
        } else if (toolBar.remove(ID_WARNING_TOOL_ITEM) != null) {
            toolBar.update(true);
        }
    }

    private static final class JSColors {
        private static final int SIZE = 11;
        private static final float STEP = 32.727272f;
        private static final float HUE = 262.3f;
        private static final float SATURATION = 0.464f;
        private static final float BRIGHTNESS = 0.886f;
        private int nextSlice = 0;

        private JSColors() {
        }

        public String next() {
            float brightness = Math.min(1.0f, 0.886f + 0.05f * ((float)this.nextSlice / 11.0f));
            return ColorConversion.toHex((float)((262.3f + 32.727272f * (float)this.nextSlice++) % 360.0f), (float)0.464f, (float)brightness);
        }
    }

    private final class LoadDataFunction
    extends BrowserFunction {
        private static final String ENTRY = "{\"label\":\"%s\",\"value\":%s,\"color\":\"%s\",\"caption\":\"<b>%s</b> (%s)<br>%s x %s = %s\",\"valueLabel\":\"%s\"}";

        private LoadDataFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            try {
                StringJoiner joiner = new StringJoiner(",", "[", "]");
                JSColors colors = new JSColors();
                HoldingsPieChartView.this.snapshot.getAssetPositions().filter(p -> p.getValuation().getAmount() > 0L).sorted((l, r) -> Long.compare(r.getValuation().getAmount(), l.getValuation().getAmount())).forEach(p -> {
                    String name = JSONObject.escape((String)p.getDescription());
                    String percentage = Values.Percent2.format((Object)p.getShare());
                    joiner.add(String.format(ENTRY, name, p.getValuation().getAmount(), colors.next(), name, percentage, Values.Share.format((Object)p.getPosition().getShares()), Values.Money.format(p.getValuation().multiply((long)Values.Share.divider()).divide(p.getPosition().getShares())), Values.Money.format(p.getValuation()), percentage));
                });
                return joiner.toString();
            }
            catch (Throwable e) {
                PortfolioPlugin.log(e);
                return "[]";
            }
        }
    }
}

