/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import javax.annotation.PostConstruct;
import name.abuchen.portfolio.snapshot.Aggregation;
import name.abuchen.portfolio.snapshot.PerformanceIndex;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.AbstractCSVExporter;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.chart.TimelineChart;
import name.abuchen.portfolio.ui.util.chart.TimelineChartCSVExporter;
import name.abuchen.portfolio.ui.views.AbstractHistoricView;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesCache;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesChartLegend;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesConfigurator;
import name.abuchen.portfolio.ui.views.dataseries.PerformanceChartSeriesBuilder;
import name.abuchen.portfolio.util.Interval;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.swtchart.ISeries;

public class PerformanceChartView
extends AbstractHistoricView {
    private static final String KEY_AGGREGATION_PERIOD = "performance-chart-aggregation-period";
    private TimelineChart chart;
    private DataSeriesConfigurator picker;
    private Aggregation.Period aggregationPeriod;
    private PerformanceChartSeriesBuilder seriesBuilder;

    @Override
    protected String getDefaultTitle() {
        return Messages.LabelPerformanceChart;
    }

    @PostConstruct
    public void setup() {
        String key = this.getPreferenceStore().getString(KEY_AGGREGATION_PERIOD);
        if (key != null && key.length() > 0) {
            try {
                this.aggregationPeriod = Aggregation.Period.valueOf((String)key);
            }
            catch (IllegalArgumentException ignore) {
                PortfolioPlugin.log(ignore);
            }
        }
    }

    @Override
    protected void addButtons(ToolBarManager toolBar) {
        super.addButtons(toolBar);
        toolBar.add((IContributionItem)new AggregationPeriodDropDown());
        toolBar.add((IContributionItem)new ExportDropDown());
        toolBar.add((IContributionItem)new DropDown(Messages.MenuConfigureChart, Images.CONFIG, 0, manager -> this.picker.configMenuAboutToShow(manager)));
    }

    protected Composite createBody(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(Display.getDefault().getSystemColor(1));
        this.chart = new TimelineChart(composite);
        this.chart.getTitle().setText(this.getTitle());
        this.chart.getTitle().setVisible(false);
        this.chart.getAxisSet().getYAxis(0).getTick().setFormat((Format)new DecimalFormat("0.#%"));
        this.chart.getToolTip().setValueFormat(new DecimalFormat("0.00%"));
        this.chart.getToolTip().reverseLabels(true);
        DataSeriesCache cache = this.make(DataSeriesCache.class, new Object[0]);
        this.seriesBuilder = new PerformanceChartSeriesBuilder(this.chart, cache);
        this.picker = new DataSeriesConfigurator(this, DataSeries.UseCase.PERFORMANCE);
        this.picker.addListener(this::updateChart);
        this.picker.setToolBarManager(this.getViewToolBarManager());
        DataSeriesChartLegend legend = new DataSeriesChartLegend(composite, this.picker);
        this.updateTitle(String.valueOf(Messages.LabelPerformanceChart) + " (" + this.picker.getConfigurationName() + ")");
        this.chart.getTitle().setText(this.getTitle());
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(0, 0).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.chart);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 4).applyTo((Control)legend);
        this.setChartSeries();
        return composite;
    }

    @Override
    public void setFocus() {
        this.chart.adjustRange();
        this.chart.setFocus();
    }

    @Override
    public void reportingPeriodUpdated() {
        this.notifyModelUpdated();
    }

    @Override
    public void notifyModelUpdated() {
        this.seriesBuilder.getCache().clear();
        this.updateChart();
    }

    private void updateChart() {
        try {
            this.updateTitle(String.valueOf(Messages.LabelPerformanceChart) + " (" + this.picker.getConfigurationName() + ")");
            this.chart.suspendUpdate(true);
            this.chart.getTitle().setText(this.getTitle());
            ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries s = iSeriesArray[n2];
                this.chart.getSeriesSet().deleteSeries(s.getId());
                ++n2;
            }
            this.setChartSeries();
            this.chart.adjustRange();
        }
        finally {
            this.chart.suspendUpdate(false);
        }
        this.chart.redraw();
        this.chart.getParent().layout(true);
    }

    private void setChartSeries() {
        Interval interval = this.getReportingPeriod().toInterval(LocalDate.now());
        Lists.reverse(this.picker.getSelectedDataSeries()).forEach(series -> this.seriesBuilder.build((DataSeries)series, interval, this.aggregationPeriod));
    }

    private final class AggregationPeriodDropDown
    extends DropDown
    implements IMenuListener {
        private AggregationPeriodDropDown() {
            super(PerformanceChartView.this.aggregationPeriod == null ? Messages.LabelAggregationDaily : PerformanceChartView.this.aggregationPeriod.toString());
            this.setMenuListener(this);
        }

        public void menuAboutToShow(IMenuManager manager) {
            Action daily = new Action(Messages.LabelAggregationDaily){

                public void run() {
                    AggregationPeriodDropDown.this.setLabel(Messages.LabelAggregationDaily);
                    ((AggregationPeriodDropDown)AggregationPeriodDropDown.this).PerformanceChartView.this.aggregationPeriod = null;
                    PerformanceChartView.this.getPart().getPreferenceStore().setValue(PerformanceChartView.KEY_AGGREGATION_PERIOD, "");
                    PerformanceChartView.this.updateChart();
                }
            };
            daily.setChecked(PerformanceChartView.this.aggregationPeriod == null);
            manager.add((IAction)daily);
            Aggregation.Period[] periodArray = Aggregation.Period.values();
            int n = periodArray.length;
            int n2 = 0;
            while (n2 < n) {
                final Aggregation.Period period = periodArray[n2];
                Action action = new Action(period.toString()){

                    public void run() {
                        AggregationPeriodDropDown.this.setLabel(period.toString());
                        ((AggregationPeriodDropDown)AggregationPeriodDropDown.this).PerformanceChartView.this.aggregationPeriod = period;
                        PerformanceChartView.this.getPart().getPreferenceStore().setValue(PerformanceChartView.KEY_AGGREGATION_PERIOD, period.name());
                        PerformanceChartView.this.updateChart();
                    }
                };
                action.setChecked(PerformanceChartView.this.aggregationPeriod == period);
                manager.add((IAction)action);
                ++n2;
            }
        }
    }

    private final class ExportDropDown
    extends DropDown
    implements IMenuListener {
        private ExportDropDown() {
            super(Messages.MenuExportData, Images.EXPORT, 0);
            this.setMenuListener(this);
        }

        public void menuAboutToShow(IMenuManager manager) {
            manager.add((IAction)new Action(Messages.MenuExportChartData){

                public void run() {
                    TimelineChartCSVExporter exporter = new TimelineChartCSVExporter(((ExportDropDown)ExportDropDown.this).PerformanceChartView.this.chart);
                    exporter.addDiscontinousSeries(Messages.PerformanceChartLabelCPI);
                    exporter.setDateFormat(new SimpleDateFormat("yyyy-MM-dd"));
                    exporter.setValueFormat(new DecimalFormat("0.##########"));
                    exporter.export(String.valueOf(PerformanceChartView.this.getTitle()) + ".csv");
                }
            });
            PerformanceChartView.this.picker.getSelectedDataSeries().stream().forEach(ds -> this.addMenu(manager, (DataSeries)ds));
            manager.add((IContributionItem)new Separator());
            PerformanceChartView.this.chart.exportMenuAboutToShow(manager, PerformanceChartView.this.getTitle());
        }

        private void addMenu(IMenuManager manager, final DataSeries series) {
            manager.add((IAction)new SimpleAction(MessageFormat.format(Messages.LabelExport, series.getLabel()), a -> {
                AbstractCSVExporter exporter = new AbstractCSVExporter(){

                    @Override
                    protected void writeToFile(File file) throws IOException {
                        PerformanceIndex index = ((ExportDropDown)ExportDropDown.this).PerformanceChartView.this.seriesBuilder.getCache().lookup(series, PerformanceChartView.this.getReportingPeriod().toInterval(LocalDate.now()));
                        if (((ExportDropDown)ExportDropDown.this).PerformanceChartView.this.aggregationPeriod != null) {
                            index = Aggregation.aggregate((PerformanceIndex)index, (Aggregation.Period)((ExportDropDown)ExportDropDown.this).PerformanceChartView.this.aggregationPeriod);
                        }
                        index.exportTo(file);
                    }

                    @Override
                    protected Shell getShell() {
                        return ((ExportDropDown)ExportDropDown.this).PerformanceChartView.this.chart.getShell();
                    }
                };
                exporter.export(String.valueOf(PerformanceChartView.this.getTitle()) + "_" + series.getLabel() + ".csv");
            }));
        }
    }
}

