/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import com.google.common.collect.Lists;
import java.text.Format;
import java.time.LocalDate;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.chart.TimelineChart;
import name.abuchen.portfolio.ui.util.chart.TimelineChartCSVExporter;
import name.abuchen.portfolio.ui.views.AbstractHistoricView;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesCache;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesChartLegend;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesConfigurator;
import name.abuchen.portfolio.ui.views.dataseries.StatementOfAssetsSeriesBuilder;
import name.abuchen.portfolio.util.Interval;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.swtchart.ISeries;

public class StatementOfAssetsHistoryView
extends AbstractHistoricView {
    private TimelineChart chart;
    private DataSeriesConfigurator configurator;
    private StatementOfAssetsSeriesBuilder seriesBuilder;

    @Override
    protected String getDefaultTitle() {
        return Messages.LabelStatementOfAssetsHistory;
    }

    @Override
    protected void addButtons(ToolBarManager toolBar) {
        super.addButtons(toolBar);
        this.addExportButton(toolBar);
        toolBar.add((IContributionItem)new DropDown(Messages.MenuConfigureChart, Images.CONFIG, 0, manager -> this.configurator.configMenuAboutToShow(manager)));
    }

    private void addExportButton(ToolBarManager toolBar) {
        Action export = new Action(){
            private Menu menu;

            public void run() {
                if (this.menu == null) {
                    this.menu = StatementOfAssetsHistoryView.this.createContextMenu((Control)StatementOfAssetsHistoryView.this.getActiveShell(), arg_0 -> StatementOfAssetsHistoryView.access$1(StatementOfAssetsHistoryView.this, arg_0));
                }
                this.menu.setVisible(true);
            }
        };
        export.setImageDescriptor(Images.EXPORT.descriptor());
        export.setToolTipText(Messages.MenuExportData);
        toolBar.add((IAction)export);
    }

    private void exportMenuAboutToShow(IMenuManager manager) {
        manager.add((IAction)new SimpleAction(Messages.MenuExportChartData, a -> {
            TimelineChartCSVExporter exporter = new TimelineChartCSVExporter(this.chart);
            exporter.addDiscontinousSeries(Messages.LabelTransferals);
            exporter.export(String.valueOf(this.getTitle()) + ".csv");
        }));
        manager.add((IContributionItem)new Separator());
        this.chart.exportMenuAboutToShow(manager, this.getTitle());
    }

    protected Composite createBody(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(Display.getDefault().getSystemColor(1));
        this.chart = new TimelineChart(composite);
        this.chart.getTitle().setVisible(false);
        this.chart.getToolTip().reverseLabels(true);
        this.chart.getAxisSet().getYAxis(0).getTick().setFormat((Format)new TimelineChart.ThousandsNumberFormat());
        DataSeriesCache cache = this.make(DataSeriesCache.class, new Object[0]);
        this.seriesBuilder = new StatementOfAssetsSeriesBuilder(this.chart, cache);
        this.configurator = new DataSeriesConfigurator(this, DataSeries.UseCase.STATEMENT_OF_ASSETS);
        this.configurator.addListener(this::updateChart);
        this.configurator.setToolBarManager(this.getViewToolBarManager());
        DataSeriesChartLegend legend = new DataSeriesChartLegend(composite, this.configurator);
        this.updateTitle(String.valueOf(Messages.LabelStatementOfAssetsHistory) + " (" + this.configurator.getConfigurationName() + ")");
        this.chart.getTitle().setText(this.getTitle());
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(0, 0).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.chart);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 4).applyTo((Control)legend);
        Interval interval = this.getReportingPeriod().toInterval(LocalDate.now());
        Lists.reverse(this.configurator.getSelectedDataSeries()).forEach(series -> this.seriesBuilder.build((DataSeries)series, interval));
        return composite;
    }

    @Override
    public void setFocus() {
        try {
            this.chart.setRedraw(false);
            this.chart.adjustRange();
        }
        finally {
            this.chart.setRedraw(true);
        }
        this.chart.setFocus();
    }

    @Override
    public void notifyModelUpdated() {
        this.seriesBuilder.getCache().clear();
        this.updateChart();
    }

    @Override
    public void reportingPeriodUpdated() {
        this.notifyModelUpdated();
    }

    private void updateChart() {
        try {
            this.updateTitle(String.valueOf(Messages.LabelStatementOfAssetsHistory) + " (" + this.configurator.getConfigurationName() + ")");
            this.chart.suspendUpdate(true);
            this.chart.getTitle().setText(this.getTitle());
            ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries s = iSeriesArray[n2];
                this.chart.getSeriesSet().deleteSeries(s.getId());
                ++n2;
            }
            Interval interval = this.getReportingPeriod().toInterval(LocalDate.now());
            Lists.reverse(this.configurator.getSelectedDataSeries()).forEach(series -> this.seriesBuilder.build((DataSeries)series, interval));
            this.chart.adjustRange();
        }
        finally {
            this.chart.suspendUpdate(false);
        }
        this.chart.redraw();
    }

    static /* synthetic */ void access$1(StatementOfAssetsHistoryView statementOfAssetsHistoryView, IMenuManager iMenuManager) {
        statementOfAssetsHistoryView.exportMenuAboutToShow(iMenuManager);
    }
}

