/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Adaptable;
import name.abuchen.portfolio.model.Annotated;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.model.Named;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MoneyCollectors;
import name.abuchen.portfolio.money.Quote;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.AssetCategory;
import name.abuchen.portfolio.snapshot.AssetPosition;
import name.abuchen.portfolio.snapshot.ClientSnapshot;
import name.abuchen.portfolio.snapshot.GroupByTaxonomy;
import name.abuchen.portfolio.snapshot.ReportingPeriod;
import name.abuchen.portfolio.snapshot.SecurityPosition;
import name.abuchen.portfolio.snapshot.filter.ClientFilter;
import name.abuchen.portfolio.snapshot.filter.ReadOnlyPortfolio;
import name.abuchen.portfolio.snapshot.security.SecurityPerformanceIndicator;
import name.abuchen.portfolio.snapshot.security.SecurityPerformanceRecord;
import name.abuchen.portfolio.snapshot.security.SecurityPerformanceSnapshot;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dnd.ImportFromFileDropAdapter;
import name.abuchen.portfolio.ui.dnd.ImportFromURLDropAdapter;
import name.abuchen.portfolio.ui.dnd.SecurityDragListener;
import name.abuchen.portfolio.ui.dnd.SecurityTransfer;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.selection.SecuritySelection;
import name.abuchen.portfolio.ui.selection.SelectionService;
import name.abuchen.portfolio.ui.util.AttributeComparator;
import name.abuchen.portfolio.ui.util.CacheKey;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.OptionLabelProvider;
import name.abuchen.portfolio.ui.util.viewers.ReportingPeriodColumnOptions;
import name.abuchen.portfolio.ui.util.viewers.SharesLabelProvider;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.util.viewers.StringEditingSupport;
import name.abuchen.portfolio.ui.views.AccountContextMenu;
import name.abuchen.portfolio.ui.views.SecurityContextMenu;
import name.abuchen.portfolio.ui.views.columns.AttributeColumn;
import name.abuchen.portfolio.ui.views.columns.IsinColumn;
import name.abuchen.portfolio.ui.views.columns.NameColumn;
import name.abuchen.portfolio.ui.views.columns.NoteColumn;
import name.abuchen.portfolio.ui.views.columns.SymbolColumn;
import name.abuchen.portfolio.ui.views.columns.TaxonomyColumn;
import name.abuchen.portfolio.ui.views.columns.WknColumn;
import name.abuchen.portfolio.util.Interval;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class StatementOfAssetsViewer {
    @Inject
    private IPreferenceStore preference;
    @Inject
    private SelectionService selectionService;
    private boolean useIndirectQuotation = false;
    private TableViewer assets;
    private Font boldFont;
    private Menu contextMenu;
    private AbstractFinanceView owner;
    private ShowHideColumnHelper support;
    private final Client client;
    private Taxonomy taxonomy;
    private Model model;

    @Inject
    public StatementOfAssetsViewer(AbstractFinanceView owner, Client client) {
        this.owner = owner;
        this.client = client;
    }

    @Inject
    public void setUseIndirectQuotation(@Preference(value="USE_INDIRECT_QUOTATION") boolean useIndirectQuotation) {
        this.useIndirectQuotation = useIndirectQuotation;
        if (this.assets != null) {
            this.assets.refresh();
        }
    }

    public Control createControl(Composite parent) {
        Control control = this.createColumns(parent);
        this.assets.getTable().addDisposeListener(e -> this.widgetDisposed());
        return control;
    }

    @PostConstruct
    private void loadTaxonomy() {
        String taxonomyId = this.preference.getString(this.getClass().getSimpleName());
        if (taxonomyId != null) {
            for (Taxonomy t : this.client.getTaxonomies()) {
                if (!taxonomyId.equals(t.getId())) continue;
                this.taxonomy = t;
                break;
            }
        }
        if (this.taxonomy == null && !this.client.getTaxonomies().isEmpty()) {
            this.taxonomy = (Taxonomy)this.client.getTaxonomies().get(0);
        }
    }

    private Control createColumns(Composite parent) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.assets = new TableViewer(container, 65536);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.assets, (int)2);
        ColumnEditingSupport.prepare((ColumnViewer)this.assets);
        ImportFromURLDropAdapter.attach(this.assets.getControl(), this.owner.getPart());
        ImportFromFileDropAdapter.attach(this.assets.getControl(), this.owner.getPart());
        this.assets.addSelectionChangedListener(event -> {
            Element element = (Element)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (element != null && element.isSecurity()) {
                this.selectionService.setSelection(new SecuritySelection(this.client, element.getSecurity()));
            }
        });
        this.support = new ShowHideColumnHelper(StatementOfAssetsViewer.class.getName(), this.client, this.preference, this.assets, layout);
        Column column = new Column("0", Messages.ColumnSharesOwned, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new SharesLabelProvider(){

            @Override
            public Long getValue(Object e) {
                Element element = (Element)e;
                return element.isSecurity() ? Long.valueOf(element.getSecurityPosition().getShares()) : null;
            }
        });
        column.setComparator(new ElementComparator(new AttributeComparator(e -> ((Element)e).isSecurity() ? Long.valueOf(((Element)e).getSecurityPosition().getShares()) : null)));
        this.support.addColumn(column);
        column = new NameColumn(this.client, "1");
        column.setLabelProvider((CellLabelProvider)new NameColumn.NameColumnLabelProvider(this.client){

            @Override
            public String getText(Object e) {
                if (((Element)e).isGroupByTaxonomy()) {
                    return Messages.LabelTotalSum;
                }
                return super.getText(e);
            }

            public Font getFont(Object e) {
                return ((Element)e).isGroupByTaxonomy() || ((Element)e).isCategory() ? StatementOfAssetsViewer.this.boldFont : null;
            }

            @Override
            public Image getImage(Object e) {
                if (((Element)e).isCategory()) {
                    return null;
                }
                return super.getImage(e);
            }
        });
        column.setEditingSupport(new StringEditingSupport(Named.class, "name"){

            @Override
            public boolean canEdit(Object element) {
                boolean isCategory = ((Element)element).isCategory();
                boolean isUnassignedCategory = isCategory && "$unassigned$".equals(((Element)element).getCategory().getClassification().getId());
                return !isUnassignedCategory ? super.canEdit(element) : false;
            }
        }.setMandatory(true).addListener(new ColumnEditingSupport.TouchClientListener(this.client)));
        column.getSorter().wrap(ElementComparator::new);
        this.support.addColumn(column);
        column = new IsinColumn("3");
        column.getEditingSupport().addListener(new ColumnEditingSupport.TouchClientListener(this.client));
        column.getSorter().wrap(ElementComparator::new);
        column.setVisible(false);
        this.support.addColumn(column);
        column = new SymbolColumn("2");
        column.getEditingSupport().addListener(new ColumnEditingSupport.TouchClientListener(this.client));
        column.getSorter().wrap(ElementComparator::new);
        this.support.addColumn(column);
        column = new WknColumn("12");
        column.getEditingSupport().addListener(new ColumnEditingSupport.TouchClientListener(this.client));
        column.getSorter().wrap(ElementComparator::new);
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("4", Messages.ColumnQuote, 131072, 60);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Element element = (Element)e;
                if (!element.isSecurity()) {
                    return null;
                }
                Security security = element.getSecurity();
                return Values.Quote.format(security.getCurrencyCode(), element.getSecurityPosition().getPrice().getValue(), StatementOfAssetsViewer.this.client.getBaseCurrency());
            }
        });
        column.setComparator(new ElementComparator(new AttributeComparator(e -> {
            Element element = (Element)e;
            if (!element.isSecurity()) {
                return null;
            }
            return Money.of((String)element.getSecurity().getCurrencyCode(), (long)element.getSecurityPosition().getPrice().getValue());
        })));
        this.support.addColumn(column);
        column = new Column("qdate", Messages.ColumnDateOfQuote, 16384, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Element element = (Element)e;
                return element.isSecurity() ? Values.Date.format((Object)element.getSecurityPosition().getPrice().getDate()) : null;
            }
        });
        column.setComparator(new ElementComparator(new AttributeComparator(e -> ((Element)e).isSecurity() ? ((Element)e).getSecurityPosition().getPrice().getDate() : null)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("5", Messages.ColumnMarketValue, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Element element = (Element)e;
                return Values.Money.format(element.getValuation(), StatementOfAssetsViewer.this.client.getBaseCurrency());
            }

            public Font getFont(Object e) {
                return ((Element)e).isGroupByTaxonomy() || ((Element)e).isCategory() ? StatementOfAssetsViewer.this.boldFont : null;
            }
        });
        column.setSorter(ColumnViewerSorter.create(Element.class, "valuation").wrap(ElementComparator::new));
        this.support.addColumn(column);
        column = new Column("6", Messages.ColumnShareInPercent, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Element element = (Element)e;
                if (element.isGroupByTaxonomy()) {
                    return Values.Percent.format((Object)1.0);
                }
                if (element.isCategory()) {
                    return Values.Percent.format((Object)element.getCategory().getShare());
                }
                return Values.Percent.format((Object)element.getPosition().getShare());
            }

            public Font getFont(Object e) {
                return ((Element)e).isGroupByTaxonomy() || ((Element)e).isCategory() ? StatementOfAssetsViewer.this.boldFont : null;
            }
        });
        column.setSorter(ColumnViewerSorter.create(Element.class, "valuation").wrap(ElementComparator::new));
        this.support.addColumn(column);
        column = new Column("7", Messages.ColumnPurchasePrice, 131072, 60);
        column.setDescription(Messages.ColumnPurchasePrice_Description);
        ReportingPeriodLabelProvider labelProvider = new ReportingPeriodLabelProvider(new ElementValueProvider(SecurityPerformanceRecord::getFifoCostPerSharesHeld, null), false);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("ppmvavg", Messages.ColumnPurchasePriceMovingAverage, 131072, 60);
        column.setDescription(Messages.ColumnPurchasePriceMovingAverage_Description);
        labelProvider = new ReportingPeriodLabelProvider(new ElementValueProvider(SecurityPerformanceRecord::getMovingAverageCostPerSharesHeld, null), false);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("8", Messages.ColumnPurchaseValue, 131072, 80);
        column.setDescription(Messages.ColumnPurchaseValue_Description);
        labelProvider = new ReportingPeriodLabelProvider(new ElementValueProvider(SecurityPerformanceRecord::getFifoCost, this.withSum()), false);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("pvmvavg", Messages.ColumnPurchaseValueMovingAverage, 131072, 80);
        column.setDescription(Messages.ColumnPurchaseValueMovingAverage_Description);
        labelProvider = new ReportingPeriodLabelProvider(new ElementValueProvider(SecurityPerformanceRecord::getMovingAverageCost, this.withSum()), false);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("9", Messages.ColumnProfitLoss, 131072, 80);
        labelProvider = new ReportingPeriodLabelProvider(new ElementValueProvider(SecurityPerformanceRecord::getCapitalGainsOnHoldings, this.withSum()), true);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new NoteColumn();
        column.getEditingSupport().addListener(new ColumnEditingSupport.TouchClientListener(this.client));
        column.getSorter().wrap(ElementComparator::new);
        this.support.addColumn(column);
        ArrayList<ReportingPeriod> options = new ArrayList<ReportingPeriod>(this.owner.getPart().getReportingPeriods());
        this.addPerformanceColumns(options);
        this.addDividendColumns(options);
        this.addTaxonomyColumns();
        this.addAttributeColumns();
        this.addCurrencyColumns();
        this.support.createColumns();
        this.assets.getTable().setHeaderVisible(true);
        this.assets.getTable().setLinesVisible(true);
        this.assets.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.assets.addDragSupport(2, new Transfer[]{SecurityTransfer.getTransfer()}, (DragSourceListener)new SecurityDragListener((StructuredViewer)this.assets));
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources(), (Control)this.assets.getTable());
        this.boldFont = resources.createFont(FontDescriptor.createFrom((Font)this.assets.getTable().getFont()).setStyle(1));
        return container;
    }

    private void addPerformanceColumns(List<ReportingPeriod> options) {
        Column column = new Column("ttwror", Messages.ColumnTWROR, 131072, 80);
        ReportingPeriodLabelProvider labelProvider = new ReportingPeriodLabelProvider(SecurityPerformanceRecord::getTrueTimeWeightedRateOfReturn);
        column.setOptions(new ReportingPeriodColumnOptions(Messages.ColumnTTWROR_Option, options));
        column.setGroupLabel(Messages.GroupLabelPerformance);
        column.setDescription(Messages.ColumnTWROR_Description);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("irr", Messages.ColumnIRR, 131072, 80);
        labelProvider = new ReportingPeriodLabelProvider(SecurityPerformanceRecord::getIrr);
        column.setOptions(new ReportingPeriodColumnOptions(Messages.ColumnIRRPerformanceOption, options));
        column.setMenuLabel(Messages.ColumnIRR_MenuLabel);
        column.setGroupLabel(Messages.GroupLabelPerformance);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("capitalgains", Messages.ColumnCapitalGains, 131072, 80);
        labelProvider = new ReportingPeriodLabelProvider(SecurityPerformanceRecord::getCapitalGainsOnHoldings, this.withSum(), true);
        column.setOptions(new ReportingPeriodColumnOptions(Messages.ColumnCapitalGains_Option, options));
        column.setGroupLabel(Messages.GroupLabelPerformance);
        column.setDescription(Messages.ColumnCapitalGains_Description);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("capitalgains%", Messages.ColumnCapitalGainsPercent, 131072, 80);
        labelProvider = new ReportingPeriodLabelProvider(SecurityPerformanceRecord::getCapitalGainsOnHoldingsPercent);
        column.setOptions(new ReportingPeriodColumnOptions(Messages.ColumnCapitalGainsPercent_Option, options));
        column.setGroupLabel(Messages.GroupLabelPerformance);
        column.setDescription(Messages.ColumnCapitalGainsPercent_Description);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("capitalgainsmvavg", Messages.ColumnCapitalGainsMovingAverage, 131072, 80);
        labelProvider = new ReportingPeriodLabelProvider(SecurityPerformanceRecord::getCapitalGainsOnHoldingsMovingAverage, this.withSum(), true);
        column.setOptions(new ReportingPeriodColumnOptions(Messages.ColumnCapitalGainsMovingAverage_Option, options));
        column.setGroupLabel(Messages.GroupLabelPerformance);
        column.setDescription(Messages.ColumnCapitalGainsMovingAverage_Description);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("capitalgainsmvavg%", Messages.ColumnCapitalGainsMovingAveragePercent, 131072, 80);
        labelProvider = new ReportingPeriodLabelProvider(SecurityPerformanceRecord::getCapitalGainsOnHoldingsMovingAveragePercent);
        column.setOptions(new ReportingPeriodColumnOptions(Messages.ColumnCapitalGainsMovingAveragePercent_Option, options));
        column.setGroupLabel(Messages.GroupLabelPerformance);
        column.setDescription(Messages.ColumnCapitalGainsMovingAveragePercent_Description);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("delta", Messages.ColumnAbsolutePerformance_MenuLabel, 131072, 80);
        labelProvider = new ReportingPeriodLabelProvider(SecurityPerformanceRecord::getDelta, this.withSum(), true);
        column.setOptions(new ReportingPeriodColumnOptions(Messages.ColumnAbsolutePerformance_Option, options));
        column.setGroupLabel(Messages.GroupLabelPerformance);
        column.setDescription(Messages.ColumnAbsolutePerformance_Description);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("delta%", Messages.ColumnAbsolutePerformancePercent_MenuLabel, 131072, 80);
        labelProvider = new ReportingPeriodLabelProvider(SecurityPerformanceRecord::getDeltaPercent);
        column.setOptions(new ReportingPeriodColumnOptions(Messages.ColumnAbsolutePerformancePercent_Option, options));
        column.setGroupLabel(Messages.GroupLabelPerformance);
        column.setDescription(Messages.ColumnAbsolutePerformancePercent_Description);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
    }

    private void addDividendColumns(List<ReportingPeriod> options) {
        Column column = new Column("sumdiv", Messages.ColumnDividendSum, 131072, 80);
        ReportingPeriodLabelProvider labelProvider = new ReportingPeriodLabelProvider(SecurityPerformanceRecord::getSumOfDividends, this.withSum(), false);
        column.setOptions(new ReportingPeriodColumnOptions(String.valueOf(Messages.ColumnDividendSum) + " {0}", options));
        column.setGroupLabel(Messages.GroupLabelDividends);
        column.setMenuLabel(Messages.ColumnDividendSum_MenuLabel);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("d%", Messages.ColumnDividendTotalRateOfReturn, 131072, 80);
        labelProvider = new ReportingPeriodLabelProvider(SecurityPerformanceRecord::getTotalRateOfReturnDiv, null, false);
        column.setOptions(new ReportingPeriodColumnOptions(String.valueOf(Messages.ColumnDividendTotalRateOfReturn) + " {0}", options));
        column.setGroupLabel(Messages.GroupLabelDividends);
        column.setDescription(Messages.ColumnDividendTotalRateOfReturn_Description);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("d%mvavg", Messages.ColumnDividendMovingAverageTotalRateOfReturn, 131072, 80);
        labelProvider = new ReportingPeriodLabelProvider(SecurityPerformanceRecord::getTotalRateOfReturnDivMovingAverage, null, false);
        column.setOptions(new ReportingPeriodColumnOptions(String.valueOf(Messages.ColumnDividendMovingAverageTotalRateOfReturn) + " {0}", options));
        column.setGroupLabel(Messages.GroupLabelDividends);
        column.setDescription(Messages.ColumnDividendMovingAverageTotalRateOfReturn_Description);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
    }

    private void addAttributeColumns() {
        AttributeColumn.createFor(this.client, Security.class).forEach(column -> {
            if (column.getSorter() != null) {
                column.getSorter().wrap(ElementComparator::new);
            }
            column.getEditingSupport().addListener(new ColumnEditingSupport.TouchClientListener(this.client));
            this.support.addColumn((Column)column);
        });
    }

    private void addTaxonomyColumns() {
        for (Taxonomy t : this.client.getTaxonomies()) {
            TaxonomyColumn column = new TaxonomyColumn(t);
            column.setVisible(false);
            if (column.getSorter() != null) {
                column.getSorter().wrap(ElementComparator::new);
            }
            this.support.addColumn(column);
        }
    }

    private void addCurrencyColumns() {
        Column column = new Column("baseCurrency", Messages.ColumnCurrency, 16384, 80);
        column.setGroupLabel(Messages.ColumnForeignCurrencies);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Element element = (Element)e;
                if (!element.isPosition()) {
                    return null;
                }
                return element.getPosition().getInvestmentVehicle().getCurrencyCode();
            }
        });
        column.setComparator(new ElementComparator(new AttributeComparator(e -> ((Element)e).isPosition() ? ((Element)e).getPosition().getInvestmentVehicle().getCurrencyCode() : null)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("exchangeRate", Messages.ColumnExchangeRate, 131072, 80);
        column.setGroupLabel(Messages.ColumnForeignCurrencies);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Element element = (Element)e;
                if (!element.isPosition()) {
                    return null;
                }
                String baseCurrency = element.getPosition().getInvestmentVehicle().getCurrencyCode();
                CurrencyConverter converter = StatementOfAssetsViewer.this.model.getCurrencyConverter();
                ExchangeRate rate = converter.getRate(StatementOfAssetsViewer.this.model.getDate(), baseCurrency);
                if (StatementOfAssetsViewer.this.useIndirectQuotation) {
                    rate = rate.inverse();
                }
                return Values.ExchangeRate.format((Object)rate.getValue());
            }

            public String getToolTipText(Object e) {
                String text = this.getText(e);
                if (text == null) {
                    return null;
                }
                String term = StatementOfAssetsViewer.this.model.getCurrencyConverter().getTermCurrency();
                String base = ((Element)e).getPosition().getInvestmentVehicle().getCurrencyCode();
                return String.valueOf(text) + ' ' + (StatementOfAssetsViewer.this.useIndirectQuotation ? String.valueOf(base) + '/' + term : String.valueOf(term) + '/' + base);
            }
        });
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("marketValueBaseCurrency", String.valueOf(Messages.ColumnMarketValue) + Messages.BaseCurrencyCue, 131072, 80);
        column.setDescription(Messages.ColumnMarketValueBaseCurrency);
        column.setGroupLabel(Messages.ColumnForeignCurrencies);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Element element = (Element)e;
                if (!element.isPosition()) {
                    return null;
                }
                return Values.Money.format(element.getPosition().getPosition().calculateValue(), StatementOfAssetsViewer.this.client.getBaseCurrency());
            }
        });
        column.setComparator(new ElementComparator(new AttributeComparator(e -> ((Element)e).isPosition() ? ((Element)e).getPosition().getPosition().calculateValue() : null)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("purchaseValueBaseCurrency", String.valueOf(Messages.ColumnPurchaseValue) + Messages.BaseCurrencyCue, 131072, 80);
        column.setDescription(Messages.ColumnPurchaseValueBaseCurrency);
        column.setGroupLabel(Messages.ColumnForeignCurrencies);
        ReportingPeriodLabelProvider labelProvider = new ReportingPeriodLabelProvider(new ElementValueProvider(SecurityPerformanceRecord::getFifoCost, null), e -> e.isSecurity() ? e.getSecurity().getCurrencyCode() : this.model.getCurrencyConverter().getTermCurrency(), false);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("purchasePriceBaseCurrency", String.valueOf(Messages.ColumnPurchasePrice) + Messages.BaseCurrencyCue, 131072, 80);
        column.setDescription(Messages.ColumnPurchasePriceBaseCurrency);
        column.setGroupLabel(Messages.ColumnForeignCurrencies);
        labelProvider = new ReportingPeriodLabelProvider(new ElementValueProvider(SecurityPerformanceRecord::getFifoCostPerSharesHeld, null), e -> e.isSecurity() ? e.getSecurity().getCurrencyCode() : this.model.getCurrencyConverter().getTermCurrency(), false);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("profitLossBaseCurrency", String.valueOf(Messages.ColumnProfitLoss) + Messages.BaseCurrencyCue, 131072, 80);
        column.setDescription(Messages.ColumnProfitLossBaseCurrency);
        column.setGroupLabel(Messages.ColumnForeignCurrencies);
        labelProvider = new ReportingPeriodLabelProvider(new ElementValueProvider(SecurityPerformanceRecord::getCapitalGainsOnHoldings, null), e -> e.isSecurity() ? e.getSecurity().getCurrencyCode() : this.model.getCurrencyConverter().getTermCurrency(), false);
        column.setLabelProvider(labelProvider);
        column.setSorter(ColumnViewerSorter.create(new ElementComparator(labelProvider)));
        column.setVisible(false);
        column.setVisible(false);
        this.support.addColumn(column);
    }

    public void setToolBarManager(ToolBarManager toolBar) {
        if (this.support == null) {
            throw new NullPointerException("support");
        }
        this.support.setToolBarManager(toolBar);
    }

    public void hookMenuListener(IMenuManager manager, AbstractFinanceView view) {
        Element element = (Element)((IStructuredSelection)this.assets.getSelection()).getFirstElement();
        if (element == null) {
            return;
        }
        if (element.isAccount()) {
            new AccountContextMenu(view).menuAboutToShow(manager, element.getAccount(), null);
        } else if (element.isSecurity()) {
            Portfolio reference = null;
            if (this.model.filteredClient.getPortfolios().size() == 1) {
                reference = ReadOnlyPortfolio.unwrap((Portfolio)((Portfolio)this.model.filteredClient.getPortfolios().get(0)));
            }
            new SecurityContextMenu(view).menuAboutToShow(manager, element.getSecurity(), reference);
        }
    }

    public TableViewer getTableViewer() {
        return this.assets;
    }

    public void showConfigMenu(Shell shell) {
        if (this.contextMenu == null) {
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(this::menuAboutToShow);
            this.contextMenu = menuMgr.createContextMenu((Control)shell);
        }
        this.contextMenu.setVisible(true);
    }

    public void menuAboutToShow(IMenuManager manager) {
        manager.add((IAction)new LabelOnly(Messages.LabelTaxonomies));
        for (final Taxonomy t : this.client.getTaxonomies()) {
            Action action = new Action(t.getName()){

                public void run() {
                    StatementOfAssetsViewer.this.taxonomy = t;
                    StatementOfAssetsViewer.this.setInput(StatementOfAssetsViewer.this.model.clientFilter, StatementOfAssetsViewer.this.model.getDate(), StatementOfAssetsViewer.this.model.getCurrencyConverter());
                }
            };
            action.setChecked(t.equals(this.taxonomy));
            manager.add((IAction)action);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new LabelOnly(Messages.LabelColumns));
        this.support.menuAboutToShow(manager);
    }

    public void setInput(ClientFilter filter, LocalDate date, CurrencyConverter converter) {
        this.assets.getTable().setRedraw(false);
        try {
            this.model = new Model(this.client, filter, converter, date, this.taxonomy);
            this.assets.setInput(this.model.getElements());
            this.assets.refresh();
        }
        finally {
            this.assets.getTable().setRedraw(true);
        }
    }

    public Function<Stream<Object>, Object> withSum() {
        return elements -> elements.map(e -> (Money)e).collect(MoneyCollectors.sum((String)this.model.getCurrencyConverter().getTermCurrency()));
    }

    public ShowHideColumnHelper getColumnHelper() {
        return this.support;
    }

    private void widgetDisposed() {
        if (this.taxonomy != null) {
            this.preference.setValue(this.getClass().getSimpleName(), this.taxonomy.getId());
        }
        if (this.contextMenu != null) {
            this.contextMenu.dispose();
        }
    }

    public static class Element
    implements Adaptable {
        private final int sortOrder;
        private GroupByTaxonomy groupByTaxonomy;
        private AssetCategory category;
        private AssetPosition position;
        private List<Element> children = new ArrayList<Element>();
        private Map<CacheKey, SecurityPerformanceRecord> performance = new HashMap<CacheKey, SecurityPerformanceRecord>();

        private Element(GroupByTaxonomy groupByTaxonomy, AssetCategory category, int sortOrder) {
            this.groupByTaxonomy = groupByTaxonomy;
            this.category = category;
            this.sortOrder = sortOrder;
        }

        private Element(GroupByTaxonomy groupByTaxonomy, AssetPosition position, int sortOrder) {
            this.groupByTaxonomy = groupByTaxonomy;
            this.position = position;
            this.sortOrder = sortOrder;
        }

        private Element(GroupByTaxonomy groupByTaxonomy, int sortOrder) {
            this.groupByTaxonomy = groupByTaxonomy;
            this.sortOrder = sortOrder;
        }

        public GroupByTaxonomy getGroupByTaxonomy() {
            return this.groupByTaxonomy;
        }

        public void addChild(Element child) {
            this.children.add(child);
        }

        public Stream<Element> getChildren() {
            return this.children.stream();
        }

        public int getSortOrder() {
            return this.sortOrder;
        }

        public void setPerformance(String currencyCode, Interval period, SecurityPerformanceRecord record) {
            this.performance.put(new CacheKey(currencyCode, period), record);
        }

        public SecurityPerformanceRecord getPerformance(String currencyCode, Interval period) {
            return this.performance.get(new CacheKey(currencyCode, period));
        }

        public boolean isGroupByTaxonomy() {
            return this.groupByTaxonomy != null && this.category == null && this.position == null;
        }

        public boolean isCategory() {
            return this.category != null;
        }

        public boolean isPosition() {
            return this.position != null;
        }

        public boolean isSecurity() {
            return this.position != null && this.position.getSecurity() != null;
        }

        public boolean isAccount() {
            return this.position != null && this.position.getInvestmentVehicle() instanceof Account;
        }

        public AssetCategory getCategory() {
            return this.category;
        }

        public AssetPosition getPosition() {
            return this.position;
        }

        public SecurityPosition getSecurityPosition() {
            return this.position != null ? this.position.getPosition() : null;
        }

        public Security getSecurity() {
            return this.position != null ? this.position.getSecurity() : null;
        }

        public Account getAccount() {
            return this.isAccount() ? (Account)this.position.getInvestmentVehicle() : null;
        }

        public Money getValuation() {
            if (this.position != null) {
                return this.position.getValuation();
            }
            if (this.category != null) {
                return this.category.getValuation();
            }
            return this.groupByTaxonomy.getValuation();
        }

        public <T> T adapt(Class<T> type) {
            if (type == Security.class || type == Attributable.class) {
                return type.cast(this.getSecurity());
            }
            if (type == Named.class || type == Annotated.class) {
                if (this.isSecurity()) {
                    return type.cast(this.getSecurity());
                }
                if (this.isAccount()) {
                    return type.cast(this.getAccount());
                }
                if (this.isCategory()) {
                    return type.cast(this.getCategory().getClassification());
                }
                return null;
            }
            if (type == InvestmentVehicle.class) {
                if (this.isSecurity()) {
                    return type.cast(this.getSecurity());
                }
                if (this.isAccount()) {
                    return type.cast(this.getAccount());
                }
                return null;
            }
            return null;
        }
    }

    public static class ElementComparator
    implements Comparator<Object> {
        private Comparator<Object> comparator;

        public ElementComparator(Comparator<Object> wrapped) {
            this.comparator = wrapped;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int b;
            int a = ((Element)o1).getSortOrder();
            if (a != (b = ((Element)o2).getSortOrder())) {
                int direction = ColumnViewerSorter.SortingContext.getSortDirection();
                return direction == 1024 ? a - b : b - a;
            }
            return this.comparator.compare(o1, o2);
        }
    }

    static class ElementValueProvider {
        private Function<SecurityPerformanceRecord, Object> valueProvider;
        private Function<Stream<Object>, Object> collector;

        public ElementValueProvider(Function<SecurityPerformanceRecord, Object> valueProvider, Function<Stream<Object>, Object> collector) {
            this.valueProvider = valueProvider;
            this.collector = collector;
        }

        public Object getValue(Element element, String currencyCode, Interval interval) {
            if (element.isSecurity()) {
                long totalShares;
                SecurityPerformanceRecord record = element.getPerformance(currencyCode, interval);
                if (record == null) {
                    return null;
                }
                Object value = this.valueProvider.apply(record);
                if (!(value instanceof Money)) {
                    return value;
                }
                long positionShares = element.getPosition().getPosition().getShares();
                if (positionShares != (totalShares = element.getGroupByTaxonomy().getCategories().flatMap(c -> c.getPositions().stream()).filter(p -> element.getSecurity().equals(p.getSecurity())).mapToLong(p -> p.getPosition().getShares()).sum())) {
                    Money moneyValue = (Money)value;
                    return Money.of((String)moneyValue.getCurrencyCode(), (long)Math.round((double)(moneyValue.getAmount() * positionShares) / (double)totalShares));
                }
                return value;
            }
            if (element.isCategory()) {
                if (this.collector == null) {
                    return null;
                }
                return this.collectValue(element.getChildren(), currencyCode, interval);
            }
            if (element.isGroupByTaxonomy()) {
                if (this.collector == null) {
                    return null;
                }
                return this.collectValue(element.getChildren().flatMap(Element::getChildren), currencyCode, interval);
            }
            return null;
        }

        private Object collectValue(Stream<Element> elements, String currencyCode, Interval interval) {
            return this.collector.apply(elements.filter(Element::isSecurity).map(child -> this.getValue((Element)child, currencyCode, interval)).filter(Objects::nonNull));
        }
    }

    public static final class Model {
        private final ClientFilter clientFilter;
        private final Client filteredClient;
        private CurrencyConverter converter;
        private ClientSnapshot clientSnapshot;
        private List<Element> elements = new ArrayList<Element>();
        private GroupByTaxonomy groupByTaxonomy;
        private final Interval globalInterval;
        private Set<CacheKey> calculated = new HashSet<CacheKey>();

        public Model(Client client, ClientFilter filter, CurrencyConverter converter, LocalDate date, Taxonomy taxonomy) {
            this.clientFilter = filter;
            this.filteredClient = filter.filter(client);
            this.converter = converter;
            this.globalInterval = Interval.of((LocalDate)LocalDate.MIN, (LocalDate)date);
            this.clientSnapshot = ClientSnapshot.create((Client)this.filteredClient, (CurrencyConverter)converter, (LocalDate)date);
            this.groupByTaxonomy = this.clientSnapshot.groupByTaxonomy(taxonomy);
            this.elements.addAll(this.flatten(this.groupByTaxonomy));
        }

        public List<Element> getElements() {
            return this.elements;
        }

        public LocalDate getDate() {
            return this.clientSnapshot.getTime();
        }

        public CurrencyConverter getCurrencyConverter() {
            return this.converter;
        }

        public Interval getGlobalInterval() {
            return this.globalInterval;
        }

        private final List<Element> flatten(GroupByTaxonomy groupByTaxonomy) {
            int sortOrder = 0;
            ArrayList<Element> answer = new ArrayList<Element>();
            Element root = new Element(groupByTaxonomy, Integer.MAX_VALUE);
            for (AssetCategory cat : groupByTaxonomy.asList()) {
                Element category = new Element(groupByTaxonomy, cat, sortOrder);
                answer.add(category);
                root.addChild(category);
                ++sortOrder;
                for (AssetPosition p : cat.getPositions()) {
                    Element child = new Element(groupByTaxonomy, p, sortOrder);
                    answer.add(child);
                    category.addChild(child);
                }
                ++sortOrder;
            }
            answer.add(root);
            return answer;
        }

        final void calculatePerformanceAndInjectIntoElements(String currencyCode, Interval interval) {
            CacheKey key = new CacheKey(currencyCode, interval);
            if (this.calculated.contains(key)) {
                return;
            }
            SecurityPerformanceSnapshot snapshot = null;
            snapshot = this.globalInterval.equals((Object)interval) ? SecurityPerformanceSnapshot.create((Client)this.filteredClient, (CurrencyConverter)this.converter.with(currencyCode), (Interval)interval, (Class[])new Class[]{SecurityPerformanceIndicator.Costs.class}) : SecurityPerformanceSnapshot.create((Client)this.filteredClient, (CurrencyConverter)this.converter.with(currencyCode), (Interval)interval, (Class[])new Class[0]);
            Map<Security, SecurityPerformanceRecord> map = snapshot.getRecords().stream().collect(Collectors.toMap(SecurityPerformanceRecord::getSecurity, r -> r));
            this.elements.stream().filter(Element::isSecurity).forEach(e -> e.setPerformance(currencyCode, interval, (SecurityPerformanceRecord)map.get(e.getSecurity())));
            this.calculated.add(key);
        }
    }

    private final class ReportingPeriodLabelProvider
    extends OptionLabelProvider<ReportingPeriod>
    implements Comparator<Object> {
        private boolean showColorAndArrows;
        private ElementValueProvider valueProvider;
        private Function<Element, String> currencyProvider;

        public ReportingPeriodLabelProvider(Function<SecurityPerformanceRecord, Object> valueProvider) {
            this(new ElementValueProvider(valueProvider, null), null, true);
        }

        public ReportingPeriodLabelProvider(Function<SecurityPerformanceRecord, Object> valueProvider, Function<Stream<Object>, Object> collector, boolean showUpAndDownArrows) {
            this(new ElementValueProvider(valueProvider, collector), null, showUpAndDownArrows);
        }

        public ReportingPeriodLabelProvider(ElementValueProvider valueProvider, boolean showUpAndDownArrows) {
            this(valueProvider, null, showUpAndDownArrows);
        }

        public ReportingPeriodLabelProvider(ElementValueProvider valueProvider, Function<Element, String> currencyProvider, boolean showUpAndDownArrows) {
            this.valueProvider = valueProvider;
            this.currencyProvider = currencyProvider;
            this.showColorAndArrows = showUpAndDownArrows;
        }

        private Object getValue(Object e, ReportingPeriod option) {
            Element element = (Element)e;
            Interval interval = option != null ? option.toInterval(StatementOfAssetsViewer.this.model.getDate()) : StatementOfAssetsViewer.this.model.getGlobalInterval();
            String currencyCode = this.currencyProvider != null ? this.currencyProvider.apply(element) : StatementOfAssetsViewer.this.model.getCurrencyConverter().getTermCurrency();
            StatementOfAssetsViewer.this.model.calculatePerformanceAndInjectIntoElements(currencyCode, interval);
            return this.valueProvider.getValue(element, currencyCode, interval);
        }

        @Override
        public String getText(Object e, ReportingPeriod option) {
            Object value = this.getValue(e, option);
            if (value == null) {
                return null;
            }
            if (value instanceof Money) {
                return Values.Money.format((Money)value, StatementOfAssetsViewer.this.client.getBaseCurrency());
            }
            if (value instanceof Quote) {
                return Values.CalculatedQuote.format((Quote)value, StatementOfAssetsViewer.this.client.getBaseCurrency());
            }
            if (value instanceof Double) {
                return Values.Percent2.format((Object)((Double)value));
            }
            return null;
        }

        @Override
        public Color getForeground(Object e, ReportingPeriod option) {
            if (!this.showColorAndArrows) {
                return null;
            }
            Object value = this.getValue(e, option);
            if (value == null) {
                return null;
            }
            double doubleValue = 0.0;
            if (value instanceof Money) {
                doubleValue = ((Money)value).getAmount();
            } else if (value instanceof Quote) {
                doubleValue = ((Quote)value).getAmount();
            } else if (value instanceof Double) {
                doubleValue = (Double)value;
            }
            if (doubleValue < 0.0) {
                return Colors.theme().redForeground();
            }
            if (doubleValue > 0.0) {
                return Colors.theme().greenForeground();
            }
            return null;
        }

        @Override
        public Image getImage(Object element, ReportingPeriod option) {
            if (!this.showColorAndArrows) {
                return null;
            }
            Object value = this.getValue(element, option);
            if (value == null) {
                return null;
            }
            double doubleValue = 0.0;
            if (value instanceof Money) {
                doubleValue = ((Money)value).getAmount();
            } else if (value instanceof Quote) {
                doubleValue = ((Quote)value).getAmount();
            } else if (value instanceof Double) {
                doubleValue = (Double)value;
            }
            if (doubleValue > 0.0) {
                return Images.GREEN_ARROW.image();
            }
            if (doubleValue < 0.0) {
                return Images.RED_ARROW.image();
            }
            return null;
        }

        @Override
        public Font getFont(Object e, ReportingPeriod option) {
            return ((Element)e).isGroupByTaxonomy() || ((Element)e).isCategory() ? StatementOfAssetsViewer.this.boldFont : null;
        }

        @Override
        public int compare(Object o1, Object o2) {
            ReportingPeriod option = (ReportingPeriod)ColumnViewerSorter.SortingContext.getColumnOption();
            Comparable v1 = (Comparable)this.getValue(o1, option);
            Comparable v2 = (Comparable)this.getValue(o2, option);
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            return v1.compareTo(v2);
        }
    }
}

