/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.actions;

import java.util.Arrays;
import java.util.Collection;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.ui.Messages;
import org.eclipse.jface.action.Action;

public class ConvertBuySellToDeliveryAction
extends Action {
    private final Client client;
    private final Collection<TransactionPair<PortfolioTransaction>> transactionList;

    public ConvertBuySellToDeliveryAction(Client client, TransactionPair<PortfolioTransaction> transaction) {
        this(client, Arrays.asList(transaction));
    }

    public ConvertBuySellToDeliveryAction(Client client, Collection<TransactionPair<PortfolioTransaction>> transactionList) {
        this.client = client;
        this.transactionList = transactionList;
        boolean allBuy = true;
        boolean allSell = true;
        for (TransactionPair<PortfolioTransaction> tx : transactionList) {
            if (((PortfolioTransaction)tx.getTransaction()).getType() != PortfolioTransaction.Type.BUY && ((PortfolioTransaction)tx.getTransaction()).getType() != PortfolioTransaction.Type.SELL) {
                throw new IllegalArgumentException();
            }
            allBuy &= ((PortfolioTransaction)tx.getTransaction()).getType() == PortfolioTransaction.Type.BUY;
            allSell &= ((PortfolioTransaction)tx.getTransaction()).getType() == PortfolioTransaction.Type.SELL;
        }
        if (allBuy) {
            this.setText(Messages.MenuConvertToInboundDelivery);
        } else if (allSell) {
            this.setText(Messages.MenuConvertToOutboundDelivery);
        } else {
            this.setText(Messages.MenuConvertToDelivery);
        }
    }

    public void run() {
        for (TransactionPair<PortfolioTransaction> transaction : this.transactionList) {
            PortfolioTransaction buySellTransaction = (PortfolioTransaction)transaction.getTransaction();
            transaction.getOwner().deleteTransaction((Transaction)buySellTransaction, this.client);
            PortfolioTransaction delivery = new PortfolioTransaction();
            delivery.setType(buySellTransaction.getType() == PortfolioTransaction.Type.BUY ? PortfolioTransaction.Type.DELIVERY_INBOUND : PortfolioTransaction.Type.DELIVERY_OUTBOUND);
            delivery.setDateTime(buySellTransaction.getDateTime());
            delivery.setMonetaryAmount(buySellTransaction.getMonetaryAmount());
            delivery.setSecurity(buySellTransaction.getSecurity());
            delivery.setNote(buySellTransaction.getNote());
            delivery.setShares(buySellTransaction.getShares());
            buySellTransaction.getUnits().forEach(arg_0 -> ((PortfolioTransaction)delivery).addUnit(arg_0));
            transaction.getOwner().addTransaction((Transaction)delivery);
        }
        this.client.markDirty();
    }
}

