/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.actions;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.ui.Messages;
import org.eclipse.jface.action.Action;

public class ConvertDeliveryToBuySellAction
extends Action {
    private final Client client;
    private final Collection<TransactionPair<PortfolioTransaction>> transactionList;

    public ConvertDeliveryToBuySellAction(Client client, TransactionPair<PortfolioTransaction> transaction) {
        this(client, Arrays.asList(transaction));
    }

    public ConvertDeliveryToBuySellAction(Client client, Collection<TransactionPair<PortfolioTransaction>> transactionList) {
        this.client = client;
        this.transactionList = transactionList;
        boolean allInbound = true;
        boolean allOutbound = true;
        for (TransactionPair<PortfolioTransaction> tx : transactionList) {
            if (((PortfolioTransaction)tx.getTransaction()).getType() != PortfolioTransaction.Type.DELIVERY_INBOUND && ((PortfolioTransaction)tx.getTransaction()).getType() != PortfolioTransaction.Type.DELIVERY_OUTBOUND) {
                throw new IllegalArgumentException();
            }
            allInbound &= ((PortfolioTransaction)tx.getTransaction()).getType() == PortfolioTransaction.Type.DELIVERY_INBOUND;
            allOutbound &= ((PortfolioTransaction)tx.getTransaction()).getType() == PortfolioTransaction.Type.DELIVERY_OUTBOUND;
        }
        if (allInbound) {
            this.setText(Messages.MenuConvertToBuy);
        } else if (allOutbound) {
            this.setText(Messages.MenuConvertToSell);
        } else {
            this.setText(Messages.MenuConvertToBuySell);
        }
    }

    public void run() {
        for (TransactionPair<PortfolioTransaction> transaction : this.transactionList) {
            Portfolio portfolio = (Portfolio)transaction.getOwner();
            Account account = portfolio.getReferenceAccount();
            PortfolioTransaction deliveryTransaction = (PortfolioTransaction)transaction.getTransaction();
            if (!deliveryTransaction.getCurrencyCode().equals(account.getCurrencyCode())) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.MsgErrorConvertToBuySellCurrencyMismatch, deliveryTransaction.getCurrencyCode(), account.getCurrencyCode(), account.getName()));
            }
            transaction.getOwner().deleteTransaction((Transaction)deliveryTransaction, this.client);
            BuySellEntry entry = new BuySellEntry(portfolio, account);
            entry.setType(deliveryTransaction.getType() == PortfolioTransaction.Type.DELIVERY_INBOUND ? PortfolioTransaction.Type.BUY : PortfolioTransaction.Type.SELL);
            entry.setDate(deliveryTransaction.getDateTime());
            entry.setMonetaryAmount(deliveryTransaction.getMonetaryAmount());
            entry.setSecurity(deliveryTransaction.getSecurity());
            entry.setNote(deliveryTransaction.getNote());
            entry.setShares(deliveryTransaction.getShares());
            deliveryTransaction.getUnits().forEach(arg_0 -> ((PortfolioTransaction)entry.getPortfolioTransaction()).addUnit(arg_0));
            entry.insert();
        }
        this.client.markDirty();
    }
}

