/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.columns;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import name.abuchen.portfolio.model.Adaptor;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.AttributeType;
import name.abuchen.portfolio.model.Attributes;
import name.abuchen.portfolio.model.Bookmark;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.ImageManager;
import name.abuchen.portfolio.model.LimitPrice;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.DesktopAPI;
import name.abuchen.portfolio.ui.util.viewers.AttributeEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.BooleanAttributeEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.CellItemImageClickedListener;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.ImageAttributeEditingSupport;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class AttributeColumn
extends Column {
    private static final String ID = "attribute$";

    private AttributeColumn(AttributeType attribute) {
        super(ID + attribute.getId(), attribute.getColumnLabel(), attribute.isNumber() ? 131072 : 16384, 80);
        this.setMenuLabel(attribute.getName());
        this.setGroupLabel(Messages.GroupLabelAttributes);
        this.setSorter(ColumnViewerSorter.create(new AttributeComparator(attribute)));
        if (attribute.getType() == Boolean.class) {
            this.setLabelProvider((CellLabelProvider)new BooleanLabelProvider(attribute));
            new BooleanAttributeEditingSupport(attribute).attachTo(this);
        } else if (attribute.getType() == LimitPrice.class) {
            this.setStyle(131072);
            this.setLabelProvider((CellLabelProvider)new LimitPriceLabelProvider(attribute));
            new AttributeEditingSupport(attribute).attachTo(this);
        } else if (attribute.getType() == Bookmark.class) {
            this.setLabelProvider((CellLabelProvider)new BookmarkLabelProvider(attribute));
            new AttributeEditingSupport(attribute).attachTo(this);
        } else if (attribute.getConverter() instanceof AttributeType.ImageConverter) {
            this.setLabelProvider((CellLabelProvider)new ImageLabelProvider(attribute));
            new ImageAttributeEditingSupport(attribute).attachTo(this);
        } else {
            this.setLabelProvider((CellLabelProvider)new AttributeLabelProvider(attribute));
            new AttributeEditingSupport(attribute).attachTo(this);
        }
    }

    public static Stream<Column> createFor(Client client, Class<? extends Attributable> target) {
        return client.getSettings().getAttributeTypes().filter(a -> a.supports(target)).flatMap(attribute -> {
            ArrayList<AttributeColumn> columns = new ArrayList<AttributeColumn>();
            Column column = new AttributeColumn((AttributeType)attribute);
            column.setVisible(false);
            columns.add((AttributeColumn)column);
            if (attribute.getType() == LocalDate.class) {
                column = AttributeColumn.createDaysLeftColumn(attribute);
                columns.add((AttributeColumn)column);
            }
            return columns.stream();
        });
    }

    private static Column createDaysLeftColumn(final AttributeType attribute) {
        Column column = new Column(ID + attribute.getId() + "-daysbetween", String.valueOf(attribute.getColumnLabel()) + " - " + Messages.ColumnDaysBetweenPostfix, 131072, 80);
        column.setMenuLabel(String.valueOf(attribute.getName()) + " - " + Messages.ColumnDaysBetweenPostfix);
        column.setGroupLabel(Messages.GroupLabelAttributes);
        column.setSorter(ColumnViewerSorter.create(new AttributeComparator(attribute)));
        new AttributeEditingSupport(attribute).attachTo(column);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Attributable attributable = (Attributable)Adaptor.adapt(Attributable.class, (Object)element);
                if (attributable == null) {
                    return null;
                }
                LocalDate value = (LocalDate)attributable.getAttributes().get(attribute);
                return value == null ? null : String.valueOf(ChronoUnit.DAYS.between(value, LocalDate.now()));
            }
        });
        column.setVisible(false);
        return column;
    }

    private static final class AttributeComparator
    implements Comparator<Object> {
        private final AttributeType attribute;

        private AttributeComparator(AttributeType attribute) {
            this.attribute = attribute;
        }

        @Override
        public int compare(Object o1, Object o2) {
            Attributable a1 = (Attributable)Adaptor.adapt(Attributable.class, (Object)o1);
            Attributable a2 = (Attributable)Adaptor.adapt(Attributable.class, (Object)o2);
            if (a1 == null && a2 == null) {
                return 0;
            }
            if (a1 == null) {
                return -1;
            }
            if (a2 == null) {
                return 1;
            }
            Object v1 = a1.getAttributes().get(this.attribute);
            Object v2 = a2.getAttributes().get(this.attribute);
            return this.attribute.getComparator().compare(v1, v2);
        }
    }

    private static final class AttributeLabelProvider
    extends ColumnLabelProvider {
        private final AttributeType attribute;

        private AttributeLabelProvider(AttributeType attribute) {
            this.attribute = attribute;
        }

        public String getText(Object element) {
            Attributable attributable = (Attributable)Adaptor.adapt(Attributable.class, (Object)element);
            if (attributable == null) {
                return null;
            }
            Attributes attributes = attributable.getAttributes();
            Object value = attributes.get(this.attribute);
            return this.attribute.getConverter().toString(value);
        }
    }

    private static final class BookmarkLabelProvider
    extends StyledCellLabelProvider
    implements CellItemImageClickedListener {
        private final AttributeType attribute;

        private BookmarkLabelProvider(AttributeType attribute) {
            this.attribute = attribute;
        }

        private Optional<Bookmark> getValue(Object element) {
            Attributable attributable = (Attributable)Adaptor.adapt(Attributable.class, (Object)element);
            if (attributable == null) {
                return Optional.empty();
            }
            Attributes attributes = attributable.getAttributes();
            return Optional.ofNullable((Bookmark)attributes.get(this.attribute));
        }

        public void update(ViewerCell cell) {
            String label = this.getValue(cell.getElement()).map(Bookmark::getLabel).orElse("");
            cell.setText(label);
            if (!label.isEmpty()) {
                cell.setImage(Images.BOOKMARK_OPEN.image());
            }
            StyleRange styleRange = new StyleRange();
            styleRange.underline = true;
            styleRange.underlineStyle = 0;
            styleRange.data = cell.getElement();
            styleRange.start = 0;
            styleRange.length = label.length();
            cell.setStyleRanges(new StyleRange[]{styleRange});
        }

        @Override
        public void onImageClicked(Object element) {
            this.getValue(element).ifPresent(bm -> DesktopAPI.browse(bm.getPattern()));
        }
    }

    private static final class BooleanLabelProvider
    extends ColumnLabelProvider {
        private final AttributeType attribute;

        private BooleanLabelProvider(AttributeType attribute) {
            this.attribute = attribute;
        }

        public String getText(Object element) {
            return this.getValue(element).map(b -> Boolean.TRUE.equals(b) ? Messages.LabelYes : Messages.LabelNo).orElse("");
        }

        public Image getImage(Object element) {
            return this.getValue(element).map(b -> Boolean.TRUE.equals(b) ? Images.CHECK.image() : Images.XMARK.image()).orElse(null);
        }

        private Optional<Boolean> getValue(Object element) {
            Attributable attributable = (Attributable)Adaptor.adapt(Attributable.class, (Object)element);
            if (attributable == null) {
                return Optional.empty();
            }
            Attributes attributes = attributable.getAttributes();
            return Optional.ofNullable((Boolean)attributes.get(this.attribute));
        }
    }

    private static final class ImageLabelProvider
    extends ColumnLabelProvider {
        private final AttributeType attribute;

        private ImageLabelProvider(AttributeType attribute) {
            this.attribute = attribute;
        }

        public String getText(Object element) {
            return "";
        }

        public Image getImage(Object element) {
            if (this.attribute.getConverter() instanceof AttributeType.ImageConverter) {
                Attributable attributable = (Attributable)Adaptor.adapt(Attributable.class, (Object)element);
                return ImageManager.instance().getImage(attributable, this.attribute);
            }
            return null;
        }
    }

    private static final class LimitPriceLabelProvider
    extends ColumnLabelProvider {
        private final AttributeType attribute;

        private LimitPriceLabelProvider(AttributeType attribute) {
            this.attribute = attribute;
        }

        public String getText(Object element) {
            Security security = (Security)Adaptor.adapt(Security.class, (Object)element);
            if (security == null) {
                return null;
            }
            Attributes attributes = security.getAttributes();
            if (attributes == null) {
                return null;
            }
            Object value = attributes.get(this.attribute);
            return this.attribute.getConverter().toString(value);
        }

        public Color getBackground(Object element) {
            Security security = (Security)Adaptor.adapt(Security.class, (Object)element);
            if (security == null) {
                return null;
            }
            Attributes attributes = security.getAttributes();
            LimitPrice limit = (LimitPrice)attributes.get(this.attribute);
            if (limit == null) {
                return null;
            }
            SecurityPrice latestSecurityPrice = security.getSecurityPrice(LocalDate.now());
            if (latestSecurityPrice == null) {
                return null;
            }
            switch (limit.getRelationalOperator()) {
                case GREATER_OR_EQUAL: {
                    return latestSecurityPrice.getValue() >= limit.getValue() ? Colors.theme().greenBackground() : null;
                }
                case SMALLER_OR_EQUAL: {
                    return latestSecurityPrice.getValue() <= limit.getValue() ? Colors.theme().redBackground() : null;
                }
                case GREATER: {
                    return latestSecurityPrice.getValue() > limit.getValue() ? Colors.theme().greenBackground() : null;
                }
                case SMALLER: {
                    return latestSecurityPrice.getValue() < limit.getValue() ? Colors.theme().redBackground() : null;
                }
            }
            return null;
        }
    }
}

