/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.columns;

import name.abuchen.portfolio.model.Adaptor;
import name.abuchen.portfolio.model.Annotated;
import name.abuchen.portfolio.model.Named;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.StringEditingSupport;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;

public class NoteColumn
extends Column {
    public NoteColumn() {
        this("note");
    }

    public NoteColumn(String id) {
        super(id, Messages.ColumnNote, 16384, 22);
        this.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Annotated n = (Annotated)Adaptor.adapt(Annotated.class, (Object)e);
                if (n != null) {
                    return n.getNote();
                }
                Named n2 = (Named)Adaptor.adapt(Named.class, (Object)e);
                return n2 != null ? n2.getNote() : null;
            }

            public Image getImage(Object e) {
                String note = this.getText(e);
                return note != null && note.length() > 0 ? Images.NOTE.image() : null;
            }

            public String getToolTipText(Object e) {
                String note = this.getText(e);
                return note == null || note.isEmpty() ? null : TextUtil.wordwrap((String)note);
            }
        });
        this.setSorter(ColumnViewerSorter.create(Annotated.class, "note"));
        new StringEditingSupport(Annotated.class, "note").attachTo(this);
    }
}

