/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.snapshot.filter.ClientFilter;
import name.abuchen.portfolio.snapshot.trades.Trade;
import name.abuchen.portfolio.snapshot.trades.TradeCollector;
import name.abuchen.portfolio.snapshot.trades.TradeCollectorException;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.util.CacheKey;
import name.abuchen.portfolio.ui.util.swt.StyledLabel;
import name.abuchen.portfolio.ui.views.dashboard.ClientFilterConfig;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.DashboardResources;
import name.abuchen.portfolio.ui.views.dashboard.ReportingPeriodConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import name.abuchen.portfolio.ui.views.trades.TradeDetailsView;
import name.abuchen.portfolio.util.Interval;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

abstract class AbstractTradesWidget
extends WidgetDelegate<TradeDetailsView.Input> {
    @Inject
    private PortfolioPart part;
    protected Label title;
    protected StyledLabel indicator;

    AbstractTradesWidget(Dashboard.Widget widget, DashboardData data) {
        super(widget, data);
        this.addConfig(new ClientFilterConfig(this));
        this.addConfig(new ReportingPeriodConfig(this));
    }

    @Override
    public Composite createControl(Composite parent, DashboardResources resources) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo(container);
        this.title = new Label(container, 0);
        this.title.setText(TextUtil.tooltip((String)this.getWidget().getLabel()));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.title);
        this.indicator = new StyledLabel(container, 0);
        this.indicator.setFont(resources.getKpiFont());
        this.indicator.setText("");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.indicator);
        ImageHyperlink button = new ImageHyperlink(container, 0);
        button.setImage(Images.VIEW_SHARE.image());
        button.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AbstractTradesWidget.this.part.activateView(TradeDetailsView.class, (Object)AbstractTradesWidget.this.getUpdateTask().get());
            }
        });
        this.getDashboardData().getStylingEngine().style((Object)container);
        return container;
    }

    @Override
    public Control getTitleControl() {
        return this.title;
    }

    @Override
    public Supplier<TradeDetailsView.Input> getUpdateTask() {
        Interval interval = this.get(ReportingPeriodConfig.class).getReportingPeriod().toInterval(LocalDate.now());
        ClientFilter clientFilter = this.get(ClientFilterConfig.class).getSelectedFilter();
        CacheKey key = new CacheKey(TradeCollector.class, clientFilter, interval);
        return () -> {
            TradeDetailsView.Input input = (TradeDetailsView.Input)this.getDashboardData().getCache().computeIfAbsent(key, k -> {
                Client filteredClient = clientFilter.filter(this.getClient());
                TradeCollector collector = new TradeCollector(filteredClient, this.getDashboardData().getCurrencyConverter());
                ArrayList<Trade> trades = new ArrayList<Trade>();
                ArrayList<TradeCollectorException> errors = new ArrayList<TradeCollectorException>();
                this.getClient().getSecurities().forEach(s -> {
                    try {
                        trades.addAll(collector.collect(s));
                    }
                    catch (TradeCollectorException error) {
                        errors.add(error);
                    }
                });
                return new TradeDetailsView.Input(interval, trades, errors);
            });
            return new TradeDetailsView.Input(input.getInterval(), input.getTrades().stream().filter(this.getFilter(interval)).collect(Collectors.toList()), input.getErrors());
        };
    }

    protected Predicate<Trade> getFilter(Interval interval) {
        return t -> {
            if (!t.getEnd().isPresent()) {
                return false;
            }
            return interval.contains((LocalDateTime)t.getEnd().get());
        };
    }
}

