/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.editor.PartPersistedState;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.ConfirmAction;
import name.abuchen.portfolio.ui.util.ContextMenu;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.InfoToolTip;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.views.AbstractHistoricView;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.DashboardLayout;
import name.abuchen.portfolio.ui.views.dashboard.DashboardResources;
import name.abuchen.portfolio.ui.views.dashboard.ReportingPeriodApplyToAll;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import name.abuchen.portfolio.ui.views.dashboard.WidgetFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class DashboardView
extends AbstractHistoricView {
    public static final String INFO_MENU_GROUP_NAME = "info";
    private static final String SELECTED_DASHBOARD_KEY = "selected-dashboard";
    static final String DELEGATE_KEY = "$delegate";
    private static final String FILLER_KEY = "$filler";
    @Inject
    private PartPersistedState persistedState;
    @Inject
    private UISynchronize sync;
    private DashboardResources resources;
    private ScrolledComposite scrolledComposite;
    private Composite container;
    private Dashboard dashboard;
    private DashboardData dashboardData;
    private ExecutorService executor;
    private BlockingQueue<Map<WidgetDelegate<Object>, Supplier<Object>>> workQueue;

    @PostConstruct
    protected void postContruct() {
        this.executor = Executors.newSingleThreadExecutor();
        this.workQueue = new LinkedBlockingQueue<Map<WidgetDelegate<Object>, Supplier<Object>>>();
    }

    @PreDestroy
    protected void preDestroy() {
        this.executor.shutdownNow();
    }

    @Override
    protected String getDefaultTitle() {
        return Messages.LabelDashboard;
    }

    @Override
    public void notifyModelUpdated() {
        this.dashboardData.clearCache();
        this.updateWidgets();
    }

    @Override
    public void reportingPeriodUpdated() {
        this.dashboardData.setDefaultReportingPeriod(this.getReportingPeriod());
        this.dashboardData.clearResultCache();
        this.updateWidgets();
    }

    @Override
    protected void addViewButtons(ToolBarManager toolBar) {
        this.createDashboardToolItems(toolBar);
    }

    @Override
    protected void addButtons(ToolBarManager toolBar) {
        super.addButtons(toolBar);
        toolBar.add((IContributionItem)new DropDown(Messages.MenuConfigureCurrentDashboard, Images.CONFIG, 0, manager -> manager.add((IAction)new SimpleAction(Messages.MenuNewDashboardColumn, a -> this.createNewColumn()))));
    }

    private void createDashboardToolItems(ToolBarManager toolBar) {
        int[] index = new int[1];
        this.getClient().getDashboards().forEach(board -> {
            int n = index[0];
            nArray[0] = n + 1;
            toolBar.add((IContributionItem)this.createToolItem(n, (Dashboard)board));
        });
        SimpleAction newAction = new SimpleAction(Messages.MenuNewDashboard, a -> this.createNewDashboard(null));
        newAction.setImageDescriptor(Images.VIEW_PLUS.descriptor());
        toolBar.add((IAction)newAction);
    }

    private ContributionItem createToolItem(int index, Dashboard board) {
        DropDown toolItem = new DropDown(board.getName(), board.equals(this.dashboard) ? Images.VIEW_SELECTED : Images.VIEW, 4);
        toolItem.setMenuListener(manager -> {
            if (!board.equals(this.dashboard)) {
                manager.add((IAction)new SimpleAction(Messages.MenuShow, a -> this.selectDashboard(board)));
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IAction)new SimpleAction(Messages.ConfigurationDuplicate, a -> this.createNewDashboard(board)));
            manager.add((IAction)new SimpleAction(Messages.ConfigurationRename, a -> this.renameDashboard(board)));
            manager.add((IAction)new ConfirmAction(Messages.ConfigurationDelete, MessageFormat.format(Messages.ConfigurationDeleteConfirm, board.getName()), a -> this.deleteDashboard(board)));
            if (index > 0) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new SimpleAction(Messages.ChartBringToFront, a -> this.bringToFrontDashboard(board)));
            }
        });
        toolItem.setDefaultAction((IAction)new SimpleAction(Messages.MenuShow, a -> this.selectDashboard(board)));
        return toolItem;
    }

    private void recreateDashboardToolItems() {
        ToolBarManager toolBar = this.getViewToolBarManager();
        if (toolBar.getControl().isDisposed()) {
            return;
        }
        toolBar.removeAll();
        this.createDashboardToolItems(toolBar);
        toolBar.update(true);
    }

    @Override
    protected Control createBody(Composite parent) {
        this.resources = new DashboardResources(parent);
        this.dashboardData = this.make(DashboardData.class, new Object[0]);
        this.dashboardData.setDefaultReportingPeriods(this.getPart().getClientInput().getReportingPeriods());
        this.dashboardData.setDefaultReportingPeriod(this.getReportingPeriod());
        int indexOfSelectedDashboard = Math.max(0, this.persistedState.getInt(SELECTED_DASHBOARD_KEY));
        this.dashboard = this.getClient().getDashboards().skip(indexOfSelectedDashboard).findFirst().orElseGet(() -> {
            Dashboard newDashboard = this.createDefaultDashboard();
            this.getClient().addDashboard(newDashboard);
            this.markDirty();
            this.createDashboardToolItems(this.getToolBarManager());
            return newDashboard;
        });
        this.scrolledComposite = new ScrolledComposite(parent, 512);
        this.container = new Composite((Composite)this.scrolledComposite, 0);
        this.container.setLayout((Layout)new DashboardLayout());
        this.container.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"dashboard");
        this.selectDashboard(this.dashboard);
        this.scrolledComposite.setContent((Control)this.container);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        ControlListener listener = ControlListener.controlResizedAdapter(e -> this.updateScrolledCompositeMinSize());
        parent.getParent().addControlListener(listener);
        this.scrolledComposite.addDisposeListener(e -> parent.getParent().removeControlListener(listener));
        this.container.addDisposeListener(e -> this.persistedState.setValue(SELECTED_DASHBOARD_KEY, this.getClient().getDashboards().collect(Collectors.toList()).indexOf(this.dashboard)));
        return this.scrolledComposite;
    }

    private void updateScrolledCompositeMinSize() {
        if (this.scrolledComposite.isDisposed()) {
            return;
        }
        Composite parent = this.scrolledComposite.getParent();
        if (parent.isDisposed()) {
            return;
        }
        Composite grandparent = parent.getParent();
        if (grandparent.isDisposed()) {
            return;
        }
        Rectangle clientArea = grandparent.getClientArea();
        Point size = this.container.computeSize(clientArea.width, -1);
        if ("win32".equals(Platform.getOS()) && size.y > clientArea.height) {
            int width = clientArea.width - this.scrolledComposite.getVerticalBar().getSize().x;
            size = this.container.computeSize(width, -1);
        }
        this.scrolledComposite.setMinSize(size);
    }

    private void buildColumns() {
        for (Dashboard.Column column : this.dashboard.getColumns()) {
            this.buildColumn(this.container, column);
        }
        this.dashboardData.getStylingEngine().style((Object)this.container);
    }

    private Composite buildColumn(Composite composite, Dashboard.Column column) {
        Composite columnControl = new Composite(composite, 0);
        columnControl.setData((Object)column);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 0).applyTo(columnControl);
        this.addDropListener(columnControl);
        Composite filler = new Composite(columnControl, 0);
        GridDataFactory.fillDefaults().hint(-1, 10).grab(true, true).applyTo((Control)filler);
        columnControl.setData(FILLER_KEY, (Object)filler);
        new ContextMenu((Control)filler, manager -> this.columnMenuAboutToShow(manager, column, columnControl)).hook();
        for (Dashboard.Widget widget : column.getWidgets()) {
            try {
                WidgetFactory factory = WidgetFactory.valueOf(widget.getType());
                if (factory == null) continue;
                this.buildDelegate(columnControl, factory, widget);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return columnControl;
    }

    private void columnMenuAboutToShow(IMenuManager manager, Dashboard.Column column, Composite columnControl) {
        MenuManager subMenu = new MenuManager(Messages.MenuNewWidget);
        manager.add((IContributionItem)subMenu);
        HashMap<String, MenuManager> group2menu = new HashMap<String, MenuManager>();
        group2menu.put(null, subMenu);
        WidgetFactory[] widgetFactoryArray = WidgetFactory.values();
        int n = widgetFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            WidgetFactory type = widgetFactoryArray[n2];
            MenuManager mm = group2menu.computeIfAbsent(type.getGroup(), group -> {
                MenuManager groupMenu = new MenuManager(group);
                subMenu.add((IContributionItem)groupMenu);
                return groupMenu;
            });
            mm.add((IAction)new SimpleAction(type.getLabel(), a -> this.addNewWidget(columnControl, type)));
            ++n2;
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new SimpleAction(Messages.MenuAddNewDashboardColumnLeft, a -> this.createNewColumn(column, columnControl, 16384)));
        manager.add((IAction)new SimpleAction(Messages.MenuAddNewDashboardColumnRight, a -> this.createNewColumn(column, columnControl, 131072)));
        manager.add((IAction)new SimpleAction(Messages.MenuDuplicateDashboardColumn, a -> this.duplicateColumn(column, columnControl)));
        MenuManager columnWidth = new MenuManager(Messages.MenuDashboardColumnWidth);
        manager.add((IContributionItem)columnWidth);
        columnWidth.add((IAction)new SimpleAction(Messages.MenuDashboardColumnWidthIncrease, a -> {
            column.increaseWeight();
            this.container.layout(true);
        }));
        columnWidth.add((IAction)new SimpleAction(Messages.MenuDashboardColumnWidthDecrease, a -> {
            column.decreaseWeight();
            this.container.layout(true);
        }));
        MenuManager applyToAll = new MenuManager(Messages.MenuApplyToAllWidgets);
        manager.add((IContributionItem)applyToAll);
        new ReportingPeriodApplyToAll(this.dashboardData).menuAboutToShow(applyToAll, columnControl);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new SimpleAction(Messages.MenuDeleteDashboardColumn, a -> this.deleteColumn(columnControl)));
    }

    private WidgetDelegate<?> buildDelegate(Composite columnControl, WidgetFactory widgetType, Dashboard.Widget widget) {
        WidgetDelegate<?> delegate = widgetType.create(widget, this.dashboardData);
        this.inject(delegate);
        Composite element = delegate.createControl(columnControl, this.resources);
        element.setData((Object)widget);
        element.setData(DELEGATE_KEY, delegate);
        Composite filler = (Composite)columnControl.getData(FILLER_KEY);
        element.moveAbove((Control)filler);
        new ContextMenu(delegate.getTitleControl(), manager -> this.widgetMenuAboutToShow(manager, delegate)).hook();
        InfoToolTip.attach(delegate.getTitleControl(), () -> this.buildToolTip(delegate));
        this.addDragListener((Control)element);
        this.addDropListener(element);
        Control[] controlArray = element.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            this.addDragListener(child);
            ++n2;
        }
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)element);
        return delegate;
    }

    private String buildToolTip(WidgetDelegate<?> delegate) {
        StringJoiner text = new StringJoiner("\n");
        delegate.getWidgetConfigs().forEach(c -> {
            StringJoiner stringJoiner2 = text.add(c.getLabel());
        });
        return text.toString();
    }

    private void widgetMenuAboutToShow(IMenuManager manager, WidgetDelegate<?> delegate) {
        manager.add((IContributionItem)new Separator(INFO_MENU_GROUP_NAME));
        manager.add((IContributionItem)new Separator("edit"));
        delegate.getWidgetConfigs().forEach(c -> c.menuAboutToShow(manager));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new SimpleAction(Messages.MenuDeleteWidget, a -> {
            Composite composite = this.findCompositeFor(delegate);
            if (composite == null) {
                throw new IllegalArgumentException();
            }
            Composite parent = composite.getParent();
            Dashboard.Column column = (Dashboard.Column)parent.getData();
            if (!column.getWidgets().remove(delegate.getWidget())) {
                throw new IllegalArgumentException();
            }
            composite.dispose();
            parent.layout();
            this.updateScrolledCompositeMinSize();
            this.getClient().touch();
        }));
    }

    private Composite findCompositeFor(WidgetDelegate<?> delegate) {
        Control[] controlArray = this.container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control column = controlArray[n2];
            if (column instanceof Composite) {
                Control[] controlArray2 = ((Composite)column).getChildren();
                int n3 = controlArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Control child = controlArray2[n4];
                    if (child instanceof Composite && delegate.equals(child.getData(DELEGATE_KEY))) {
                        return (Composite)child;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private void addDragListener(Control control) {
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
        WidgetDragSourceAdapter dragAdapter = new WidgetDragSourceAdapter(transfer, control);
        DragSource dragSource = new DragSource(control, 3);
        dragSource.setTransfer(new Transfer[]{transfer});
        dragSource.addDragListener((DragSourceListener)dragAdapter);
    }

    private void addDropListener(Composite parent) {
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
        WidgetDropTargetAdapter dragAdapter = new WidgetDropTargetAdapter(this, transfer, parent, w -> this.markDirty());
        DropTarget dropTarget = new DropTarget((Control)parent, 3);
        dropTarget.setTransfer(new Transfer[]{transfer});
        dropTarget.addDropListener((DropTargetListener)dragAdapter);
    }

    private void updateWidgets() {
        Map<Dashboard.Widget, Object> currentCache = this.dashboardData.getResultCache();
        HashMap tasks = new HashMap();
        Control[] controlArray = this.container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control column = controlArray[n2];
            Control[] controlArray2 = ((Composite)column).getChildren();
            int n3 = controlArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Control child = controlArray2[n4];
                WidgetDelegate delegate = (WidgetDelegate)child.getData(DELEGATE_KEY);
                if (delegate != null) {
                    Object data = currentCache.get(delegate.getWidget());
                    if (DashboardData.EMPTY_RESULT.equals(data)) {
                        delegate.update(null);
                    } else if (data != null) {
                        delegate.update(data);
                    } else {
                        tasks.put(delegate, delegate.getUpdateTask());
                    }
                }
                ++n4;
            }
            ++n2;
        }
        this.updateScrolledCompositeMinSize();
        if (!tasks.isEmpty()) {
            this.workQueue.add(tasks);
            this.executor.submit(new CalculateWidgetDataRunnable(currentCache));
        }
    }

    private void selectDashboard(Dashboard board) {
        this.dashboardData.setDashboard(board);
        this.dashboard = board;
        this.updateTitle(board.getName());
        this.recreateDashboardToolItems();
        Control[] controlArray = this.container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control column = controlArray[n2];
            column.dispose();
            ++n2;
        }
        this.buildColumns();
        this.container.layout(true);
        this.updateScrolledCompositeMinSize();
        this.updateWidgets();
    }

    private void createNewDashboard(Dashboard template) {
        Dashboard newDashboard = template != null ? template.copy() : this.createDefaultDashboard();
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ConfigurationNew, Messages.ColumnName, newDashboard.getName(), null);
        if (dialog.open() != 0) {
            return;
        }
        newDashboard.setName(dialog.getValue());
        this.getClient().addDashboard(newDashboard);
        this.getClient().touch();
        this.selectDashboard(newDashboard);
    }

    private void renameDashboard(Dashboard board) {
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.MenuRenameDashboard, Messages.ColumnName, board.getName(), null);
        if (dialog.open() != 0) {
            return;
        }
        board.setName(dialog.getValue());
        this.getClient().touch();
        this.updateTitle(board.getName());
        this.recreateDashboardToolItems();
    }

    private void deleteDashboard(Dashboard board) {
        this.getClient().removeDashboard(board);
        this.getClient().touch();
        this.recreateDashboardToolItems();
        this.selectDashboard(this.getClient().getDashboards().findFirst().orElseGet(() -> {
            Dashboard newDashboard = this.createDefaultDashboard();
            this.getClient().addDashboard(newDashboard);
            this.getClient().touch();
            return newDashboard;
        }));
    }

    private void bringToFrontDashboard(Dashboard board) {
        this.getClient().removeDashboard(board);
        this.getClient().addDashboard(0, board);
        this.getClient().touch();
        this.recreateDashboardToolItems();
    }

    private void addNewWidget(Composite columnControl, WidgetFactory widgetType) {
        Dashboard.Column column = (Dashboard.Column)columnControl.getData();
        Dashboard.Widget widget = new Dashboard.Widget();
        widget.setLabel(widgetType.getLabel());
        widget.setType(widgetType.name());
        column.getWidgets().add(widget);
        WidgetDelegate<?> delegate = this.buildDelegate(columnControl, widgetType, widget);
        this.getClient().touch();
        delegate.update();
        columnControl.layout(true);
        this.updateScrolledCompositeMinSize();
    }

    private void createNewColumn() {
        Dashboard.Column column = new Dashboard.Column();
        this.dashboard.getColumns().add(column);
        this.getClient().touch();
        this.buildColumn(this.container, column);
        this.container.layout(true);
        this.updateScrolledCompositeMinSize();
    }

    private void createNewColumn(Dashboard.Column referenceColumn, Composite referenceColumnControl, int position) {
        int index = this.dashboard.getColumns().indexOf(referenceColumn);
        if (position == 131072) {
            ++index;
        }
        Dashboard.Column newColumn = new Dashboard.Column();
        this.dashboard.getColumns().add(index, newColumn);
        this.getClient().touch();
        Composite c = this.buildColumn(this.container, newColumn);
        if (position == 131072) {
            c.moveBelow((Control)referenceColumnControl);
        } else {
            c.moveAbove((Control)referenceColumnControl);
        }
        this.container.layout(true);
        this.updateScrolledCompositeMinSize();
    }

    private void duplicateColumn(Dashboard.Column column, Composite columnControl) {
        int index = this.dashboard.getColumns().indexOf(column) + 1;
        Dashboard.Column newColumn = new Dashboard.Column();
        this.dashboard.getColumns().add(index, newColumn);
        newColumn.setWidgets(column.getWidgets().stream().map(widget -> {
            Dashboard.Widget copy = new Dashboard.Widget();
            copy.setLabel(widget.getLabel());
            copy.setType(widget.getType());
            copy.getConfiguration().putAll(widget.getConfiguration());
            return copy;
        }).collect(Collectors.toList()));
        this.getClient().touch();
        this.buildColumn(this.container, newColumn).moveBelow((Control)columnControl);
        this.container.layout(true);
        this.updateScrolledCompositeMinSize();
        this.updateWidgets();
    }

    private void deleteColumn(Composite columnControl) {
        Dashboard.Column column = (Dashboard.Column)columnControl.getData();
        this.dashboard.getColumns().remove(column);
        this.markDirty();
        columnControl.dispose();
        this.container.layout(true);
        this.updateScrolledCompositeMinSize();
    }

    private Dashboard createDefaultDashboard() {
        Dashboard newDashboard = new Dashboard();
        newDashboard.setName(Messages.LabelDashboard);
        newDashboard.getConfiguration().put(Dashboard.Config.REPORTING_PERIOD.name(), "L1Y0");
        Dashboard.Column column = new Dashboard.Column();
        newDashboard.getColumns().add(column);
        Dashboard.Widget widget = new Dashboard.Widget();
        widget.setType(WidgetFactory.HEADING.name());
        widget.setLabel(Messages.LabelKeyIndicators);
        column.getWidgets().add(widget);
        widget = new Dashboard.Widget();
        widget.setType(WidgetFactory.TTWROR.name());
        widget.setLabel(WidgetFactory.TTWROR.getLabel());
        column.getWidgets().add(widget);
        widget = new Dashboard.Widget();
        widget.setType(WidgetFactory.IRR.name());
        widget.setLabel(WidgetFactory.IRR.getLabel());
        column.getWidgets().add(widget);
        widget = new Dashboard.Widget();
        widget.setType(WidgetFactory.ABSOLUTE_CHANGE.name());
        widget.setLabel(WidgetFactory.ABSOLUTE_CHANGE.getLabel());
        column.getWidgets().add(widget);
        widget = new Dashboard.Widget();
        widget.setType(WidgetFactory.DELTA.name());
        widget.setLabel(WidgetFactory.DELTA.getLabel());
        column.getWidgets().add(widget);
        widget = new Dashboard.Widget();
        widget.setType(WidgetFactory.HEADING.name());
        widget.setLabel(Messages.LabelTTWROROneDay);
        column.getWidgets().add(widget);
        widget = new Dashboard.Widget();
        widget.setType(WidgetFactory.TTWROR.name());
        widget.setLabel(WidgetFactory.TTWROR.getLabel());
        widget.getConfiguration().put(Dashboard.Config.REPORTING_PERIOD.name(), "T1");
        column.getWidgets().add(widget);
        widget = new Dashboard.Widget();
        widget.setType(WidgetFactory.ABSOLUTE_CHANGE.name());
        widget.setLabel(WidgetFactory.ABSOLUTE_CHANGE.getLabel());
        widget.getConfiguration().put(Dashboard.Config.REPORTING_PERIOD.name(), "T1");
        column.getWidgets().add(widget);
        column = new Dashboard.Column();
        newDashboard.getColumns().add(column);
        widget = new Dashboard.Widget();
        widget.setType(WidgetFactory.HEADING.name());
        widget.setLabel(Messages.LabelRiskIndicators);
        column.getWidgets().add(widget);
        widget = new Dashboard.Widget();
        widget.setType(WidgetFactory.MAXDRAWDOWN.name());
        widget.setLabel(WidgetFactory.MAXDRAWDOWN.getLabel());
        column.getWidgets().add(widget);
        widget = new Dashboard.Widget();
        widget.setType(WidgetFactory.MAXDRAWDOWNDURATION.name());
        widget.setLabel(WidgetFactory.MAXDRAWDOWNDURATION.getLabel());
        column.getWidgets().add(widget);
        widget = new Dashboard.Widget();
        widget.setType(WidgetFactory.VOLATILITY.name());
        widget.setLabel(WidgetFactory.VOLATILITY.getLabel());
        column.getWidgets().add(widget);
        widget = new Dashboard.Widget();
        widget.setType(WidgetFactory.SEMIVOLATILITY.name());
        widget.setLabel(WidgetFactory.SEMIVOLATILITY.getLabel());
        column.getWidgets().add(widget);
        column = new Dashboard.Column();
        newDashboard.getColumns().add(column);
        widget = new Dashboard.Widget();
        widget.setType(WidgetFactory.HEADING.name());
        widget.setLabel(Messages.PerformanceTabCalculation);
        column.getWidgets().add(widget);
        widget = new Dashboard.Widget();
        widget.setType(WidgetFactory.CALCULATION.name());
        widget.setLabel(WidgetFactory.CALCULATION.getLabel());
        column.getWidgets().add(widget);
        return newDashboard;
    }

    private final class CalculateWidgetDataRunnable
    implements Runnable {
        private final Map<Dashboard.Widget, Object> cache;

        private CalculateWidgetDataRunnable(Map<Dashboard.Widget, Object> cache) {
            this.cache = cache;
        }

        @Override
        public void run() {
            ArrayList queueTasks = new ArrayList();
            DashboardView.this.workQueue.drainTo(queueTasks);
            if (queueTasks.isEmpty()) {
                return;
            }
            Map tasks = (Map)queueTasks.get(queueTasks.size() - 1);
            HashMap data = new HashMap();
            for (Map.Entry task : tasks.entrySet()) {
                try {
                    data.put((WidgetDelegate)task.getKey(), ((Supplier)task.getValue()).get());
                }
                catch (Exception e) {
                    PortfolioPlugin.log(e);
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            DashboardView.this.sync.asyncExec(() -> {
                data.entrySet().stream().filter(entry -> !((WidgetDelegate)entry.getKey()).getTitleControl().isDisposed()).forEach(entry -> {
                    try {
                        ((WidgetDelegate)entry.getKey()).update(entry.getValue());
                        if (entry.getValue() == null) {
                            this.cache.put(((WidgetDelegate)entry.getKey()).getWidget(), DashboardData.EMPTY_RESULT);
                        } else {
                            this.cache.put(((WidgetDelegate)entry.getKey()).getWidget(), entry.getValue());
                        }
                    }
                    catch (RuntimeException e) {
                        PortfolioPlugin.log(e);
                    }
                });
                DashboardView.this.updateScrolledCompositeMinSize();
            });
        }
    }

    private static final class WidgetDragSourceAdapter
    extends DragSourceAdapter {
        private final LocalSelectionTransfer transfer;
        private final Control dragSource;

        private WidgetDragSourceAdapter(LocalSelectionTransfer transfer, Control control) {
            this.transfer = transfer;
            this.dragSource = control;
        }

        public void dragSetData(DragSourceEvent event) {
            Control widgetComposite = this.dragSource;
            while (!(widgetComposite.getData() instanceof Dashboard.Widget)) {
                widgetComposite = widgetComposite.getParent();
            }
            this.transfer.setSelection((ISelection)new StructuredSelection((Object)widgetComposite));
        }

        public void dragStart(DragSourceEvent event) {
            Control control = ((DragSource)event.getSource()).getControl();
            while (!(control.getData() instanceof Dashboard.Widget)) {
                control = control.getParent();
            }
            Point size = control.getSize();
            GC gc = new GC((Drawable)control);
            Image image = new Image((Device)control.getDisplay(), size.x, size.y);
            gc.copyArea(image, 0, 0);
            gc.dispose();
            event.image = image;
        }
    }

    private static final class WidgetDropTargetAdapter
    extends DropTargetAdapter {
        private final DashboardView dashboardView;
        private final LocalSelectionTransfer transfer;
        private final Composite dropTarget;
        private final Consumer<Dashboard.Widget> listener;

        private WidgetDropTargetAdapter(DashboardView dashboardView, LocalSelectionTransfer transfer, Composite dropTarget, Consumer<Dashboard.Widget> listener) {
            this.dashboardView = dashboardView;
            this.transfer = transfer;
            this.dropTarget = dropTarget;
            this.listener = listener;
        }

        public void drop(DropTargetEvent event) {
            Object droppedElement = ((StructuredSelection)this.transfer.getSelection()).getFirstElement();
            if (!(droppedElement instanceof Composite)) {
                return;
            }
            Composite droppedComposite = (Composite)droppedElement;
            if (droppedComposite.equals(this.dropTarget)) {
                return;
            }
            Dashboard.Widget droppedWidget = (Dashboard.Widget)droppedComposite.getData();
            if (droppedWidget == null) {
                throw new IllegalArgumentException();
            }
            Composite oldParent = droppedComposite.getParent();
            Dashboard.Column oldColumn = (Dashboard.Column)oldParent.getData();
            if (oldColumn == null) {
                throw new IllegalArgumentException();
            }
            Composite newParent = this.dropTarget;
            while (!(newParent.getData() instanceof Dashboard.Column)) {
                newParent = newParent.getParent();
            }
            Dashboard.Column newColumn = (Dashboard.Column)newParent.getData();
            droppedComposite.setParent(newParent);
            if (this.dropTarget.getData() instanceof Dashboard.Widget) {
                droppedComposite.moveAbove((Control)this.dropTarget);
                Dashboard.Widget dropTargetWidget = (Dashboard.Widget)this.dropTarget.getData();
                oldColumn.getWidgets().remove(droppedWidget);
                newColumn.getWidgets().add(newColumn.getWidgets().indexOf(dropTargetWidget), droppedWidget);
            } else if (this.dropTarget.getData() instanceof Dashboard.Column) {
                Composite filler = (Composite)newParent.getData(DashboardView.FILLER_KEY);
                droppedComposite.moveAbove((Control)filler);
                oldColumn.getWidgets().remove(droppedWidget);
                newColumn.getWidgets().add(droppedWidget);
            } else {
                throw new IllegalArgumentException();
            }
            this.listener.accept(droppedWidget);
            oldParent.layout();
            newParent.layout();
        }

        public void dragEnter(DropTargetEvent event) {
            Composite filler = (Composite)this.dropTarget.getData(DashboardView.FILLER_KEY);
            (filler != null ? filler : this.dropTarget).setBackground(Colors.DARK_GRAY);
        }

        public void dragLeave(DropTargetEvent event) {
            Composite filler = (Composite)this.dropTarget.getData(DashboardView.FILLER_KEY);
            (filler != null ? filler : this.dropTarget).setBackground(this.dashboardView.getControl().getBackground());
        }
    }
}

