/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.views.dashboard.WidgetConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;

public class EnumBasedConfig<E extends Enum<E>>
implements WidgetConfig {
    private final Policy policy;
    private final WidgetDelegate<?> delegate;
    private final Dashboard.Config configurationKey;
    private final String label;
    private final Class<E> type;
    private final String pathToMenu;
    private EnumSet<E> values;

    public EnumBasedConfig(WidgetDelegate<?> delegate, String label, Class<E> type, Dashboard.Config configurationKey, Policy policy) {
        this(delegate, label, type, configurationKey, policy, null);
    }

    public EnumBasedConfig(WidgetDelegate<?> delegate, String label, Class<E> type, Dashboard.Config configurationKey, Policy policy, String pathToMenu) {
        this.delegate = delegate;
        this.configurationKey = configurationKey;
        this.label = label;
        this.type = type;
        this.policy = policy;
        this.pathToMenu = pathToMenu;
        this.values = EnumSet.noneOf(type);
        String code = (String)delegate.getWidget().getConfiguration().get(configurationKey.name());
        if (code != null && !code.isEmpty()) {
            try {
                String[] codes;
                String[] stringArray = codes = code.split(",");
                int n = codes.length;
                int n2 = 0;
                while (n2 < n) {
                    String c = stringArray[n2];
                    this.values.add(Enum.valueOf(type, c));
                    ++n2;
                }
            }
            catch (IllegalArgumentException ignore) {
                PortfolioPlugin.log(ignore);
            }
        }
        if (this.values.isEmpty() && policy == Policy.EXACTLY_ONE) {
            this.values.add(((Enum[])type.getEnumConstants())[0]);
        }
    }

    @Override
    public void menuAboutToShow(IMenuManager manager) {
        MenuManager subMenu = new MenuManager(this.label);
        Enum[] enumArray = (Enum[])this.type.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum v = enumArray[n2];
            subMenu.add((IAction)this.buildAction(v));
            ++n2;
        }
        if (this.pathToMenu != null) {
            IMenuManager alternative = manager.findMenuUsingPath(this.pathToMenu);
            alternative.add((IContributionItem)new Separator());
            alternative.add((IContributionItem)subMenu);
        } else {
            manager.add((IContributionItem)subMenu);
        }
    }

    private Action buildAction(E value) {
        SimpleAction action = new SimpleAction(((Enum)value).toString(), a -> {
            switch (this.policy) {
                case EXACTLY_ONE: {
                    this.values.clear();
                    this.values.add((Enum)value);
                    break;
                }
                case MULTIPLE: {
                    boolean isActive = this.values.contains(value);
                    if (isActive) {
                        this.values.remove(value);
                        break;
                    }
                    this.values.add((Enum)value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.delegate.getWidget().getConfiguration().put(this.configurationKey.name(), this.values.stream().map(Enum::name).collect(Collectors.joining(",")));
            this.delegate.update();
            this.delegate.getClient().touch();
        });
        action.setChecked(this.values.contains(value));
        return action;
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.label) + ": " + this.values.stream().map(Enum::toString).collect(Collectors.joining(", "));
    }

    public E getValue() {
        if (this.policy != Policy.EXACTLY_ONE) {
            throw new IllegalArgumentException();
        }
        return (E)((Enum)this.values.iterator().next());
    }

    public Set<E> getValues() {
        return this.values;
    }

    public static enum Policy {
        EXACTLY_ONE,
        MULTIPLE;

    }
}

