/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Optional;
import java.util.function.Supplier;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.ExchangeRateTimeSeries;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.ReportingPeriod;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.InfoToolTip;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.DashboardResources;
import name.abuchen.portfolio.ui.views.dashboard.ExchangeRateSeriesConfig;
import name.abuchen.portfolio.ui.views.dashboard.ReportingPeriodConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ExchangeRateWidget
extends WidgetDelegate<Object> {
    private DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).withZone(ZoneId.systemDefault());
    private Label title;
    private Label indicator;

    public ExchangeRateWidget(Dashboard.Widget widget, DashboardData dashboardData) {
        super(widget, dashboardData);
        this.addConfig(new ExchangeRateSeriesConfig(this));
        this.addConfig(new ReportingPeriodConfig(this));
    }

    @Override
    public Composite createControl(Composite parent, DashboardResources resources) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(container);
        this.title = new Label(container, 0);
        this.title.setText(TextUtil.tooltip((String)this.getWidget().getLabel()));
        this.title.setBackground(container.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.title);
        this.indicator = new Label(container, 0);
        this.indicator.setFont(resources.getKpiFont());
        this.indicator.setBackground(container.getBackground());
        this.indicator.setText("");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.indicator);
        InfoToolTip.attach((Control)this.indicator, () -> {
            ReportingPeriod period = this.get(ReportingPeriodConfig.class).getReportingPeriod();
            ExchangeRateTimeSeries series = this.get(ExchangeRateSeriesConfig.class).getSeries();
            Optional rate = series.lookupRate(period.toInterval(LocalDate.now()).getEnd());
            return rate.isPresent() ? MessageFormat.format(Messages.TooltipDateOfExchangeRate, this.formatter.format(((ExchangeRate)rate.get()).getTime())) : "";
        });
        this.update((Object)null);
        return container;
    }

    @Override
    public Control getTitleControl() {
        return this.title;
    }

    @Override
    public Supplier<Object> getUpdateTask() {
        return () -> null;
    }

    @Override
    public void update(Object data) {
        this.title.setText(TextUtil.tooltip((String)this.getWidget().getLabel()));
        ReportingPeriod period = this.get(ReportingPeriodConfig.class).getReportingPeriod();
        ExchangeRateTimeSeries series = this.get(ExchangeRateSeriesConfig.class).getSeries();
        Optional rate = series.lookupRate(period.toInterval(LocalDate.now()).getEnd());
        this.indicator.setText(String.valueOf(series.getBaseCurrency()) + '/' + series.getTermCurrency() + ' ' + (rate.isPresent() ? Values.ExchangeRate.format((Object)((ExchangeRate)rate.get()).getValue()) : Character.valueOf('-')));
    }
}

