/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.function.Supplier;
import name.abuchen.portfolio.math.Risk;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.snapshot.PerformanceIndex;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.InfoToolTip;
import name.abuchen.portfolio.ui.views.dashboard.AbstractIndicatorWidget;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.DashboardResources;
import name.abuchen.portfolio.ui.views.dashboard.DataSeriesConfig;
import name.abuchen.portfolio.ui.views.dashboard.ReportingPeriodConfig;
import name.abuchen.portfolio.util.Interval;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MaxDrawdownDurationWidget
extends AbstractIndicatorWidget<PerformanceIndex> {
    private DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).withZone(ZoneId.systemDefault());
    private String toolTip = "";

    public MaxDrawdownDurationWidget(Dashboard.Widget widget, DashboardData dashboardData) {
        super(widget, dashboardData, true);
    }

    public String getToolTip() {
        return this.toolTip;
    }

    @Override
    public Composite createControl(Composite parent, DashboardResources resources) {
        Composite composite = super.createControl(parent, resources);
        InfoToolTip.attach((Control)this.indicator, this::getToolTip);
        return composite;
    }

    @Override
    public Supplier<PerformanceIndex> getUpdateTask() {
        return () -> this.getDashboardData().getDataSeriesCache().lookup(this.get(DataSeriesConfig.class).getDataSeries(), this.get(ReportingPeriodConfig.class).getReportingPeriod().toInterval(LocalDate.now()));
    }

    @Override
    public void update(PerformanceIndex index) {
        super.update(index);
        Risk.Drawdown drawdown = index.getDrawdown();
        Interval maxDDDuration = drawdown.getMaxDrawdownDuration();
        this.indicator.setText(MessageFormat.format(Messages.LabelXDays, maxDDDuration.getDays()));
        boolean isUntilEndOfPeriod = maxDDDuration.getEnd().equals(index.getReportInterval().getEnd());
        String maxDDSupplement = isUntilEndOfPeriod ? Messages.TooltipMaxDrawdownDurationEndOfPeriod : Messages.TooltipMaxDrawdownDurationFromXtoY;
        Interval recoveryTime = drawdown.getLongestRecoveryTime();
        isUntilEndOfPeriod = recoveryTime.getEnd().equals(index.getReportInterval().getEnd());
        String recoveryTimeSupplement = isUntilEndOfPeriod ? Messages.TooltipMaxDrawdownDurationEndOfPeriod : Messages.TooltipMaxDrawdownDurationFromXtoY;
        this.toolTip = String.valueOf(Messages.TooltipMaxDrawdownDuration) + "\n\n" + MessageFormat.format(maxDDSupplement, this.formatter.format(maxDDDuration.getStart()), this.formatter.format(maxDDDuration.getEnd())) + "\n\n" + MessageFormat.format(Messages.TooltipMaxDurationLowToHigh, recoveryTime.getDays()) + "\n" + MessageFormat.format(recoveryTimeSupplement, this.formatter.format(recoveryTime.getStart()), this.formatter.format(recoveryTime.getEnd()));
    }
}

