/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import com.ibm.icu.text.MessageFormat;
import java.util.List;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.snapshot.trades.Trade;
import name.abuchen.portfolio.ui.views.dashboard.AbstractTradesWidget;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.trades.TradeDetailsView;
import name.abuchen.portfolio.util.TextUtil;

public class TradesWidget
extends AbstractTradesWidget {
    public TradesWidget(Dashboard.Widget widget, DashboardData dashboardData) {
        super(widget, dashboardData);
    }

    @Override
    public void update(TradeDetailsView.Input input) {
        this.title.setText(TextUtil.tooltip((String)this.getWidget().getLabel()));
        List<Trade> trades = input.getTrades();
        long positive = trades.stream().filter(t -> t.getProfitLoss().isPositive()).count();
        String text = MessageFormat.format((String)"{0} <green>\u2191{1}</green> <red>\u2193{2}</red>", (Object[])new Object[]{trades.size(), positive, (long)trades.size() - positive});
        this.indicator.setText(text);
    }
}

