/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import java.text.MessageFormat;
import java.util.function.Supplier;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.DashboardResources;
import name.abuchen.portfolio.ui.views.dashboard.WidgetConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class VerticalSpacerWidget
extends WidgetDelegate<Object> {
    private Label title;

    public VerticalSpacerWidget(Dashboard.Widget widget, DashboardData dashboardData) {
        super(widget, dashboardData);
        this.addConfig(new SpacerConfig(this));
    }

    @Override
    public Composite createControl(Composite parent, DashboardResources resources) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().applyTo(container);
        this.title = new Label(container, 0x1000000);
        this.title.setText("");
        this.title.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                VerticalSpacerWidget.this.title.setText("");
            }

            public void mouseEnter(MouseEvent e) {
                VerticalSpacerWidget.this.title.setText(TextUtil.tooltip((String)VerticalSpacerWidget.this.getWidget().getLabel()));
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, this.get(SpacerConfig.class).getHeight()).applyTo((Control)this.title);
        return container;
    }

    @Override
    public Control getTitleControl() {
        return this.title;
    }

    @Override
    public Supplier<Object> getUpdateTask() {
        return () -> null;
    }

    @Override
    public void update(Object d) {
        int newHeight;
        GridData data = (GridData)this.title.getLayoutData();
        int oldHeight = data.heightHint;
        data.heightHint = newHeight = this.get(SpacerConfig.class).getHeight();
        this.title.setText("");
        if (oldHeight != newHeight) {
            this.title.getParent().layout(true);
            this.title.getParent().getParent().layout(true);
        }
    }

    public static class SpacerConfig
    implements WidgetConfig {
        private static final int MINIMUM_HEIGHT = 5;
        private final WidgetDelegate<?> delegate;
        private int height = 20;

        public SpacerConfig(WidgetDelegate<?> delegate) {
            this.delegate = delegate;
            String code = (String)delegate.getWidget().getConfiguration().get(Dashboard.Config.HEIGHT.name());
            if (code != null) {
                try {
                    this.height = Integer.parseInt(code);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void menuAboutToShow(IMenuManager manager) {
            manager.appendToGroup("info", (IAction)new LabelOnly(this.getLabel()));
            IInputValidator validator = newText -> {
                try {
                    int newHeight = Integer.parseInt(newText);
                    if (newHeight < 5) {
                        return MessageFormat.format(Messages.MsgErrorMinimumHeightRequired, 5);
                    }
                    return null;
                }
                catch (NumberFormatException e) {
                    return String.format(Messages.CellEditor_NotANumber, newText);
                }
            };
            manager.add((IAction)new SimpleAction(Messages.MenuChangeHeight, a -> {
                InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.MenuChangeHeight, Messages.ColumnHeight, String.valueOf(this.height), validator);
                if (dialog.open() != 0) {
                    return;
                }
                this.height = Integer.parseInt(dialog.getValue());
                this.delegate.getWidget().getConfiguration().put(Dashboard.Config.HEIGHT.name(), String.valueOf(this.height));
                this.delegate.update();
                this.delegate.getClient().touch();
            }));
        }

        @Override
        public String getLabel() {
            return String.valueOf(Messages.ColumnHeight) + ": " + Integer.valueOf(this.height);
        }

        public int getHeight() {
            return this.height;
        }
    }
}

