/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.DashboardResources;
import name.abuchen.portfolio.ui.views.dashboard.LabelConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetConfig;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class WidgetDelegate<D> {
    private final Dashboard.Widget widget;
    private final DashboardData data;
    private final List<WidgetConfig> config = new ArrayList<WidgetConfig>();

    public WidgetDelegate(Dashboard.Widget widget, DashboardData data) {
        this.widget = widget;
        this.data = data;
        this.addConfig(new LabelConfig(this));
    }

    public final void addConfig(WidgetConfig config) {
        this.config.add(config);
    }

    public Client getClient() {
        return this.data.getClient();
    }

    public Dashboard.Widget getWidget() {
        return this.widget;
    }

    public DashboardData getDashboardData() {
        return this.data;
    }

    public <C extends WidgetConfig> C get(Class<C> type) {
        return (C)((WidgetConfig)type.cast(this.config.stream().filter(c -> type.equals(c.getClass())).findAny().orElseThrow(IllegalArgumentException::new)));
    }

    public <C extends WidgetConfig> Optional<C> optionallyGet(Class<C> type) {
        return this.config.stream().filter(c -> type.equals(c.getClass())).findAny().map(type::cast);
    }

    public Stream<WidgetConfig> getWidgetConfigs() {
        return this.config.stream();
    }

    public abstract Composite createControl(Composite var1, DashboardResources var2);

    public final void update() {
        D result = this.getUpdateTask().get();
        this.data.getResultCache().put(this.widget, result != null ? result : DashboardData.EMPTY_RESULT);
        this.update(result);
    }

    public abstract Supplier<D> getUpdateTask();

    public abstract void update(D var1);

    public abstract Control getTitleControl();
}

