/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dataseries;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesSet;
import org.swtchart.LineStyle;

public class DataSeriesSerializer {
    public List<DataSeries> fromString(DataSeriesSet set, String config) {
        ArrayList<DataSeries> series = new ArrayList<DataSeries>();
        if (config != null && config.trim().length() > 0) {
            this.load(set, config, series);
        }
        if (series.isEmpty()) {
            set.getAvailableSeries().stream().filter(s -> s.getType() == DataSeries.Type.CLIENT && (s.getInstance() == DataSeries.ClientDataSeries.TOTALS || s.getInstance() == DataSeries.ClientDataSeries.TRANSFERALS)).forEach(series::add);
        }
        return series;
    }

    private void load(DataSeriesSet set, String config, List<DataSeries> series) {
        String[] items;
        Map<String, DataSeries> uuid2series = set.getAvailableSeries().stream().collect(Collectors.toMap(DataSeries::getUUID, s -> s));
        String[] stringArray = items = config.split(",");
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            String[] data = item.split(";");
            String uuid = data[0];
            DataSeries s2 = uuid2series.get(uuid);
            if (s2 != null) {
                series.add(s2);
                if (data.length == 4) {
                    s2.setColor(Colors.toRGB(data[1]));
                    s2.setLineStyle(LineStyle.valueOf((String)data[2]));
                    s2.setShowArea(Boolean.parseBoolean(data[3]));
                }
            }
            ++n2;
        }
    }

    public String toString(List<DataSeries> series) {
        StringBuilder buf = new StringBuilder();
        for (DataSeries s : series) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(s.getUUID()).append(';');
            buf.append(Colors.toHex(s.getColor())).append(';');
            buf.append(s.getLineStyle().name()).append(';');
            buf.append(s.isShowArea());
        }
        return buf.toString();
    }
}

