/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.earnings;

import java.text.DateFormatSymbols;
import java.text.Format;
import java.util.Arrays;
import javax.inject.Inject;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.chart.TimelineChart;
import name.abuchen.portfolio.ui.util.chart.TimelineChartToolTip;
import name.abuchen.portfolio.ui.views.earnings.EarningsTab;
import name.abuchen.portfolio.ui.views.earnings.EarningsViewModel;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.ISeries;
import org.swtchart.Range;

public abstract class AbstractChartTab
implements EarningsTab {
    private static final int[][] COLORS = new int[][]{{140, 86, 75}, {227, 119, 194}, {127, 127, 127}, {188, 189, 34}, {23, 190, 207}, {114, 124, 201}, {250, 115, 92}, {253, 182, 103}, {143, 207, 112}, {87, 207, 253}, {31, 119, 180}, {255, 127, 14}, {44, 160, 44}, {214, 39, 40}, {148, 103, 189}};
    @Inject
    protected EarningsViewModel model;
    private LocalResourceManager resources;
    private Chart chart;

    protected abstract void createSeries();

    protected Chart getChart() {
        return this.chart;
    }

    protected LocalResourceManager getResources() {
        return this.resources;
    }

    @Override
    public Control createControl(Composite parent) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.chart = new Chart(parent, 0);
        this.chart.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"chart");
        this.chart.getTitle().setVisible(false);
        this.chart.getLegend().setPosition(1024);
        IAxis xAxis = this.chart.getAxisSet().getXAxis(0);
        xAxis.getTitle().setVisible(false);
        xAxis.getTitle().setText(Messages.ColumnMonth);
        IAxis yAxis = this.chart.getAxisSet().getYAxis(0);
        yAxis.getTitle().setVisible(false);
        yAxis.setPosition(IAxis.Position.Secondary);
        xAxis.enableCategory(true);
        xAxis.setCategorySeries(Arrays.copyOfRange(new DateFormatSymbols().getMonths(), 0, 12));
        this.createSeries();
        this.chart.getAxisSet().adjustRange();
        Range r = yAxis.getRange();
        if (r.lower < -1000.0 || r.upper > 1000.0) {
            yAxis.getTick().setFormat((Format)new TimelineChart.ThousandsNumberFormat());
        }
        this.attachTooltipTo(this.chart);
        this.model.addUpdateListener(this::updateChart);
        return this.chart;
    }

    protected void attachTooltipTo(Chart chart) {
        TimelineChartToolTip toolTip = new TimelineChartToolTip(chart);
        toolTip.enableCategory(true);
    }

    protected Color getColor(int year) {
        RGB rgb = new RGB(COLORS[year % COLORS.length][0], COLORS[year % COLORS.length][1], COLORS[year % COLORS.length][2]);
        return this.resources.createColor(ColorDescriptor.createFrom((RGB)rgb));
    }

    private void updateChart() {
        try {
            this.chart.suspendUpdate(true);
            ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries s = iSeriesArray[n2];
                this.chart.getSeriesSet().deleteSeries(s.getId());
                ++n2;
            }
            this.createSeries();
            this.chart.getAxisSet().adjustRange();
        }
        finally {
            this.chart.suspendUpdate(false);
        }
        this.chart.redraw();
    }
}

