/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.earnings;

import java.text.MessageFormat;
import java.util.function.Function;
import javax.inject.Inject;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.selection.SecuritySelection;
import name.abuchen.portfolio.ui.selection.SelectionService;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.LogoManager;
import name.abuchen.portfolio.ui.util.TableViewerCSVExporter;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.SharesLabelProvider;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.views.earnings.EarningsTab;
import name.abuchen.portfolio.ui.views.earnings.EarningsViewModel;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TransactionsTab
implements EarningsTab {
    @Inject
    private Client client;
    @Inject
    private EarningsViewModel model;
    @Inject
    private SelectionService selectionService;
    @Inject
    private IPreferenceStore preferences;
    private TableViewer tableViewer;

    @Override
    public String getLabel() {
        return Messages.LabelTransactions;
    }

    @Override
    public void addExportActions(IMenuManager manager) {
        manager.add((IAction)new Action(MessageFormat.format(Messages.LabelExport, Messages.LabelTransactions)){

            public void run() {
                new TableViewerCSVExporter(TransactionsTab.this.tableViewer).export(String.valueOf(Messages.LabelTransactions) + ".csv");
            }
        });
    }

    @Override
    public Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(container, 65538);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        ShowHideColumnHelper support = new ShowHideColumnHelper(String.valueOf(TransactionsTab.class.getSimpleName()) + "@v3", this.preferences, this.tableViewer, layout);
        this.addColumns(support);
        support.createColumns();
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.addSelectionChangedListener(event -> {
            TransactionPair tx = (TransactionPair)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (tx != null && tx.getTransaction().getSecurity() != null) {
                this.selectionService.setSelection(new SecuritySelection(this.model.getClient(), tx.getTransaction().getSecurity()));
            }
        });
        this.tableViewer.setInput(this.model.getTransactions());
        this.model.addUpdateListener(() -> this.tableViewer.setInput(this.model.getTransactions()));
        return container;
    }

    private void addColumns(ShowHideColumnHelper support) {
        Column column = new Column(Messages.ColumnDate, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return Values.DateTime.format((Object)((TransactionPair)element).getTransaction().getDateTime());
            }
        });
        ColumnViewerSorter.create(e -> ((TransactionPair)e).getTransaction().getDateTime()).attachTo(column, 128);
        support.addColumn(column);
        final Function<Object, Comparable<?>> tx2type = element -> ((TransactionPair)element).getTransaction() instanceof AccountTransaction ? ((AccountTransaction)((TransactionPair)element).getTransaction()).getType().toString() : ((PortfolioTransaction)((TransactionPair)element).getTransaction()).getType().toString();
        column = new Column(Messages.ColumnTransactionType, 16384, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)tx2type.apply(element);
            }

            public Color getForeground(Object element) {
                return TransactionsTab.this.colorFor(element);
            }
        });
        ColumnViewerSorter.create(tx2type).attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnSecurity, 0, 250);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Security security = ((TransactionPair)element).getTransaction().getSecurity();
                return security != null ? security.getName() : null;
            }

            public Image getImage(Object element) {
                Security security = ((TransactionPair)element).getTransaction().getSecurity();
                return LogoManager.instance().getDefaultColumnImage(security, TransactionsTab.this.model.getClient().getSettings());
            }
        });
        ColumnViewerSorter.create(e -> {
            Security s = ((TransactionPair)e).getTransaction().getSecurity();
            return s != null ? s.getName() : null;
        }).attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnShares, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new SharesLabelProvider(){

            @Override
            public Long getValue(Object element) {
                return ((TransactionPair)element).getTransaction().getShares();
            }

            @Override
            public Color getForeground(Object element) {
                return TransactionsTab.this.colorFor(element);
            }
        });
        ColumnViewerSorter.create(e -> Long.valueOf(((TransactionPair)e).getTransaction().getShares())).attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnGrossValue, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Money transactionGrossValue = ((TransactionPair)element).getTransaction() instanceof AccountTransaction ? ((AccountTransaction)((TransactionPair)element).getTransaction()).getGrossValue() : ((PortfolioTransaction)((TransactionPair)element).getTransaction()).getGrossValue();
                return Values.Money.format(transactionGrossValue, TransactionsTab.this.client.getBaseCurrency());
            }

            public Color getForeground(Object element) {
                return TransactionsTab.this.colorFor(element);
            }
        });
        ColumnViewerSorter.create(element -> ((TransactionPair)element).getTransaction() instanceof AccountTransaction ? ((AccountTransaction)((TransactionPair)element).getTransaction()).getGrossValue() : ((PortfolioTransaction)((TransactionPair)element).getTransaction()).getGrossValue()).attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnTaxes, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Money transactionTaxes = ((TransactionPair)element).getTransaction() instanceof AccountTransaction ? ((AccountTransaction)((TransactionPair)element).getTransaction()).getUnitSum(Transaction.Unit.Type.TAX) : ((PortfolioTransaction)((TransactionPair)element).getTransaction()).getUnitSum(Transaction.Unit.Type.TAX);
                return Values.Money.format(transactionTaxes, TransactionsTab.this.client.getBaseCurrency());
            }

            public Color getForeground(Object element) {
                return TransactionsTab.this.colorFor(element);
            }
        });
        ColumnViewerSorter.create(element -> ((TransactionPair)element).getTransaction() instanceof AccountTransaction ? ((AccountTransaction)((TransactionPair)element).getTransaction()).getUnitSum(Transaction.Unit.Type.TAX) : ((PortfolioTransaction)((TransactionPair)element).getTransaction()).getUnitSum(Transaction.Unit.Type.TAX)).attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnFees, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Money transactionFees = ((TransactionPair)element).getTransaction() instanceof AccountTransaction ? ((AccountTransaction)((TransactionPair)element).getTransaction()).getUnitSum(Transaction.Unit.Type.FEE) : ((PortfolioTransaction)((TransactionPair)element).getTransaction()).getUnitSum(Transaction.Unit.Type.FEE);
                return Values.Money.format(transactionFees, TransactionsTab.this.client.getBaseCurrency());
            }

            public Color getForeground(Object element) {
                return TransactionsTab.this.colorFor(element);
            }
        });
        ColumnViewerSorter.create(element -> ((TransactionPair)element).getTransaction() instanceof AccountTransaction ? ((AccountTransaction)((TransactionPair)element).getTransaction()).getUnitSum(Transaction.Unit.Type.FEE) : ((PortfolioTransaction)((TransactionPair)element).getTransaction()).getUnitSum(Transaction.Unit.Type.FEE)).attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnAmount, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return Values.Money.format(((TransactionPair)element).getTransaction().getMonetaryAmount(), TransactionsTab.this.client.getBaseCurrency());
            }

            public Color getForeground(Object element) {
                return TransactionsTab.this.colorFor(element);
            }
        });
        ColumnViewerSorter.create(e -> ((TransactionPair)e).getTransaction().getMonetaryAmount()).attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnOffsetAccount, 0, 120);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TransactionPair)element).getOwner().toString();
            }

            public Image getImage(Object element) {
                TransactionOwner owner = ((TransactionPair)element).getOwner();
                return LogoManager.instance().getDefaultColumnImage(owner, TransactionsTab.this.model.getClient().getSettings());
            }
        });
        ColumnViewerSorter.create(e -> ((TransactionPair)e).getOwner().toString()).attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnNote, 0, 200);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TransactionPair)element).getTransaction().getNote();
            }

            public Image getImage(Object element) {
                String note = ((TransactionPair)element).getTransaction().getNote();
                return note != null && note.length() > 0 ? Images.NOTE.image() : null;
            }

            public String getToolTipText(Object e) {
                return TextUtil.wordwrap((String)this.getText(e));
            }
        });
        ColumnViewerSorter.create(e -> ((TransactionPair)e).getTransaction().getNote()).attachTo(column);
        support.addColumn(column);
    }

    private Color colorFor(Object element) {
        TransactionPair tx = (TransactionPair)element;
        if (tx.getTransaction() instanceof AccountTransaction) {
            return ((AccountTransaction)tx.getTransaction()).getType().isCredit() ? Colors.theme().greenForeground() : Colors.theme().redForeground();
        }
        return ((PortfolioTransaction)tx.getTransaction()).getType().isPurchase() ? Colors.theme().greenForeground() : Colors.theme().redForeground();
    }
}

