/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.settings;

import java.time.LocalDate;
import java.util.ResourceBundle;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.AttributeType;
import name.abuchen.portfolio.model.Bookmark;
import name.abuchen.portfolio.model.LimitPrice;
import name.abuchen.portfolio.model.Security;

public enum AttributeFieldType {
    STRING(String.class, AttributeType.StringConverter.class),
    AMOUNT(Long.class, AttributeType.AmountConverter.class),
    AMOUNTPLAIN(Long.class, AttributeType.AmountPlainConverter.class),
    PERCENT(Double.class, AttributeType.PercentConverter.class),
    PERCENTPLAIN(Double.class, AttributeType.PercentPlainConverter.class),
    QUOTE(Long.class, AttributeType.QuoteConverter.class),
    SHARE(Long.class, AttributeType.ShareConverter.class),
    DATE(LocalDate.class, AttributeType.DateConverter.class),
    BOOLEAN(Boolean.class, AttributeType.BooleanConverter.class),
    LIMIT_PRICE(LimitPrice.class, AttributeType.LimitPriceConverter.class, Security.class),
    BOOKMARK(Bookmark.class, AttributeType.BookmarkConverter.class),
    IMAGE(String.class, AttributeType.ImageConverter.class);

    private static final ResourceBundle RESOURCES;
    private final Class<?> type;
    private final Class<? extends AttributeType.Converter> converterClass;
    private final Class<? extends Attributable> target;

    static {
        RESOURCES = ResourceBundle.getBundle("name.abuchen.portfolio.ui.views.settings.labels");
    }

    private AttributeFieldType(Class<?> type, Class<? extends AttributeType.Converter> converterClass) {
        this(type, converterClass, null);
    }

    private AttributeFieldType(Class<?> type, Class<? extends AttributeType.Converter> converterClass, Class<? extends Attributable> target) {
        this.type = type;
        this.converterClass = converterClass;
        this.target = target;
    }

    public Class<?> getFieldClass() {
        return this.type;
    }

    public Class<? extends AttributeType.Converter> getConverterClass() {
        return this.converterClass;
    }

    public boolean supports(Class<? extends Attributable> attributable) {
        if (this.target == null) {
            return true;
        }
        return this.target.isAssignableFrom(attributable);
    }

    private boolean isFieldType(AttributeType attribute) {
        return this.converterClass.isAssignableFrom(attribute.getConverter().getClass()) && this.type.isAssignableFrom(attribute.getType());
    }

    public String toString() {
        return RESOURCES.getString(String.valueOf(this.name()) + ".name");
    }

    public static AttributeFieldType of(AttributeType attribute) {
        AttributeFieldType[] attributeFieldTypeArray = AttributeFieldType.values();
        int n = attributeFieldTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeFieldType t = attributeFieldTypeArray[n2];
            if (t.isFieldType(attribute)) {
                return t;
            }
            ++n2;
        }
        return null;
    }
}

