/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.taxonomy;

import javax.inject.Inject;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.views.taxonomy.AbstractNodeTreeViewer;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyModel;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNode;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNodeRenderer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;

class DefinitionViewer
extends AbstractNodeTreeViewer {
    @Inject
    public DefinitionViewer(AbstractFinanceView view, TaxonomyModel model, TaxonomyNodeRenderer renderer) {
        super(view, model, renderer);
    }

    @Override
    protected String readExpansionState() {
        return this.getModel().getExpansionStateDefinition();
    }

    @Override
    protected void storeExpansionState(String expanded) {
        this.getModel().setExpansionStateDefinition(expanded);
    }

    @Override
    protected void addColumns(ShowHideColumnHelper support) {
        this.addDimensionColumn(support);
        Column column = new Column("color", Messages.ColumnColor, 16384, 60);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Color getBackground(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                if (node.isClassification()) {
                    return DefinitionViewer.this.getRenderer().getColorFor((TaxonomyNode)element);
                }
                return null;
            }
        });
        support.addColumn(column);
        this.addActualColumns(support);
        this.addAdditionalColumns(support);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        ITreeSelection selection = this.getNodeViewer().getStructuredSelection();
        if (selection.isEmpty() || selection.size() > 1) {
            return;
        }
        TaxonomyNode node = (TaxonomyNode)selection.getFirstElement();
        if (node == null || node.isUnassignedCategory()) {
            return;
        }
        if (!node.isClassification()) {
            return;
        }
        MenuManager color = new MenuManager(Messages.ColumnColor);
        color.add((IAction)new SimpleAction(Messages.MenuTaxonomyColorEdit, a -> this.doEditColor(node)));
        color.add((IAction)new SimpleAction(Messages.MenuTaxonomyColorRandomPalette, a -> this.doAutoAssignColors(node)));
        color.add((IAction)new SimpleAction(Messages.MenuTaxonomyColorCascadeToChildren, a -> this.doCascadeColorsDown(node)));
        manager.appendToGroup("defaultActions", (IContributionItem)color);
    }

    private void doEditColor(TaxonomyNode node) {
        RGB oldColor = Colors.toRGB(node.getClassification().getColor());
        ColorDialog colorDialog = new ColorDialog(this.getNodeViewer().getControl().getShell());
        colorDialog.setRGB(oldColor);
        RGB newColor = colorDialog.open();
        if (newColor != null && !newColor.equals((Object)oldColor)) {
            String hex = Colors.toHex(newColor);
            node.getClassification().setColor(hex);
            if (node.getParent().isRoot()) {
                node.getParent().getClassification().setColor(hex);
            }
            this.getModel().fireTaxonomyModelChange(node);
            this.getModel().markDirty();
        }
    }

    private void doAutoAssignColors(TaxonomyNode node) {
        node.getClassification().assignRandomColors();
        this.getModel().fireTaxonomyModelChange(null);
        this.getNodeViewer().getTree().redraw();
        this.getModel().markDirty();
    }

    protected void doCascadeColorsDown(TaxonomyNode node) {
        node.getClassification().cascadeColorDown();
        this.getModel().fireTaxonomyModelChange(null);
        this.getNodeViewer().getTree().redraw();
        this.getModel().markDirty();
    }
}

