/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.taxonomy;

import java.util.ArrayList;
import java.util.Objects;
import java.util.StringJoiner;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.EmbeddedBrowser;
import name.abuchen.portfolio.ui.views.taxonomy.AbstractChartPage;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyModel;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNode;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNodeRenderer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.json.simple.JSONObject;

class DonutViewer
extends AbstractChartPage {
    private EmbeddedBrowser browser;

    @Inject
    public DonutViewer(TaxonomyModel model, TaxonomyNodeRenderer renderer) {
        super(model, renderer);
    }

    @Override
    public Control createControl(Composite container) {
        this.browser = this.make(EmbeddedBrowser.class);
        this.browser.setHtmlpage("/META-INF/html/pie.html");
        return this.browser.createControl(container, b -> {
            LoadDataFunction loadDataFunction = new LoadDataFunction((Browser)b, "loadData");
        });
    }

    @Override
    public void beforePage() {
    }

    @Override
    public void afterPage() {
    }

    @Override
    public void nodeChange(TaxonomyNode node) {
        this.browser.refresh();
    }

    @Override
    public void onConfigChanged() {
        this.browser.refresh();
    }

    private final class LoadDataFunction
    extends BrowserFunction {
        private static final String CAPTION_CLASSIFICATION = "%s  (%s)";
        private static final String CAPTION_CLASSIFIED = "<b>%s  %s  (%s)</b><br>%s";
        private static final String CAPTION_CLASSIFIED2 = "<b>%s  %s  (%s)</b><br>%s<br>%s";
        private static final String ENTRY = "{\"label\":\"%s\",\"value\":%s,\"color\":\"%s\",\"caption\":\"%s\",\"valueLabel\":\"%s\"}";

        private LoadDataFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            try {
                StringJoiner joiner = new StringJoiner(",", "[", "]");
                long total = DonutViewer.this.getModel().getChartRenderingRootNode().getActual().getAmount();
                TaxonomyNode node = DonutViewer.this.getModel().getClassificationRootNode();
                this.addChildren(joiner, node, total);
                if (!DonutViewer.this.getModel().isUnassignedCategoryInChartsExcluded()) {
                    TaxonomyNode unassigned = DonutViewer.this.getModel().getUnassignedNode();
                    this.addChildren(joiner, unassigned, total);
                }
                return joiner.toString();
            }
            catch (Throwable e) {
                PortfolioPlugin.log(e);
                return "{}";
            }
        }

        private void addChildren(StringJoiner joiner, TaxonomyNode node, long total) {
            for (TaxonomyNode child : node.getChildren()) {
                if (child.getActual().isZero()) continue;
                if (child.isAssignment()) {
                    this.addAssignment(joiner, child, node.getColor(), total);
                    continue;
                }
                if (!child.isClassification()) continue;
                ArrayList grandchildren = new ArrayList();
                child.accept(n -> {
                    if (n.isAssignment()) {
                        grandchildren.add(n);
                    }
                });
                grandchildren.stream().filter(n -> !n.getActual().isZero()).sorted((l, r) -> Long.compare(r.getActual().getAmount(), l.getActual().getAmount())).forEach(n -> this.addAssignment(joiner, (TaxonomyNode)n, child.getColor(), total));
            }
        }

        private void addAssignment(StringJoiner joiner, TaxonomyNode node, String color, long total) {
            String name = JSONObject.escape((String)node.getName());
            String percentage = Values.Percent2.format((Object)((double)node.getActual().getAmount() / (double)total));
            TaxonomyNode taxn = this.getClassificationNode(node);
            TaxonomyNode taxRoot = this.getRootClassificationNode(node);
            String captionClassificationRoot = this.formatClassification(taxRoot, total);
            if (captionClassificationRoot == null) {
                captionClassificationRoot = Messages.LabelWithoutClassification;
            }
            String captionClassification = null;
            if (!Objects.equals(taxRoot, taxn)) {
                captionClassification = this.formatClassification(taxn, total);
            }
            String caption = captionClassification != null ? String.format(CAPTION_CLASSIFIED2, name, Values.Money.format(node.getActual()), percentage, captionClassification, captionClassificationRoot) : String.format(CAPTION_CLASSIFIED, name, Values.Money.format(node.getActual()), percentage, captionClassificationRoot);
            joiner.add(String.format(ENTRY, name, node.getActual().getAmount(), color, caption, percentage));
        }

        private String formatClassification(TaxonomyNode taxn, double total) {
            Classification cl;
            if (taxn != null && taxn.getParent() != null && !taxn.getParent().isRoot() && (cl = taxn.getClassification()) != null) {
                return String.format(CAPTION_CLASSIFICATION, cl.getPathName(false), Values.Percent2.format((Object)((double)taxn.getActual().getAmount() / total)));
            }
            return null;
        }

        private TaxonomyNode getClassificationNode(TaxonomyNode node) {
            Classification cl = node.getClassification();
            if (cl != null) {
                return node;
            }
            TaxonomyNode parent = node.getParent();
            if (parent != null) {
                return this.getClassificationNode(parent);
            }
            return null;
        }

        private TaxonomyNode getRootClassificationNode(TaxonomyNode node) {
            TaxonomyNode parent = node.getParent();
            boolean parentIsRoot = false;
            if (parent != null) {
                if (!parent.isRoot()) {
                    TaxonomyNode tn = this.getRootClassificationNode(parent);
                    if (tn != null) {
                        return tn;
                    }
                } else {
                    parentIsRoot = true;
                }
            }
            if (!parentIsRoot && node.getClassification() != null) {
                return node;
            }
            return null;
        }
    }
}

