/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.taxonomy;

import com.ibm.icu.text.MessageFormat;
import java.time.LocalDate;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.AssetPosition;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.swt.ActiveShell;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.SharesLabelProvider;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.util.viewers.ValueEditingSupport;
import name.abuchen.portfolio.ui.views.taxonomy.AbstractNodeTreeViewer;
import name.abuchen.portfolio.ui.views.taxonomy.DeltaPercentageIndicatorLabelProvider;
import name.abuchen.portfolio.ui.views.taxonomy.EditRebalancingColoringRuleDialog;
import name.abuchen.portfolio.ui.views.taxonomy.RebalancingColoringRule;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyModel;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNode;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNodeRenderer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ReBalancingViewer
extends AbstractNodeTreeViewer {
    @Inject
    public ReBalancingViewer(AbstractFinanceView view, TaxonomyModel model, TaxonomyNodeRenderer renderer) {
        super(view, model, renderer);
    }

    @Override
    protected String readExpansionState() {
        return this.getModel().getExpansionStateRebalancing();
    }

    @Override
    protected void storeExpansionState(String expanded) {
        this.getModel().setExpansionStateRebalancing(expanded);
    }

    @Override
    protected void addColumns(ShowHideColumnHelper support) {
        this.addDimensionColumn(support);
        this.addDesiredAllocationColumn(support);
        Column column = new Column("targetvalue", Messages.ColumnTargetValue, 131072, 100);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                return node.isClassification() ? Values.Money.format(node.getTarget(), ReBalancingViewer.this.getModel().getCurrencyCode()) : null;
            }
        });
        support.addColumn(column);
        this.addActualColumns(support);
        column = new Column("delta%", Messages.ColumnDeltaPercent, 131072, 60);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                if (node.getTarget() == null) {
                    return null;
                }
                return Values.Percent.format((Object)((double)node.getActual().getAmount() / (double)node.getTarget().getAmount() - 1.0));
            }

            public Color getForeground(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                if (node.getTarget() == null) {
                    return null;
                }
                return node.getActual().isGreaterOrEqualThan(node.getTarget()) ? Colors.theme().greenForeground() : Colors.theme().redForeground();
            }
        });
        support.addColumn(column);
        column = new Column("delta%indicator", Messages.ColumnDeltaPercentIndicator, 16384, 60);
        column.setLabelProvider((CellLabelProvider)new DeltaPercentageIndicatorLabelProvider(this.getNodeViewer().getControl(), this.getModel().getClient(), element -> (TaxonomyNode)element));
        support.addColumn(column);
        column = new Column("delta%relative", Messages.ColumnDeltaPercentRelative, 131072, 100);
        column.setDescription(Messages.ColumnDeltaPercentRelative_Description);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                if (node.getTarget() == null) {
                    return null;
                }
                return Values.Percent.format((Object)this.calculateRelativeDelta(node));
            }

            public Color getForeground(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                if (node.getTarget() == null) {
                    return null;
                }
                return this.calculateRelativeDelta(node) >= 0.0 ? Colors.theme().greenForeground() : Colors.theme().redForeground();
            }

            private double calculateRelativeDelta(TaxonomyNode node) {
                long actual = node.getActual().getAmount();
                long base = node.getParent() == null ? node.getActual().getAmount() : node.getParent().getActual().getAmount();
                double weightPercent = (double)node.getWeight() / (double)Classification.ONE_HUNDRED_PERCENT;
                double actualPercent = base != 0L ? (double)actual / (double)base : weightPercent;
                return actualPercent - weightPercent;
            }
        });
        column.setVisible(false);
        support.addColumn(column);
        column = new Column("delta", Messages.ColumnDeltaValue, 131072, 100);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                if (node.getTarget() == null) {
                    return null;
                }
                return Values.Money.format(node.getActual().subtract(node.getTarget()), ReBalancingViewer.this.getModel().getCurrencyCode());
            }

            public Color getForeground(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                if (node.getTarget() == null) {
                    return null;
                }
                return node.getActual().isGreaterOrEqualThan(node.getTarget()) ? Colors.theme().greenForeground() : Colors.theme().redForeground();
            }
        });
        support.addColumn(column);
        column = new Column("quote", Messages.ColumnQuote, 131072, 60);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                Security security = node.getBackingSecurity();
                if (security == null || security.getCurrencyCode() == null) {
                    return null;
                }
                SecurityPrice price = security.getSecurityPrice(LocalDate.now());
                return Values.Quote.format(security.getCurrencyCode(), price.getValue(), ReBalancingViewer.this.getModel().getCurrencyCode());
            }
        });
        support.addColumn(column);
        column = new Column("shares", Messages.ColumnSharesOwned, 131072, 60);
        column.setLabelProvider((CellLabelProvider)new SharesLabelProvider(){

            @Override
            public Long getValue(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                Security security = node.getBackingSecurity();
                if (security == null || security.getCurrencyCode() == null) {
                    return null;
                }
                AssetPosition position = (AssetPosition)ReBalancingViewer.this.getModel().getClientSnapshot().getPositionsByVehicle().get(security);
                if (position == null) {
                    return null;
                }
                return Math.round((double)(position.getPosition().getShares() * (long)node.getWeight()) / (double)Classification.ONE_HUNDRED_PERCENT);
            }
        });
        column.setVisible(false);
        support.addColumn(column);
        column = new Column("deltashares", Messages.ColumnDeltaShares, 131072, 100);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                if (node.getParent() != null && node.getParent().isUnassignedCategory()) {
                    return null;
                }
                Security security = node.getBackingSecurity();
                if (security == null || security.getCurrencyCode() == null) {
                    return null;
                }
                String priceCurrency = security.getCurrencyCode();
                long price = security.getSecurityPrice(LocalDate.now()).getValue();
                long weightedPrice = Math.round((double)((long)node.getWeight() * price) / (double)Classification.ONE_HUNDRED_PERCENT);
                if (weightedPrice == 0L) {
                    return Values.Share.format((Object)0L);
                }
                String deltaCurrency = node.getActual().getCurrencyCode();
                long delta = node.getParent().getTarget().getAmount() - node.getParent().getActual().getAmount();
                if (!deltaCurrency.equals(priceCurrency)) {
                    delta = ReBalancingViewer.this.getModel().getCurrencyConverter().with(priceCurrency).convert(LocalDate.now(), Money.of((String)deltaCurrency, (long)delta)).getAmount();
                }
                long shares = Math.round((double)delta * Values.Share.divider() * Values.Quote.dividerToMoney() / (double)weightedPrice);
                return Values.Share.format((Object)shares);
            }
        });
        support.addColumn(column);
        this.addAdditionalColumns(support);
    }

    private void addDesiredAllocationColumn(ShowHideColumnHelper support) {
        Column column = new Column("desiredAllocation", Messages.ColumnDesiredAllocation, 131072, 70);
        column.setDescription(Messages.ColumnDesiredAllocation_Description);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                return node.isClassification() ? Values.Weight.format((Object)node.getWeight()) : (node.isUnassignedCategory() ? Messages.LabelNotAvailable : null);
            }

            public Color getForeground(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                return node.isClassification() && ReBalancingViewer.this.getModel().hasWeightError(node) ? Display.getDefault().getSystemColor(2) : null;
            }

            public Color getBackground(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                return node.isClassification() && ReBalancingViewer.this.getModel().hasWeightError(node) ? Colors.theme().warningBackground() : null;
            }

            public Image getImage(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                return node.isClassification() && ReBalancingViewer.this.getModel().hasWeightError(node) ? Images.QUICKFIX.image() : null;
            }
        });
        new ValueEditingSupport(TaxonomyNode.class, "weight", Values.Weight){

            @Override
            public boolean canEdit(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                if (node.isAssignment() || node.isUnassignedCategory()) {
                    return false;
                }
                return super.canEdit(element);
            }
        }.addListener(this::onWeightModified).attachTo(column);
        support.addColumn(column);
    }

    @Override
    public void configMenuAboutToShow(IMenuManager manager) {
        super.configMenuAboutToShow(manager);
        manager.add((IContributionItem)new Separator());
        RebalancingColoringRule rule = new RebalancingColoringRule(this.getModel().getClient());
        manager.add((IAction)new SimpleAction(MessageFormat.format((String)Messages.MenuConfigureRebalancingIndicator, (Object[])new Object[]{rule.getAbsoluteThreshold(), rule.getRelativeThreshold()}), a -> {
            int n = new EditRebalancingColoringRuleDialog(ActiveShell.get(), rule).open();
        }));
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        ITreeSelection selection = this.getNodeViewer().getStructuredSelection();
        if (selection.isEmpty() || selection.size() > 1) {
            return;
        }
        TaxonomyNode node = (TaxonomyNode)selection.getFirstElement();
        if (node == null || node.isUnassignedCategory()) {
            return;
        }
        if (node.isClassification() && this.getModel().hasWeightError(node)) {
            manager.appendToGroup("customActions", (IAction)new SimpleAction(Messages.MenuTaxonomyWeightFix, a -> this.doFixClassificationWeights(node)));
        }
    }

    private void doFixClassificationWeights(TaxonomyNode node) {
        Classification classification = node.getClassification();
        if (node.isUnassignedCategory()) {
            classification.setWeight(0);
        } else if (node.isRoot() || node.getParent().isRoot()) {
            classification.setWeight(Classification.ONE_HUNDRED_PERCENT);
        } else {
            classification.setWeight(0);
            int weight = Math.max(0, Classification.ONE_HUNDRED_PERCENT - classification.getParent().getChildrenWeight());
            classification.setWeight(weight);
        }
        this.onTaxnomyNodeEdited(node);
    }
}

