/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.client;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class ImportIndizesPage
extends AbstractWizardPage {
    private Client client;
    private List<ProposedSecurities> proposals = new ArrayList<ProposedSecurities>();
    private Combo comboDropDown;

    public ImportIndizesPage(Client client) {
        super(ImportIndizesPage.class.getSimpleName());
        String[] indAr;
        this.client = client;
        this.setTitle(Messages.NewFileWizardSecurityTitle);
        this.setDescription(Messages.NewFileWizardSecurityDescription);
        ResourceBundle bundle = ResourceBundle.getBundle("name.abuchen.portfolio.ui.wizards.client.index");
        String indices = bundle.getString("proposals");
        String[] stringArray = indAr = indices.split(",");
        int n = indAr.length;
        int n2 = 0;
        while (n2 < n) {
            String[] values;
            String index = stringArray[n2];
            String label = bundle.getString(String.valueOf(index) + ".name");
            ProposedSecurities proposal = new ProposedSecurities(label);
            this.proposals.add(proposal);
            String[] stringArray2 = values = bundle.getString(index).split(",");
            int n3 = values.length;
            int n4 = 0;
            while (n4 < n3) {
                String ticker = stringArray2[n4];
                String key = String.valueOf(index) + '.' + ticker;
                Security security = new Security();
                security.setTickerSymbol(ticker);
                security.setName(bundle.getString(String.valueOf(key) + ".name"));
                security.setIsin(this.safeGetString(bundle, String.valueOf(key) + ".isin"));
                security.setFeed("YAHOO");
                security.setCurrencyCode("XXX".equals(this.safeGetString(bundle, String.valueOf(key) + ".currency")) ? null : "EUR");
                proposal.securities.add(security);
                ++n4;
            }
            ++n2;
        }
    }

    private String safeGetString(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException ignore) {
            return null;
        }
    }

    @Override
    public void beforePage() {
        this.comboDropDown.notifyListeners(13, new Event());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayoutFactory.fillDefaults().applyTo(container);
        this.comboDropDown = new Combo(container, 2060);
        GridDataFactory.fillDefaults().align(1, 4).applyTo((Control)this.comboDropDown);
        final ComboViewer comboViewer = new ComboViewer(this.comboDropDown);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setInput(this.proposals);
        Composite tableContainer = new Composite(container, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)tableContainer);
        TableColumnLayout layout = new TableColumnLayout();
        tableContainer.setLayout((Layout)layout);
        final TableViewer tViewer = new TableViewer(tableContainer);
        comboViewer.addSelectionChangedListener(event -> {
            ProposedSecurities element = (ProposedSecurities)((IStructuredSelection)event.getSelectionProvider().getSelection()).getFirstElement();
            if (element != null) {
                tViewer.setInput(element.securities);
            }
        });
        Table table = tViewer.getTable();
        table.setHeaderVisible(true);
        tViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn aCol = new TableViewerColumn(tViewer, 0);
        layout.setColumnData((Widget)aCol.getColumn(), (ColumnLayoutData)new ColumnWeightData(90));
        aCol.getColumn().setText(Messages.ColumnSecurity);
        aCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Security)element).getName();
            }

            public Image getImage(Object element) {
                return Images.SECURITY.image();
            }
        });
        aCol = new TableViewerColumn(tViewer, 0);
        layout.setColumnData((Widget)aCol.getColumn(), (ColumnLayoutData)new ColumnWeightData(10));
        aCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Image getImage(Object element) {
                return ImportIndizesPage.this.client.getSecurities().contains(element) ? Images.CHECK.image() : null;
            }
        });
        tViewer.addDoubleClickListener(event -> {
            Security security = (Security)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (security != null && !this.client.getSecurities().contains(security)) {
                this.client.addSecurity(security);
                tViewer.refresh((Object)security);
            }
        });
        Button button = new Button(container, 8);
        button.setText(Messages.NewFileWizardAddAll);
        GridDataFactory.fillDefaults().align(1, 4).applyTo((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProposedSecurities proposal = (ProposedSecurities)((IStructuredSelection)comboViewer.getSelection()).getFirstElement();
                for (Security security : proposal.securities) {
                    if (ImportIndizesPage.this.client.getSecurities().contains(security)) continue;
                    ImportIndizesPage.this.client.addSecurity(security);
                }
                tViewer.refresh();
            }
        });
        this.comboDropDown.select(0);
        container.pack();
        this.setPageComplete(true);
    }

    private static final class ProposedSecurities {
        private String label;
        private List<Security> securities = new ArrayList<Security>();

        public ProposedSecurities(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

