/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.client;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

class MarkSecurityAsIndexPage
extends AbstractWizardPage {
    private Client client;
    private CheckboxTableViewer tableViewer;

    public MarkSecurityAsIndexPage(Client client) {
        super("mark-security-as-index");
        this.client = client;
        this.setTitle(Messages.MarkSecurityPageTitle);
        this.setDescription(Messages.MarkSecurityPageDescription);
    }

    @Override
    public void beforePage() {
        if (this.tableViewer.getTable().getItemCount() == 0) {
            List candidates = this.client.getSecurities().stream().filter(s -> !s.hasTransactions(this.client)).sorted((Comparator<Security>)new Security.ByName()).collect(Collectors.toList());
            this.tableViewer.setInput(candidates);
            this.tableViewer.setCheckedElements(candidates.stream().filter(s -> s.getTickerSymbol() != null && s.getTickerSymbol().startsWith("^")).toArray());
        }
    }

    public Stream<Security> getSelectedSecurities() {
        return Arrays.stream(this.tableViewer.getCheckedElements()).map(o -> (Security)o);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        Composite tableArea = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableArea);
        TableColumnLayout layout = new TableColumnLayout();
        tableArea.setLayout((Layout)layout);
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)tableArea, (int)2082);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        TableViewerColumn column = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return Images.SECURITY.image();
            }

            public String getText(Object element) {
                return ((Security)element).getName();
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        container.pack();
        this.setPageComplete(true);
    }
}

