/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.security;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.model.Exchange;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.online.Factory;
import name.abuchen.portfolio.online.QuoteFeed;
import name.abuchen.portfolio.online.QuoteFeedData;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.BindingHelper;
import name.abuchen.portfolio.ui.util.SWTHelper;
import name.abuchen.portfolio.ui.wizards.security.AbstractQuoteProviderPage;
import name.abuchen.portfolio.ui.wizards.security.EditSecurityModel;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LatestQuoteProviderPage
extends AbstractQuoteProviderPage {
    private static final String EMPTY_LABEL = "";
    private static final QuoteFeed EMTPY_QUOTE_FEED = new DummyQuoteFeed();
    private Label valueLatestPrices;
    private Label valueLatestTrade;
    private Label valueDaysHigh;
    private Label valueDaysLow;
    private Label valueVolume;

    public LatestQuoteProviderPage(EditSecurityModel model, BindingHelper bindings) {
        super(model, bindings);
        this.setTitle(Messages.EditWizardLatestQuoteFeedTitle);
        bindings.getBindingContext().addValidationStatusProvider((ValidationStatusProvider)new MultiValidator(model){
            IObservableValue<?> observable;
            {
                this.observable = BeanProperties.value((String)"statusLatestQuotesProvider").observe((Object)editSecurityModel);
            }

            protected IStatus validate() {
                return this.observable.getValue() == null ? ValidationStatus.ok() : ValidationStatus.error((String)this.observable.getValue().toString());
            }
        });
    }

    @Override
    protected String getFeed() {
        return this.getModel().getLatestFeed();
    }

    @Override
    protected void setFeed(String feed) {
        this.getModel().setLatestFeed(feed);
    }

    @Override
    protected String getFeedURL() {
        return this.getModel().getLatestFeedURL();
    }

    @Override
    protected void setFeedURL(String feedURL) {
        this.getModel().setLatestFeedURL(feedURL);
    }

    @Override
    protected void setStatus(String status) {
        this.getModel().setStatusLatestQuotesProvider(status);
    }

    @Override
    protected String getJSONDatePropertyName() {
        return "GENERIC-JSON-DATE-LATEST";
    }

    @Override
    protected String getJSONClosePropertyName() {
        return "GENERIC-JSON-CLOSE-LATEST";
    }

    @Override
    protected List<QuoteFeed> getAvailableFeeds() {
        ArrayList<QuoteFeed> feeds = new ArrayList<QuoteFeed>();
        feeds.add(EMTPY_QUOTE_FEED);
        for (QuoteFeed feed : Factory.getQuoteFeedProvider()) {
            if (feed.getId().equals("YAHOO-ADJUSTEDCLOSE") || this.getModel().getSecurity().getOnlineId() == null && feed.getId().equals("PORTFOLIO-REPORT")) continue;
            feeds.add(feed);
        }
        return feeds;
    }

    @Override
    protected QuoteFeed getQuoteFeedProvider(String feedId) {
        if (feedId == null) {
            return EMTPY_QUOTE_FEED;
        }
        return Factory.getQuoteFeedProvider((String)feedId);
    }

    @Override
    protected void createSampleArea(Composite container) {
        Composite composite = new Composite(container, 0);
        Label labelLatestPrice = new Label(composite, 0);
        labelLatestPrice.setText(Messages.ColumnLatestPrice);
        this.valueLatestPrices = new Label(composite, 131072);
        Label labelLatestTrade = new Label(composite, 0);
        labelLatestTrade.setText(Messages.ColumnLatestTrade);
        this.valueLatestTrade = new Label(composite, 131072);
        Label labelDaysHigh = new Label(composite, 0);
        labelDaysHigh.setText(Messages.ColumnDaysHigh);
        this.valueDaysHigh = new Label(composite, 131072);
        Label labelDaysLow = new Label(composite, 0);
        labelDaysLow.setText(Messages.ColumnDaysLow);
        this.valueDaysLow = new Label(composite, 131072);
        Label labelVolume = new Label(composite, 0);
        labelVolume.setText(Messages.ColumnVolume);
        this.valueVolume = new Label(composite, 131072);
        FormLayout layout = new FormLayout();
        layout.marginLeft = 5;
        layout.marginRight = 5;
        composite.setLayout((Layout)layout);
        Control biggest = SWTHelper.widestWidget(new Control[]{labelLatestPrice, labelLatestTrade, labelDaysHigh, labelDaysLow, labelVolume});
        int width = SWTHelper.dateWidth((Drawable)composite);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.valueLatestPrices, 0, 0x1000000);
        labelLatestPrice.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(biggest, 5);
        data.width = width;
        this.valueLatestPrices.setLayoutData((Object)data);
        SWTHelper.placeBelow((Control)this.valueLatestPrices, labelLatestTrade, (Control)this.valueLatestTrade);
        SWTHelper.placeBelow((Control)this.valueLatestTrade, labelDaysHigh, (Control)this.valueDaysHigh);
        SWTHelper.placeBelow((Control)this.valueDaysHigh, labelDaysLow, (Control)this.valueDaysLow);
        SWTHelper.placeBelow((Control)this.valueDaysLow, labelVolume, (Control)this.valueVolume);
    }

    @Override
    protected void reinitCaches() {
    }

    @Override
    protected void clearSampleQuotes() {
        this.valueLatestPrices.setText(EMPTY_LABEL);
        this.valueLatestTrade.setText(EMPTY_LABEL);
        this.valueDaysHigh.setText(EMPTY_LABEL);
        this.valueDaysLow.setText(EMPTY_LABEL);
        this.valueVolume.setText(EMPTY_LABEL);
    }

    @Override
    protected void showSampleQuotes(QuoteFeed feed, Exchange exchange) {
        new LoadLatestQuote(feed, exchange).schedule();
    }

    private static class DummyQuoteFeed
    implements QuoteFeed {
        private DummyQuoteFeed() {
        }

        public String getId() {
            return null;
        }

        public String getName() {
            return Messages.EditWizardOptionSameAsHistoricalQuoteFeed;
        }

        public QuoteFeedData getHistoricalQuotes(Security security, boolean collectRawResponse) {
            return new QuoteFeedData();
        }
    }

    private class LoadLatestQuote
    extends Job {
        private QuoteFeed feed;
        private Exchange exchange;

        public LoadLatestQuote(QuoteFeed feed, Exchange exchange) {
            super(MessageFormat.format(Messages.JobMsgSamplingHistoricalQuotes, exchange != null ? exchange.getName() : LatestQuoteProviderPage.EMPTY_LABEL));
            this.feed = feed;
            this.exchange = exchange;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                Security s = LatestQuoteProviderPage.this.buildTemporarySecurity();
                if (this.exchange != null) {
                    s.setTickerSymbol(this.exchange.getId());
                }
                s.setFeed(this.feed.getId());
                this.feed.getLatestQuote(s).ifPresent(arg_0 -> ((Security)s).setLatest(arg_0));
                Display.getDefault().asyncExec(() -> {
                    if (LatestQuoteProviderPage.this.valueLatestPrices == null || LatestQuoteProviderPage.this.valueLatestPrices.isDisposed()) {
                        return;
                    }
                    if (s.getLatest() != null) {
                        LatestSecurityPrice p = s.getLatest();
                        LatestQuoteProviderPage.this.valueLatestPrices.setText(Values.Quote.format(Long.valueOf(p.getValue())));
                        LatestQuoteProviderPage.this.valueLatestTrade.setText(Values.Date.format((Object)p.getDate()));
                        long daysHigh = p.getHigh();
                        LatestQuoteProviderPage.this.valueDaysHigh.setText(daysHigh == -1L ? Messages.LabelNotAvailable : Values.Quote.format(Long.valueOf(daysHigh)));
                        long daysLow = p.getLow();
                        LatestQuoteProviderPage.this.valueDaysLow.setText(daysLow == -1L ? Messages.LabelNotAvailable : Values.Quote.format(Long.valueOf(daysLow)));
                        long volume = p.getVolume();
                        LatestQuoteProviderPage.this.valueVolume.setText(volume == -1L ? Messages.LabelNotAvailable : String.format("%,d", volume));
                    } else {
                        LatestQuoteProviderPage.this.clearSampleQuotes();
                    }
                });
            }
            catch (Exception e) {
                Display.getDefault().asyncExec(() -> LatestQuoteProviderPage.this.clearSampleQuotes());
                PortfolioPlugin.log(e);
            }
            return Status.OK_STATUS;
        }
    }
}

