/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.splits;

import java.time.LocalDate;
import java.util.List;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityEvent;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.ui.util.BindingHelper;

public class StockSplitModel
extends BindingHelper.Model {
    private Security security;
    private LocalDate exDate = LocalDate.now();
    private int newShares = 1;
    private int oldShares = 1;
    private boolean changeTransactions = true;
    private boolean changeHistoricalQuotes = true;

    public StockSplitModel(Client client, Security security) {
        super(client);
        this.security = security;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        this.security = security;
        this.firePropertyChange("security", this.security, this.security);
    }

    public LocalDate getExDate() {
        return this.exDate;
    }

    public void setExDate(LocalDate exDate) {
        this.exDate = exDate;
        this.firePropertyChange("exDate", this.exDate, this.exDate);
    }

    public int getNewShares() {
        return this.newShares;
    }

    public void setNewShares(int newShares) {
        this.newShares = newShares;
        this.firePropertyChange("newShares", this.newShares, this.newShares);
    }

    public int getOldShares() {
        return this.oldShares;
    }

    public void setOldShares(int oldShares) {
        this.oldShares = oldShares;
        this.firePropertyChange("oldShares", this.oldShares, this.oldShares);
    }

    public boolean isChangeTransactions() {
        return this.changeTransactions;
    }

    public void setChangeTransactions(boolean changeTransactions) {
        this.changeTransactions = changeTransactions;
        this.firePropertyChange("changeTransactions", this.changeTransactions, this.changeTransactions);
    }

    public boolean isChangeHistoricalQuotes() {
        return this.changeHistoricalQuotes;
    }

    public void setChangeHistoricalQuotes(boolean changeHistoricalQuotes) {
        this.changeHistoricalQuotes = changeHistoricalQuotes;
        this.firePropertyChange("changeHistoricalQuotes", this.changeHistoricalQuotes, this.changeHistoricalQuotes);
    }

    @Override
    public void applyChanges() {
        SecurityEvent event = new SecurityEvent(this.exDate, SecurityEvent.Type.STOCK_SPLIT, String.valueOf(this.newShares) + ":" + this.oldShares);
        this.security.addEvent(event);
        if (this.isChangeTransactions()) {
            List transactions = this.security.getTransactions(this.getClient());
            for (TransactionPair pair : transactions) {
                Transaction t = pair.getTransaction();
                if (!t.getDateTime().toLocalDate().isBefore(this.exDate)) continue;
                t.setShares(t.getShares() * (long)this.newShares / (long)this.oldShares);
            }
        }
        if (this.isChangeHistoricalQuotes()) {
            List quotes = this.security.getPrices();
            for (SecurityPrice p : quotes) {
                if (!p.getDate().isBefore(this.exDate)) continue;
                p.setValue(p.getValue() * (long)this.oldShares / (long)this.newShares);
            }
        }
    }
}

