/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.checks.impl;

import java.util.Collections;
import java.util.List;
import name.abuchen.portfolio.checks.Check;
import name.abuchen.portfolio.checks.Issue;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;

public class FixTaxRefundsCheck
implements Check {
    @Override
    public List<Issue> execute(Client client) {
        if (client.getFileVersionAfterRead() > 29) {
            return Collections.emptyList();
        }
        for (Account account : client.getAccounts()) {
            for (AccountTransaction t : account.getTransactions()) {
                if (t.getType() != AccountTransaction.Type.TAX_REFUND || t.getSecurity() == null) continue;
                Security security = t.getSecurity();
                if (client.getSecurities().contains(security)) continue;
                t.setSecurity(null);
            }
        }
        return Collections.emptyList();
    }
}

