/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.checks.impl;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.checks.Check;
import name.abuchen.portfolio.checks.Issue;
import name.abuchen.portfolio.checks.QuickFix;
import name.abuchen.portfolio.checks.impl.DeleteTransactionFix;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;

public class PortfolioTransactionWithoutSecurityCheck
implements Check {
    @Override
    public List<Issue> execute(Client client) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (Portfolio portfolio : client.getPortfolios()) {
            portfolio.getTransactions().stream().filter(t -> t.getSecurity() == null).forEach(t -> {
                boolean bl = issues.add(new MissingSecurityIssue(client, portfolio, (PortfolioTransaction)t));
            });
        }
        return issues;
    }

    public static class MissingSecurityIssue
    implements Issue {
        private Client client;
        private Portfolio portfolio;
        private PortfolioTransaction transaction;

        public MissingSecurityIssue(Client client, Portfolio portfolio, PortfolioTransaction transaction) {
            this.client = client;
            this.portfolio = portfolio;
            this.transaction = transaction;
        }

        @Override
        public LocalDate getDate() {
            return this.transaction.getDateTime().toLocalDate();
        }

        @Override
        public Object getEntity() {
            return this.portfolio;
        }

        @Override
        public Long getAmount() {
            return this.transaction.getAmount();
        }

        @Override
        public String getLabel() {
            return Messages.IssuePortfolioTransactionWithoutSecurity;
        }

        @Override
        public List<QuickFix> getAvailableFixes() {
            ArrayList<QuickFix> fixes = new ArrayList<QuickFix>();
            fixes.add(new DeleteTransactionFix<PortfolioTransaction>(this.client, this.portfolio, this.transaction));
            for (Security security : this.client.getSecurities()) {
                fixes.add(new SetSecurityFix(security, this.transaction));
            }
            return fixes;
        }
    }

    public static class SetSecurityFix
    implements QuickFix {
        private Security security;
        private PortfolioTransaction transaction;

        public SetSecurityFix(Security security, PortfolioTransaction transaction) {
            this.security = security;
            this.transaction = transaction;
        }

        @Override
        public String getLabel() {
            return MessageFormat.format(Messages.FixSetSecurity, this.security.getName());
        }

        @Override
        public String getDoneLabel() {
            return MessageFormat.format(Messages.FixSetSecurityDone, this.security.getName());
        }

        @Override
        public void execute() {
            this.transaction.setSecurity(this.security);
            if (this.transaction.getCrossEntry() != null) {
                this.transaction.getCrossEntry().updateFrom(this.transaction);
            }
        }
    }
}

