/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.actions;

import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.ImportAction;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.AccountTransferEntry;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.InvestmentPlan;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.PortfolioTransferEntry;
import name.abuchen.portfolio.model.Transaction;

public class DetectDuplicatesAction
implements ImportAction {
    private final Client client;

    public DetectDuplicatesAction(Client client) {
        this.client = client;
    }

    @Override
    public ImportAction.Status process(AccountTransaction transaction, Account account) {
        return this.check(transaction, account.getTransactions());
    }

    @Override
    public ImportAction.Status process(PortfolioTransaction transaction, Portfolio portfolio) {
        return this.check(transaction, portfolio.getTransactions());
    }

    @Override
    public ImportAction.Status process(BuySellEntry entry, Account account, Portfolio portfolio) {
        List<InvestmentPlan> plans = this.client.getPlans();
        Iterator i = plans.stream().filter(p -> p.getSecurity() != null && p.getSecurity().equals(entry.getPortfolioTransaction().getSecurity())).iterator();
        while (i.hasNext()) {
            List<Transaction> transactions = ((InvestmentPlan)i.next()).getTransactions();
            for (Transaction t : transactions) {
                if (!this.isInvestmentPlanDuplicate(entry.getPortfolioTransaction(), t)) continue;
                return new ImportAction.Status(ImportAction.Status.Code.WARNING, Messages.InvestmentPlanItemImportToolTip);
            }
        }
        ImportAction.Status status = this.check(entry.getAccountTransaction(), account.getTransactions());
        if (status.getCode() != ImportAction.Status.Code.OK) {
            return status;
        }
        return this.check(entry.getPortfolioTransaction(), portfolio.getTransactions());
    }

    @Override
    public ImportAction.Status process(AccountTransferEntry entry, Account source, Account target) {
        return this.check(entry.getSourceTransaction(), source.getTransactions());
    }

    @Override
    public ImportAction.Status process(PortfolioTransferEntry entry, Portfolio source, Portfolio target) {
        return this.check(entry.getTargetTransaction(), source.getTransactions());
    }

    public Transaction findInvestmentPlanTransaction(Transaction subject, List<Transaction> transactions) {
        for (Transaction t : transactions) {
            if (!this.isInvestmentPlanDuplicate(subject, t)) continue;
            return t;
        }
        return null;
    }

    private ImportAction.Status check(AccountTransaction subject, List<AccountTransaction> transactions) {
        for (AccountTransaction t : transactions) {
            if (subject.getType() != t.getType() || !this.isPotentialDuplicate(subject, t)) continue;
            return new ImportAction.Status(ImportAction.Status.Code.WARNING, Messages.LabelPotentialDuplicate);
        }
        return ImportAction.Status.OK_STATUS;
    }

    private ImportAction.Status check(PortfolioTransaction subject, List<PortfolioTransaction> transactions) {
        Predicate<PortfolioTransaction> equivalentTypes;
        switch (subject.getType()) {
            case BUY: 
            case DELIVERY_INBOUND: {
                equivalentTypes = t -> t.getType() == PortfolioTransaction.Type.BUY || t.getType() == PortfolioTransaction.Type.DELIVERY_INBOUND;
                break;
            }
            case SELL: 
            case DELIVERY_OUTBOUND: {
                equivalentTypes = t -> t.getType() == PortfolioTransaction.Type.SELL || t.getType() == PortfolioTransaction.Type.DELIVERY_OUTBOUND;
                break;
            }
            default: {
                equivalentTypes = t -> subject.getType() == t.getType();
            }
        }
        for (PortfolioTransaction t2 : transactions) {
            if (!equivalentTypes.test(t2) || !this.isPotentialDuplicate(subject, t2)) continue;
            return new ImportAction.Status(ImportAction.Status.Code.WARNING, Messages.LabelPotentialDuplicate);
        }
        return ImportAction.Status.OK_STATUS;
    }

    private boolean isPotentialDuplicate(Transaction subject, Transaction other) {
        if (!other.getDateTime().toLocalDate().equals(subject.getDateTime().toLocalDate())) {
            return false;
        }
        if (!other.getCurrencyCode().equals(subject.getCurrencyCode())) {
            return false;
        }
        if (other.getAmount() != subject.getAmount()) {
            return false;
        }
        if (other.getShares() != subject.getShares()) {
            return false;
        }
        return Objects.equals(other.getSecurity(), subject.getSecurity());
    }

    private boolean isInvestmentPlanDuplicate(Transaction subject, Transaction other) {
        if (!other.getCurrencyCode().equals(subject.getCurrencyCode())) {
            return false;
        }
        if (!Objects.equals(other.getSecurity(), subject.getSecurity())) {
            return false;
        }
        long amount = subject.getAmount();
        if ((double)amount * 1.01 < (double)other.getAmount() || (double)amount * 0.99 > (double)other.getAmount()) {
            return false;
        }
        LocalDateTime date = subject.getDateTime();
        if (date.isBefore(other.getDateTime()) || date.minusDays(5L).isAfter(other.getDateTime())) {
            return false;
        }
        long shares = subject.getShares();
        return !((double)shares * 1.1 < (double)other.getShares()) && !((double)shares * 0.9 > (double)other.getShares());
    }
}

