/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.actions;

import java.util.Iterator;
import java.util.List;
import name.abuchen.portfolio.datatransfer.ImportAction;
import name.abuchen.portfolio.datatransfer.actions.DetectDuplicatesAction;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.AccountTransferEntry;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.InvestmentPlan;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.PortfolioTransferEntry;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.model.Transaction;

public class InsertAction
implements ImportAction {
    private final Client client;
    private boolean convertBuySellToDelivery = false;
    private boolean removeDividends = false;
    private boolean investmentPlanItem = false;

    public InsertAction(Client client) {
        this.client = client;
    }

    public void setConvertBuySellToDelivery(boolean flag) {
        this.convertBuySellToDelivery = flag;
    }

    public void setRemoveDividends(boolean flag) {
        this.removeDividends = flag;
    }

    public void setInvestmentPlanItem(boolean flag) {
        this.investmentPlanItem = flag;
    }

    @Override
    public ImportAction.Status process(Security security) {
        if (!this.client.getSecurities().contains(security)) {
            this.client.addSecurity(security);
        }
        return ImportAction.Status.OK_STATUS;
    }

    @Override
    public ImportAction.Status process(Security security, SecurityPrice price) {
        security.addPrice(price);
        return ImportAction.Status.OK_STATUS;
    }

    @Override
    public ImportAction.Status process(AccountTransaction transaction, Account account) {
        if (transaction.getSecurity() != null) {
            this.process(transaction.getSecurity());
        }
        account.addTransaction(transaction);
        if (this.removeDividends && transaction.getType() == AccountTransaction.Type.DIVIDENDS) {
            AccountTransaction removal = new AccountTransaction(transaction.getDateTime(), transaction.getCurrencyCode(), transaction.getAmount(), null, AccountTransaction.Type.REMOVAL);
            removal.setNote(transaction.getNote());
            account.addTransaction(removal);
        }
        return ImportAction.Status.OK_STATUS;
    }

    @Override
    public ImportAction.Status process(PortfolioTransaction transaction, Portfolio portfolio) {
        this.process(transaction.getSecurity());
        portfolio.addTransaction(transaction);
        return ImportAction.Status.OK_STATUS;
    }

    @Override
    public ImportAction.Status process(BuySellEntry entry, Account account, Portfolio portfolio) {
        this.process(entry.getPortfolioTransaction().getSecurity());
        if (this.investmentPlanItem) {
            DetectDuplicatesAction action = new DetectDuplicatesAction(this.client);
            Transaction existingTransaction = null;
            PortfolioTransaction t = entry.getPortfolioTransaction();
            List<InvestmentPlan> plans = this.client.getPlans();
            Iterator i = plans.stream().filter(p -> p.getSecurity() != null && p.getSecurity().equals(t.getSecurity())).iterator();
            while (i.hasNext()) {
                List<Transaction> transactions = ((InvestmentPlan)i.next()).getTransactions();
                existingTransaction = action.findInvestmentPlanTransaction(t, transactions);
                if (existingTransaction == null) continue;
                existingTransaction.setDateTime(t.getDateTime());
                existingTransaction.setNote(t.getNote());
                existingTransaction.setShares(t.getShares());
                existingTransaction.setAmount(t.getAmount());
                existingTransaction.clearUnits();
                t.getUnits().forEach(existingTransaction::addUnit);
                if (existingTransaction.getCrossEntry() != null) {
                    Transaction crossTransaction = existingTransaction.getCrossEntry().getCrossTransaction(existingTransaction);
                    crossTransaction.setDateTime(t.getDateTime());
                    crossTransaction.setAmount(t.getAmount());
                    crossTransaction.setNote(t.getNote());
                }
                return ImportAction.Status.OK_STATUS;
            }
        }
        if (this.convertBuySellToDelivery) {
            PortfolioTransaction t = entry.getPortfolioTransaction();
            PortfolioTransaction delivery = new PortfolioTransaction();
            delivery.setType(t.getType() == PortfolioTransaction.Type.BUY ? PortfolioTransaction.Type.DELIVERY_INBOUND : PortfolioTransaction.Type.DELIVERY_OUTBOUND);
            delivery.setDateTime(t.getDateTime());
            delivery.setSecurity(t.getSecurity());
            delivery.setMonetaryAmount(t.getMonetaryAmount());
            delivery.setNote(t.getNote());
            delivery.setShares(t.getShares());
            delivery.addUnits(t.getUnits());
            return this.process(delivery, portfolio);
        }
        entry.setPortfolio(portfolio);
        entry.setAccount(account);
        entry.insert();
        return ImportAction.Status.OK_STATUS;
    }

    @Override
    public ImportAction.Status process(AccountTransferEntry entry, Account source, Account target) {
        entry.setSourceAccount(source);
        entry.setTargetAccount(target);
        entry.insert();
        return ImportAction.Status.OK_STATUS;
    }

    @Override
    public ImportAction.Status process(PortfolioTransferEntry entry, Portfolio source, Portfolio target) {
        this.process(entry.getSourceTransaction().getSecurity());
        entry.setSourcePortfolio(source);
        entry.setTargetPortfolio(target);
        entry.insert();
        return ImportAction.Status.OK_STATUS;
    }
}

