/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.csv;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import name.abuchen.portfolio.datatransfer.csv.CSVExporter;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.money.Values;
import org.apache.commons.csv.CSVPrinter;

public class AktienfreundeNetExporter {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    public void exportAllTransactions(File file, Client client) throws IOException {
        List transactions = Stream.concat(client.getAccounts().stream(), client.getPortfolios().stream()).flatMap(l -> ((TransactionOwner)((Object)l)).getTransactions().stream()).sorted(new Transaction.ByDate()).collect(Collectors.toList());
        Throwable throwable = null;
        Object var5_6 = null;
        try (CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), CSVExporter.STRATEGY);){
            this.writeHeader(printer);
            for (Transaction t : transactions) {
                if (t instanceof AccountTransaction) {
                    this.writeDividend(printer, (AccountTransaction)t);
                    continue;
                }
                if (!(t instanceof PortfolioTransaction)) continue;
                this.writeBuySell(printer, (PortfolioTransaction)t);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeDividend(CSVPrinter printer, AccountTransaction transaction) throws IOException {
        if (transaction.getSecurity() == null) {
            return;
        }
        if (transaction.getType() != AccountTransaction.Type.INTEREST && transaction.getType() != AccountTransaction.Type.DIVIDENDS) {
            return;
        }
        printer.print((Object)DATE_FORMAT.format(transaction.getDateTime().toLocalDate()));
        printer.print((Object)CSVExporter.escapeNull(transaction.getSecurity().getIsin()));
        printer.print((Object)CSVExporter.escapeNull(transaction.getSecurity().getName()));
        printer.print((Object)"Aktie");
        printer.print((Object)"Dividende");
        printer.print((Object)Values.Amount.format(transaction.getAmount()));
        printer.print((Object)"1");
        printer.print((Object)"");
        printer.print((Object)"");
        printer.println();
    }

    private void writeBuySell(CSVPrinter printer, PortfolioTransaction transaction) throws IOException {
        String type;
        switch (transaction.getType()) {
            case BUY: 
            case DELIVERY_INBOUND: {
                type = "Kauf";
                break;
            }
            case SELL: 
            case DELIVERY_OUTBOUND: {
                type = "Verkauf";
                break;
            }
            default: {
                return;
            }
        }
        printer.print((Object)DATE_FORMAT.format(transaction.getDateTime().toLocalDate()));
        printer.print((Object)CSVExporter.escapeNull(transaction.getSecurity().getIsin()));
        printer.print((Object)CSVExporter.escapeNull(transaction.getSecurity().getName()));
        printer.print((Object)"Aktie");
        printer.print((Object)type);
        printer.print((Object)Values.Quote.format(transaction.getGrossPricePerShare().getAmount()));
        printer.print((Object)Values.Share.format(transaction.getShares()));
        printer.print((Object)Values.Amount.format(transaction.getUnitSum(Transaction.Unit.Type.FEE).getAmount()));
        printer.print((Object)Values.Amount.format(transaction.getUnitSum(Transaction.Unit.Type.TAX).getAmount()));
        printer.println();
    }

    private void writeHeader(CSVPrinter printer) throws IOException {
        printer.print((Object)"Datum");
        printer.print((Object)"ISIN");
        printer.print((Object)"Name");
        printer.print((Object)"Typ");
        printer.print((Object)"Transaktion");
        printer.print((Object)"Preis");
        printer.print((Object)"Anzahl");
        printer.print((Object)"Kommission");
        printer.print((Object)"Steuern");
        printer.println();
    }
}

