/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.csv;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.util.TextUtil;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CSVExporter {
    static final CSVFormat STRATEGY = CSVFormat.newFormat((char)TextUtil.getListSeparatorChar()).withQuote('\"').withRecordSeparator("\r\n").withAllowDuplicateHeaderNames();

    public void exportAccountTransactions(File file, Account account) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), STRATEGY);){
            printer.printRecord(new Object[]{Messages.CSVColumn_Date, Messages.CSVColumn_Type, Messages.CSVColumn_Value, Messages.CSVColumn_TransactionCurrency, Messages.CSVColumn_Taxes, Messages.CSVColumn_Shares, Messages.CSVColumn_ISIN, Messages.CSVColumn_WKN, Messages.CSVColumn_TickerSymbol, Messages.CSVColumn_SecurityName, Messages.CSVColumn_Note});
            for (AccountTransaction t : account.getTransactions()) {
                printer.print((Object)t.getDateTime().toString());
                printer.print((Object)t.getType().toString());
                printer.print((Object)Values.Amount.format(t.getType().isDebit() ? -t.getAmount() : t.getAmount()));
                printer.print((Object)t.getCurrencyCode());
                printer.print((Object)(t.getType() == AccountTransaction.Type.DIVIDENDS ? Values.Amount.format(t.getUnitSum(Transaction.Unit.Type.TAX).getAmount()) : ""));
                printer.print((Object)(t.getShares() != 0L ? Values.Share.format(t.getShares()) : ""));
                this.printSecurityInfo(printer, t);
                printer.print((Object)CSVExporter.escapeNull(t.getNote()));
                printer.println();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void exportAccountTransactions(File directory, List<Account> accounts) throws IOException {
        for (Account account : accounts) {
            this.exportAccountTransactions(new File(directory, String.valueOf(account.getName()) + ".csv"), account);
        }
    }

    public void exportPortfolioTransactions(File file, Portfolio portfolio) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), STRATEGY);){
            printer.printRecord(new Object[]{Messages.CSVColumn_Date, Messages.CSVColumn_Type, Messages.CSVColumn_Value, Messages.CSVColumn_TransactionCurrency, Messages.CSVColumn_GrossAmount, Messages.CSVColumn_CurrencyGrossAmount, Messages.CSVColumn_ExchangeRate, Messages.CSVColumn_Fees, Messages.CSVColumn_Taxes, Messages.CSVColumn_Shares, Messages.CSVColumn_ISIN, Messages.CSVColumn_WKN, Messages.CSVColumn_TickerSymbol, Messages.CSVColumn_SecurityName, Messages.CSVColumn_Note});
            for (PortfolioTransaction t : portfolio.getTransactions()) {
                printer.print((Object)t.getDateTime().toString());
                printer.print((Object)t.getType().toString());
                printer.print((Object)Values.Amount.format(t.getType().isLiquidation() ? -t.getAmount() : t.getAmount()));
                printer.print((Object)t.getCurrencyCode());
                Optional<Transaction.Unit> grossAmount = t.getUnit(Transaction.Unit.Type.GROSS_VALUE);
                if (grossAmount.isPresent()) {
                    Money forex = grossAmount.get().getForex();
                    printer.print((Object)Values.Amount.format(forex.getAmount()));
                    printer.print((Object)forex.getCurrencyCode());
                    printer.print((Object)Values.ExchangeRate.format(grossAmount.get().getExchangeRate()));
                } else {
                    printer.print((Object)"");
                    printer.print((Object)"");
                    printer.print((Object)"");
                }
                printer.print((Object)Values.Amount.format(t.getUnitSum(Transaction.Unit.Type.FEE).getAmount()));
                printer.print((Object)Values.Amount.format(t.getUnitSum(Transaction.Unit.Type.TAX).getAmount()));
                printer.print((Object)Values.Share.format(t.getShares()));
                this.printSecurityInfo(printer, t);
                printer.print((Object)CSVExporter.escapeNull(t.getNote()));
                printer.println();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void printSecurityInfo(CSVPrinter printer, Transaction t) throws IOException {
        Security security = t.getSecurity();
        if (security != null) {
            printer.print((Object)CSVExporter.escapeNull(security.getIsin()));
            printer.print((Object)CSVExporter.escapeNull(security.getWkn()));
            printer.print((Object)CSVExporter.escapeNull(security.getTickerSymbol()));
            printer.print((Object)CSVExporter.escapeNull(security.getName()));
        } else {
            printer.print((Object)"");
            printer.print((Object)"");
            printer.print((Object)"");
            printer.print((Object)"");
        }
    }

    public void exportPortfolioTransactions(File directory, List<Portfolio> portfolios) throws IOException {
        for (Portfolio portfolio : portfolios) {
            this.exportPortfolioTransactions(new File(directory, String.valueOf(portfolio.getName()) + ".csv"), portfolio);
        }
    }

    public void exportSecurityMasterData(File file, List<Security> securities) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), STRATEGY);){
            printer.printRecord(new Object[]{Messages.CSVColumn_ISIN, Messages.CSVColumn_WKN, Messages.CSVColumn_TickerSymbol, Messages.CSVColumn_SecurityName, Messages.CSVColumn_Currency, Messages.CSVColumn_Note});
            for (Security s : securities) {
                printer.print((Object)CSVExporter.escapeNull(s.getIsin()));
                printer.print((Object)CSVExporter.escapeNull(s.getWkn()));
                printer.print((Object)CSVExporter.escapeNull(s.getTickerSymbol()));
                printer.print((Object)CSVExporter.escapeNull(s.getName()));
                printer.print((Object)CSVExporter.escapeNull(s.getCurrencyCode()));
                printer.print((Object)CSVExporter.escapeNull(s.getNote()));
                printer.println();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void exportSecurityPrices(File file, Security security) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), STRATEGY);){
            printer.printRecord(new Object[]{Messages.CSVColumn_Date, Messages.CSVColumn_Quote});
            for (SecurityPrice p : security.getPrices()) {
                printer.print((Object)p.getDate().toString());
                printer.print((Object)Values.Quote.format(p.getValue()));
                printer.println();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void exportSecurityPrices(File directory, List<Security> securities) throws IOException {
        for (Security security : securities) {
            this.exportSecurityPrices(new File(directory, String.valueOf(security.getIsin()) + ".csv"), security);
        }
    }

    public void exportMergedSecurityPrices(File file, List<Security> securities) throws IOException {
        LocalDate earliestDate = null;
        ArrayList<Security> export = new ArrayList<Security>(securities.size());
        for (Security s : securities) {
            List<SecurityPrice> prices = s.getPrices();
            if (prices.isEmpty()) continue;
            export.add(s);
            LocalDate quoteDate = prices.get(0).getDate();
            if (earliestDate == null) {
                earliestDate = quoteDate;
                continue;
            }
            LocalDate localDate = earliestDate = earliestDate.isAfter(quoteDate) ? quoteDate : earliestDate;
        }
        Throwable throwable = null;
        Iterator<Security> iterator = null;
        try (CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), STRATEGY);){
            printer.print((Object)Messages.CSVColumn_Date);
            for (Security security : export) {
                printer.print((Object)security.getExternalIdentifier());
            }
            printer.println();
            if (earliestDate == null) {
                return;
            }
            LocalDate pointer = earliestDate;
            LocalDate today = LocalDate.now();
            while (pointer.compareTo(today) <= 0) {
                int[] indices = new int[export.size()];
                int ii = 0;
                for (Security security : export) {
                    SecurityPrice p = new SecurityPrice(pointer, 0L);
                    indices[ii] = Collections.binarySearch(security.getPrices(), p);
                    ++ii;
                }
                boolean hasValues = false;
                ii = 0;
                while (ii < indices.length && !hasValues) {
                    hasValues = indices[ii] >= 0;
                    ++ii;
                }
                if (hasValues) {
                    printer.print((Object)pointer.toString());
                    ii = 0;
                    while (ii < indices.length) {
                        if (indices[ii] < 0) {
                            printer.print((Object)"");
                        } else {
                            printer.print((Object)Values.Quote.format(((Security)export.get(ii)).getPrices().get(indices[ii]).getValue()));
                        }
                        ++ii;
                    }
                    printer.println();
                }
                pointer = pointer.plusDays(1L);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static String escapeNull(String value) {
        return value != null ? value : "";
    }
}

