/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.csv;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.PortfolioLog;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.csv.CSVAccountTransactionExtractor;
import name.abuchen.portfolio.datatransfer.csv.CSVExtractor;
import name.abuchen.portfolio.datatransfer.csv.CSVPortfolioExtractor;
import name.abuchen.portfolio.datatransfer.csv.CSVPortfolioTransactionExtractor;
import name.abuchen.portfolio.datatransfer.csv.CSVSecurityExtractor;
import name.abuchen.portfolio.datatransfer.csv.CSVSecurityPriceExtractor;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.util.Isin;
import name.abuchen.portfolio.util.TextUtil;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public final class CSVImporter {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final Client client;
    private final File inputFile;
    private final List<CSVExtractor> extractors;
    private CSVExtractor currentExtractor;
    private char delimiter = TextUtil.getListSeparatorChar();
    private Charset encoding = Charset.defaultCharset();
    private int skipLines = 0;
    private boolean isFirstLineHeader = true;
    private Column[] columns;
    private List<String[]> values;

    public CSVImporter(Client client, File file) {
        this.client = client;
        this.inputFile = file;
        this.extractors = Collections.unmodifiableList(Arrays.asList(new CSVAccountTransactionExtractor(client), new CSVPortfolioTransactionExtractor(client), new CSVSecurityExtractor(client), new CSVSecurityPriceExtractor(), new CSVPortfolioExtractor(client)));
        this.currentExtractor = this.extractors.get(0);
    }

    public Client getClient() {
        return this.client;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public List<CSVExtractor> getExtractors() {
        return this.extractors;
    }

    public void setExtractor(CSVExtractor extractor) {
        this.currentExtractor = extractor;
        this.propertyChangeSupport.firePropertyChange("extractor", this.currentExtractor, this.currentExtractor);
    }

    public CSVExtractor getExtractor() {
        return this.currentExtractor;
    }

    public CSVExtractor getSecurityPriceExtractor() {
        return this.extractors.stream().filter(e -> e instanceof CSVSecurityPriceExtractor).findAny().orElseThrow(IllegalArgumentException::new);
    }

    public Optional<CSVExtractor> getExtractorByCode(String code) {
        return this.extractors.stream().filter(e -> code.equals(e.getCode())).findAny();
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
        this.propertyChangeSupport.firePropertyChange("delimiter", this.delimiter, this.delimiter);
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
        this.propertyChangeSupport.firePropertyChange("encoding", this.encoding, this.encoding);
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setSkipLines(int skipLines) {
        this.skipLines = skipLines;
        this.propertyChangeSupport.firePropertyChange("skipLines", this.skipLines, this.skipLines);
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public void setFirstLineHeader(boolean isFirstLineHeader) {
        this.isFirstLineHeader = isFirstLineHeader;
        this.propertyChangeSupport.firePropertyChange("firstLineHeader", this.isFirstLineHeader, this.isFirstLineHeader);
    }

    public boolean isFirstLineHeader() {
        return this.isFirstLineHeader;
    }

    public List<String[]> getRawValues() {
        return this.values;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    void setColumns(Column[] columns) {
        this.columns = columns;
    }

    private void processStream(InputStream stream, boolean remap) throws IOException {
        InputStreamReader reader = new InputStreamReader(stream, this.encoding);
        CSVFormat strategy = CSVFormat.newFormat((char)this.delimiter).withQuote('\"').withRecordSeparator("\r\n");
        try {
            int ii;
            CSVRecord line;
            CSVParser parser = CSVParser.parse((Reader)reader, (CSVFormat)strategy);
            Iterator records = parser.iterator();
            int ii2 = 0;
            while (ii2 < this.skipLines && records.hasNext()) {
                records.next();
                ++ii2;
            }
            ArrayList<String[]> input = new ArrayList<String[]>();
            String[] header = null;
            CSVRecord cSVRecord = line = records.hasNext() ? (CSVRecord)records.next() : null;
            if (line == null) {
                this.values = Collections.emptyList();
                if (remap) {
                    this.columns = new Column[0];
                }
                return;
            }
            if (this.isFirstLineHeader) {
                header = this.toStringArray(line);
            } else {
                header = new String[line.size()];
                ii = 0;
                while (ii < header.length) {
                    header[ii] = MessageFormat.format(Messages.CSVImportGenericColumnLabel, ii + 1);
                    ++ii;
                }
                input.add(this.toStringArray(line));
            }
            while (records.hasNext()) {
                input.add(this.toStringArray((CSVRecord)records.next()));
            }
            this.values = input;
            if (this.columns == null || remap) {
                this.columns = new Column[header.length];
                ii = 0;
                while (ii < header.length) {
                    this.columns[ii] = new Column(ii, header[ii]);
                    ++ii;
                }
                this.mapToImportDefinition();
            }
        }
        catch (IllegalStateException e) {
            PortfolioLog.error(e);
            if (remap) {
                this.columns = new Column[]{new Column(0, Messages.LabelError)};
            }
            ArrayList<String[]> reply = new ArrayList<String[]>();
            reply.add(new String[]{e.getMessage()});
            this.values = reply;
        }
    }

    private String[] toStringArray(CSVRecord line) {
        String[] answer = new String[line.size()];
        int ii = 0;
        while (ii < answer.length) {
            answer[ii] = line.get(ii);
            ++ii;
        }
        return answer;
    }

    public void processFile(boolean remap) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream stream = new FileInputStream(this.inputFile);){
                this.processStream(stream, remap);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PortfolioLog.error(e);
            try {
                byte[] ptext = this.inputFile.toString().getBytes(StandardCharsets.UTF_8);
                String str = new String(ptext, StandardCharsets.ISO_8859_1);
                Path path = Paths.get(URI.create("file://" + str));
                Throwable throwable = null;
                Object var7_14 = null;
                try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                    this.processStream(stream, remap);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException | IllegalArgumentException ignore) {
                PortfolioLog.error(ignore);
                throw e;
            }
        }
    }

    private void mapToImportDefinition() {
        LinkedList<Field> list = new LinkedList<Field>(this.currentExtractor.getFields());
        Column[] columnArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            column.setField(null);
            String normalizedColumnName = CSVImporter.normalizeColumnName(column.getLabel());
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Field field = (Field)iter.next();
                if (!field.getNormalizedNames().contains(normalizedColumnName)) continue;
                column.setField(field);
                String value = this.getFirstNonEmptyValue(column);
                column.setFormat(field.guessFormat(this.client, value));
                iter.remove();
                break;
            }
            ++n2;
        }
    }

    public List<Extractor.Item> createItems(List<Exception> errors) {
        HashMap<String, Column> field2column = new HashMap<String, Column>();
        Column[] columnArray = this.getColumns();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            if (column.getField() != null) {
                field2column.put(column.getField().getName(), column);
            }
            ++n2;
        }
        int startingLineNo = this.skipLines + (this.isFirstLineHeader ? 1 : 0);
        return this.currentExtractor.extract(startingLineNo, this.values, field2column, errors);
    }

    public String getFirstNonEmptyValue(Column column) {
        int index = column.getColumnIndex();
        for (String[] rawValues : this.values) {
            String value = rawValues[index];
            if (value == null || value.trim().isEmpty()) continue;
            return value;
        }
        return null;
    }

    private static String normalizeColumnName(String name) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < name.length()) {
            char c = Character.toUpperCase(name.charAt(i));
            switch (c) {
                case '\u00c4': {
                    sb.append("AE");
                    break;
                }
                case '\u00d6': {
                    sb.append("OE");
                    break;
                }
                case '\u00dc': {
                    sb.append("UE");
                    break;
                }
                case '\u00df': {
                    sb.append("SS");
                    break;
                }
                case ' ': {
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public static class AmountField
    extends Field {
        private static final List<FieldFormat> FORMATS = Collections.unmodifiableList(Arrays.asList(new FieldFormat("0.000,00", Messages.CSVFormatNumberGermany, NumberFormat.getInstance(Locale.GERMANY)), new FieldFormat("0,000.00", Messages.CSVFormatNumberUS, NumberFormat.getInstance(Locale.US)), new FieldFormat("0'000,00", Messages.CSVFormatApostrophe, () -> {
            DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols(Locale.US);
            unusualSymbols.setGroupingSeparator('\'');
            return new DecimalFormat("#,##0.###", unusualSymbols);
        })));

        AmountField(String code, String ... name) {
            super(code, name);
        }

        @Override
        public List<FieldFormat> getAvailableFieldFormats() {
            return FORMATS;
        }

        @Override
        public FieldFormat guessFormat(Client client, String value) {
            if ("CH".equals(Locale.getDefault().getCountry())) {
                return FORMATS.get(2);
            }
            if (TextUtil.DECIMAL_SEPARATOR == ',') {
                return FORMATS.get(0);
            }
            if (TextUtil.DECIMAL_SEPARATOR == '.') {
                return FORMATS.get(1);
            }
            return FORMATS.get(0);
        }

        @Override
        public String formatToText(FieldFormat fieldFormat) {
            return fieldFormat.getCode();
        }

        @Override
        public FieldFormat textToFormat(String text) {
            for (FieldFormat format : this.getAvailableFieldFormats()) {
                if (!format.getCode().equals(text)) continue;
                return format;
            }
            return this.getAvailableFieldFormats().get(0);
        }
    }

    public static final class Column {
        private final int columnIndex;
        private final String label;
        private Field field;
        private FieldFormat format;

        Column(int columnIndex, String label) {
            this.columnIndex = columnIndex;
            this.label = label;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public String getLabel() {
            return this.label;
        }

        public void setField(Field field) {
            this.field = field;
            this.format = null;
        }

        public Field getField() {
            return this.field;
        }

        public void setFormat(FieldFormat format) {
            this.format = format;
        }

        public FieldFormat getFormat() {
            return this.format;
        }
    }

    public static class DateField
    extends Field {
        private static final List<FieldFormat> FORMATS = Collections.unmodifiableList(Arrays.asList(new DateFieldFormat(Messages.CSVFormatYYYYMMDD, "yyyy-MM-dd"), new DateFieldFormat(Messages.CSVFormatYYYYMMDDSlashes, "yyyy/MM/dd"), new DateFieldFormat(Messages.CSVFormatISO, "yyyyMMdd"), new DateFieldFormat(Messages.CSVFormatDDMMYYYY, "dd.MM.yyyy"), new DateFieldFormat(Messages.CSVFormatDDMMYY, "dd.MM.yy"), new DateFieldFormat(Messages.CSVFormatDDMMYYYY1, "dd/MM/yyyy"), new DateFieldFormat(Messages.CSVFormatDDMMYY1, "dd/MM/yy"), new DateFieldFormat(Messages.CSVFormatDDMMYYYY2, "dd-MM-yyyy"), new DateFieldFormat(Messages.CSVFormatDDMMYY2, "dd-MM-yy"), new DateFieldFormat(Messages.CSVFormatMMDDYYYY1, "MM/dd/yyyy"), new DateFieldFormat(Messages.CSVFormatMMDDYY1, "MM/dd/yy"), new DateFieldFormat(Messages.CSVFormatMMDDYY, "MM-dd-yy"), new DateFieldFormat(Messages.CSVFormatMMDDYYYY, "MM-dd-yyyy"), new DateFieldFormat(Messages.CSVFormatDDMMMYYYY, "dd-MMM-yyyy"), new DateFieldFormat(Messages.CSVFormatDDMMMYYYY_German, "dd-MMM-yyyy", Locale.GERMAN), new DateFieldFormat(Messages.CSVFormatDDMMMYYYY_English, "dd-MMM-yyyy", Locale.US)));

        DateField(String code, String name) {
            super(code, name);
        }

        @Override
        public List<FieldFormat> getAvailableFieldFormats() {
            return FORMATS;
        }

        @Override
        public FieldFormat guessFormat(Client client, String value) {
            if (value != null) {
                for (FieldFormat f : FORMATS) {
                    try {
                        f.format.parseObject(value);
                        return f;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            return FORMATS.get(0);
        }

        @Override
        public String formatToText(FieldFormat fieldFormat) {
            return fieldFormat.getCode();
        }

        @Override
        public FieldFormat textToFormat(String text) {
            for (FieldFormat format : this.getAvailableFieldFormats()) {
                if (!format.getCode().equals(text)) continue;
                return format;
            }
            return this.getAvailableFieldFormats().get(0);
        }
    }

    private static class DateFieldFormat
    extends FieldFormat {
        public DateFieldFormat(String label, String pattern) {
            super(pattern, label, new SimpleDateFormat(pattern));
        }

        public DateFieldFormat(String label, String pattern, Locale locale) {
            super(String.valueOf(pattern) + ";" + locale.toString(), label, new SimpleDateFormat(pattern, locale));
        }
    }

    public static class EnumField<M extends Enum<M>>
    extends Field {
        private final Class<M> enumType;

        EnumField(String code, String name, Class<M> enumType) {
            super(code, name);
            this.enumType = enumType;
        }

        public Class<M> getEnumType() {
            return this.enumType;
        }

        @Override
        public FieldFormat guessFormat(Client client, String value) {
            return new FieldFormat(null, new EnumMapFormat<M>(this.enumType));
        }

        @Override
        public String formatToText(FieldFormat fieldFormat) {
            EnumMapFormat f = (EnumMapFormat)fieldFormat.getFormat();
            StringJoiner answer = new StringJoiner(";");
            f.map().forEach((e, t) -> {
                StringJoiner stringJoiner2 = answer.add(String.valueOf(e.name()) + "=" + t);
            });
            return answer.toString();
        }

        @Override
        public FieldFormat textToFormat(String text) {
            String[] entries;
            EnumMapFormat<M> format = new EnumMapFormat<M>(this.enumType);
            FieldFormat answer = new FieldFormat(null, format);
            String[] stringArray = entries = text.split(";");
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                String[] entry = e.split("=");
                if (entry.length == 2) {
                    try {
                        M key = Enum.valueOf(this.enumType, entry[0]);
                        String value = entry[1];
                        format.map().put(key, value);
                    }
                    catch (IllegalArgumentException | NullPointerException ignore) {
                        PortfolioLog.error(ignore);
                    }
                }
                ++n2;
            }
            return answer;
        }
    }

    public static class EnumMapFormat<M extends Enum<M>>
    extends Format {
        private static final long serialVersionUID = 1L;
        private EnumMap<M, String> enumMap;

        public EnumMapFormat(Class<M> enumType) {
            this.enumMap = new EnumMap(enumType);
            Enum[] enumArray = (Enum[])enumType.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum element = enumArray[n2];
                this.enumMap.put(element, element.toString());
                ++n2;
            }
        }

        public EnumMap<M, String> map() {
            return this.enumMap;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            String s = this.enumMap.get(obj);
            if (s == null) {
                throw new IllegalArgumentException();
            }
            return toAppendTo.append(s);
        }

        public M parseObject(String source, ParsePosition pos) {
            if (pos == null) {
                throw new NullPointerException();
            }
            for (Map.Entry<M, String> entry : this.enumMap.entrySet()) {
                if (!source.equalsIgnoreCase(entry.getValue())) continue;
                pos.setIndex(source.length());
                return (M)((Enum)entry.getKey());
            }
            for (Map.Entry<M, String> entry : this.enumMap.entrySet()) {
                try {
                    Pattern p = Pattern.compile(entry.getValue());
                    if (!p.matcher(source).find()) continue;
                    pos.setIndex(source.length());
                    return (M)((Enum)entry.getKey());
                }
                catch (PatternSyntaxException e) {
                    PortfolioLog.error(e);
                }
            }
            return null;
        }
    }

    public static class Field {
        private final String code;
        private final String[] names;
        private final Set<String> normalizedNames;
        private boolean isOptional = false;

        public Field(String code, String ... names) {
            if (names.length < 1) {
                throw new IllegalArgumentException();
            }
            this.code = code;
            this.names = names;
            this.normalizedNames = new HashSet<String>();
            int ii = 0;
            while (ii < names.length) {
                this.normalizedNames.add(CSVImporter.normalizeColumnName(names[ii]));
                ++ii;
            }
        }

        public String getCode() {
            return this.code;
        }

        public String getName() {
            return this.names[0];
        }

        public Set<String> getNormalizedNames() {
            return this.normalizedNames;
        }

        public Field setOptional(boolean isOptional) {
            this.isOptional = isOptional;
            return this;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public List<FieldFormat> getAvailableFieldFormats() {
            return Collections.emptyList();
        }

        public FieldFormat guessFormat(Client client, String value) {
            return null;
        }

        public String formatToText(FieldFormat fieldFormat) {
            throw new UnsupportedOperationException();
        }

        public FieldFormat textToFormat(String text) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class FieldFormat {
        private final String code;
        private final String label;
        private final Format format;

        public FieldFormat(String code, String label, Format format) {
            this.code = code;
            this.label = label;
            this.format = format;
        }

        public FieldFormat(String label, Format format) {
            this(null, label, format);
        }

        public FieldFormat(String code, String label, Supplier<Format> supplier) {
            this(code, label, supplier.get());
        }

        public String getCode() {
            return this.code;
        }

        public String toString() {
            return this.label;
        }

        public Format getFormat() {
            return this.format;
        }

        public String toPattern() {
            if (this.format instanceof SimpleDateFormat) {
                return ((SimpleDateFormat)this.format).toPattern();
            }
            if (this.format instanceof DecimalFormat) {
                return ((DecimalFormat)this.format).toPattern();
            }
            if (this.format instanceof ISINFormat) {
                return "[A-Z]{2}[A-Z0-9]{9}\\d";
            }
            if (this.format instanceof EnumMapFormat) {
                return ((EnumMapFormat)this.format).map().toString();
            }
            return null;
        }
    }

    public static class ISINField
    extends Field {
        ISINField(String code, String name) {
            super(code, name);
        }

        @Override
        public FieldFormat guessFormat(Client client, String value) {
            return new FieldFormat(null, new ISINFormat(client.getSecurities()));
        }

        @Override
        public String formatToText(FieldFormat fieldFormat) {
            return null;
        }

        @Override
        public FieldFormat textToFormat(String text) {
            return null;
        }
    }

    public static class ISINFormat
    extends Format {
        private static final long serialVersionUID = 1L;
        private Set<String> existingISINs;

        public ISINFormat(List<Security> securityList) {
            this.existingISINs = securityList.stream().map(Security::getIsin).filter(isin -> isin != null && !isin.trim().isEmpty()).collect(Collectors.toSet());
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            String s = (String)obj;
            if (s == null) {
                throw new IllegalArgumentException();
            }
            return toAppendTo.append(s);
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            Objects.requireNonNull(pos);
            String isin = source.trim().toUpperCase();
            Pattern pattern = Pattern.compile("\\b([A-Z]{2}[A-Z0-9]{9}\\d)\\b");
            Matcher matcher = pattern.matcher(isin);
            if (matcher.find()) {
                isin = matcher.group(1);
            }
            if (Isin.isValid(isin) && this.existingISINs.contains(isin)) {
                pos.setIndex(source.length());
                return isin;
            }
            return null;
        }
    }
}

