/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.csv;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.csv.BaseCSVExtractor;
import name.abuchen.portfolio.datatransfer.csv.CSVImporter;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.PortfolioTransferEntry;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.CurrencyUnit;
import name.abuchen.portfolio.money.Money;

class CSVPortfolioTransactionExtractor
extends BaseCSVExtractor {
    CSVPortfolioTransactionExtractor(Client client) {
        super(client, Messages.CSVDefPortfolioTransactions);
        List<CSVImporter.Field> fields = this.getFields();
        fields.add(new CSVImporter.DateField("date", Messages.CSVColumn_Date));
        fields.add(new CSVImporter.Field("time", Messages.CSVColumn_Time).setOptional(true));
        fields.add(new CSVImporter.ISINField("isin", Messages.CSVColumn_ISIN).setOptional(true));
        fields.add(new CSVImporter.Field("ticker", Messages.CSVColumn_TickerSymbol).setOptional(true));
        fields.add(new CSVImporter.Field("wkn", Messages.CSVColumn_WKN).setOptional(true));
        fields.add(new CSVImporter.Field("name", Messages.CSVColumn_SecurityName).setOptional(true));
        fields.add(new CSVImporter.AmountField("value", Messages.CSVColumn_Value));
        fields.add(new CSVImporter.Field("currency", Messages.CSVColumn_TransactionCurrency).setOptional(true));
        fields.add(new CSVImporter.AmountField("fees", Messages.CSVColumn_Fees).setOptional(true));
        fields.add(new CSVImporter.AmountField("taxes", Messages.CSVColumn_Taxes).setOptional(true));
        fields.add(new CSVImporter.AmountField("gross", Messages.CSVColumn_GrossAmount).setOptional(true));
        fields.add(new CSVImporter.Field("currencyGross", Messages.CSVColumn_CurrencyGrossAmount).setOptional(true));
        fields.add(new CSVImporter.AmountField("exchangeRate", Messages.CSVColumn_ExchangeRate).setOptional(true));
        fields.add(new CSVImporter.AmountField("shares", Messages.CSVColumn_Shares));
        fields.add(new CSVImporter.EnumField<PortfolioTransaction.Type>("type", Messages.CSVColumn_Type, PortfolioTransaction.Type.class).setOptional(true));
        fields.add(new CSVImporter.Field("note", Messages.CSVColumn_Note).setOptional(true));
        fields.add(new CSVImporter.Field("account", Messages.CSVColumn_AccountName).setOptional(true));
        fields.add(new CSVImporter.Field("portfolio", Messages.CSVColumn_PortfolioName).setOptional(true));
        fields.add(new CSVImporter.Field("portfolio2nd", Messages.CSVColumn_PortfolioName2nd).setOptional(true));
    }

    @Override
    public String getCode() {
        return "portfolio-transaction";
    }

    @Override
    void extract(List<Extractor.Item> items, String[] rawValues, Map<String, CSVImporter.Column> field2column) throws ParseException {
        Security security = this.getSecurity(rawValues, field2column, s -> {
            String currency = this.getText(Messages.CSVColumn_CurrencyGrossAmount, rawValues, field2column);
            if (currency == null || currency.isEmpty()) {
                currency = this.getText(Messages.CSVColumn_TransactionCurrency, rawValues, field2column);
            }
            if (currency != null) {
                CurrencyUnit unit = CurrencyUnit.getInstance(currency.trim());
                s.setCurrencyCode(unit == null ? this.getClient().getBaseCurrency() : unit.getCurrencyCode());
            }
        });
        if (security == null) {
            throw new ParseException(MessageFormat.format(Messages.CSVImportMissingSecurity, new StringJoiner(", ").add(Messages.CSVColumn_ISIN).add(Messages.CSVColumn_TickerSymbol).add(Messages.CSVColumn_WKN).toString()), 0);
        }
        Money amount = this.getMoney(rawValues, field2column);
        PortfolioTransaction.Type type = this.inferType(rawValues, field2column, amount);
        LocalDateTime date = this.getDate(Messages.CSVColumn_Date, Messages.CSVColumn_Time, rawValues, field2column);
        if (date == null) {
            throw new ParseException(MessageFormat.format(Messages.CSVImportMissingField, Messages.CSVColumn_Date), 0);
        }
        Long shares = this.getShares(Messages.CSVColumn_Shares, rawValues, field2column);
        Long fees = this.getAmount(Messages.CSVColumn_Fees, rawValues, field2column);
        Long taxes = this.getAmount(Messages.CSVColumn_Taxes, rawValues, field2column);
        String note = this.getText(Messages.CSVColumn_Note, rawValues, field2column);
        Transaction.Unit grossAmount = this.extractGrossAmount(rawValues, field2column, amount);
        Account account = this.getAccount(this.getClient(), rawValues, field2column);
        Portfolio portfolio = this.getPortfolio(this.getClient(), rawValues, field2column);
        Portfolio portfolio2nd = this.getPortfolio(this.getClient(), rawValues, field2column, true);
        Extractor.Item item = null;
        switch (type) {
            case BUY: 
            case SELL: {
                item = this.createBuySell(rawValues, field2column, type, security, amount, fees, taxes, date, note, shares, grossAmount);
                break;
            }
            case TRANSFER_IN: 
            case TRANSFER_OUT: {
                item = this.createTransfer(security, amount, fees, taxes, date, note, shares, grossAmount);
                break;
            }
            case DELIVERY_INBOUND: 
            case DELIVERY_OUTBOUND: {
                item = this.createDelivery(rawValues, field2column, type, security, amount, fees, taxes, date, note, shares, grossAmount);
                break;
            }
            default: {
                throw new IllegalArgumentException(type.toString());
            }
        }
        item.setAccountPrimary(account);
        item.setPortfolioPrimary(portfolio);
        item.setPortfolioSecondary(portfolio2nd);
        items.add(item);
    }

    private Extractor.Item createBuySell(String[] rawValues, Map<String, CSVImporter.Column> field2column, PortfolioTransaction.Type type, Security security, Money amount, Long fees, Long taxes, LocalDateTime date, String note, Long shares, Transaction.Unit grossAmount) throws ParseException {
        BuySellEntry entry = new BuySellEntry();
        entry.setType(type);
        entry.setSecurity(security);
        entry.setDate(date);
        entry.setAmount(Math.abs(amount.getAmount()));
        entry.setCurrencyCode(amount.getCurrencyCode());
        entry.setShares(shares);
        entry.setNote(note);
        if (grossAmount != null) {
            entry.getPortfolioTransaction().addUnit(grossAmount);
        }
        if (fees != null && fees != 0L) {
            entry.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(amount.getCurrencyCode(), Math.abs(fees))));
        }
        if (taxes != null && taxes != 0L) {
            entry.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(amount.getCurrencyCode(), Math.abs(taxes))));
        }
        if (grossAmount == null) {
            this.createGrossValueIfNecessary(rawValues, field2column, entry.getPortfolioTransaction());
        }
        return new Extractor.BuySellEntryItem(entry);
    }

    private void createGrossValueIfNecessary(String[] rawValues, Map<String, CSVImporter.Column> field2column, PortfolioTransaction transaction) throws ParseException {
        if (transaction.getSecurity().getCurrencyCode().equals(transaction.getCurrencyCode())) {
            return;
        }
        BigDecimal exchangeRate = this.getBigDecimal(Messages.CSVColumn_ExchangeRate, rawValues, field2column);
        if (exchangeRate != null && exchangeRate.compareTo(BigDecimal.ZERO) != 0) {
            Money grossValue = transaction.getGrossValue();
            Money forex = Money.of(transaction.getSecurity().getCurrencyCode(), Math.round(exchangeRate.multiply(BigDecimal.valueOf(grossValue.getAmount())).doubleValue()));
            exchangeRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
            transaction.addUnit(new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, grossValue, forex, exchangeRate));
        }
    }

    private Extractor.Item createTransfer(Security security, Money amount, Long fees, Long taxes, LocalDateTime date, String note, Long shares, Transaction.Unit grossAmount) {
        PortfolioTransferEntry entry = new PortfolioTransferEntry();
        entry.setSecurity(security);
        entry.setDate(date);
        entry.setAmount(Math.abs(amount.getAmount()));
        entry.setCurrencyCode(amount.getCurrencyCode());
        entry.setShares(shares);
        entry.setNote(note);
        return new Extractor.PortfolioTransferItem(entry);
    }

    private Extractor.Item createDelivery(String[] rawValues, Map<String, CSVImporter.Column> field2column, PortfolioTransaction.Type type, Security security, Money amount, Long fees, Long taxes, LocalDateTime date, String note, Long shares, Transaction.Unit grossAmount) throws ParseException {
        PortfolioTransaction t = new PortfolioTransaction();
        t.setType(type);
        t.setSecurity(security);
        t.setDateTime(date);
        t.setAmount(Math.abs(amount.getAmount()));
        t.setCurrencyCode(amount.getCurrencyCode());
        t.setShares(shares);
        t.setNote(note);
        if (grossAmount != null) {
            t.addUnit(grossAmount);
        }
        if (fees != null && fees != 0L) {
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(amount.getCurrencyCode(), Math.abs(fees))));
        }
        if (taxes != null && taxes != 0L) {
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(amount.getCurrencyCode(), Math.abs(taxes))));
        }
        if (grossAmount == null) {
            this.createGrossValueIfNecessary(rawValues, field2column, t);
        }
        return new Extractor.TransactionItem(t);
    }

    private PortfolioTransaction.Type inferType(String[] rawValues, Map<String, CSVImporter.Column> field2column, Money amount) throws ParseException {
        PortfolioTransaction.Type type = this.getEnum(Messages.CSVColumn_Type, PortfolioTransaction.Type.class, rawValues, field2column);
        if (type == null) {
            type = amount.isNegative() ? PortfolioTransaction.Type.BUY : PortfolioTransaction.Type.SELL;
        }
        return type;
    }

    private Transaction.Unit extractGrossAmount(String[] rawValues, Map<String, CSVImporter.Column> field2column, Money amount) throws ParseException {
        Long grossAmount = this.getAmount(Messages.CSVColumn_GrossAmount, rawValues, field2column);
        String currencyCode = this.getCurrencyCode(Messages.CSVColumn_CurrencyGrossAmount, rawValues, field2column);
        BigDecimal exchangeRate = this.getBigDecimal(Messages.CSVColumn_ExchangeRate, rawValues, field2column);
        if (currencyCode == null || amount.getCurrencyCode().equals(currencyCode)) {
            return null;
        }
        if (grossAmount == null || grossAmount == 0L) {
            return null;
        }
        if (exchangeRate == null || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        Money forex = Money.of(currencyCode, Math.abs(grossAmount));
        BigDecimal grossAmountConverted = exchangeRate.multiply(BigDecimal.valueOf(grossAmount));
        Money converted = Money.of(amount.getCurrencyCode(), Math.round(grossAmountConverted.doubleValue()));
        return new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, converted, forex, exchangeRate);
    }
}

