/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.csv;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.stream.Collectors;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.csv.CSVExporter;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.MonetaryOperator;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MoneyCollectors;
import name.abuchen.portfolio.money.MutableMoney;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.AccountSnapshot;
import name.abuchen.portfolio.snapshot.AssetPosition;
import name.abuchen.portfolio.snapshot.ClientPerformanceSnapshot;
import name.abuchen.portfolio.snapshot.ReportingPeriod;
import name.abuchen.portfolio.snapshot.security.SecurityPerformanceIndicator;
import name.abuchen.portfolio.snapshot.security.SecurityPerformanceRecord;
import name.abuchen.portfolio.snapshot.security.SecurityPerformanceSnapshot;
import name.abuchen.portfolio.util.Interval;
import org.apache.commons.csv.CSVPrinter;

public class VINISExporter {
    public void exportAllValues(File file, Client client, ExchangeRateProviderFactory factory) throws IOException {
        String baseCurrency = client.getBaseCurrency();
        CurrencyConverterImpl converter = new CurrencyConverterImpl(factory, baseCurrency);
        LocalDate lastYear = LocalDate.now().minusYears(1L);
        LocalDate firstYear = LocalDate.now().minusYears(100L);
        ReportingPeriod.YearToDate periodCurrentYear = new ReportingPeriod.YearToDate();
        ReportingPeriod.YearX periodLastYear = new ReportingPeriod.YearX(lastYear.getYear());
        ReportingPeriod.FromXtoY periodAllYears = new ReportingPeriod.FromXtoY(firstYear.with(TemporalAdjusters.firstDayOfYear()), LocalDate.now());
        ClientPerformanceSnapshot performanceAllYears = new ClientPerformanceSnapshot(client, converter, ((ReportingPeriod)periodAllYears).toInterval(LocalDate.now()));
        ClientPerformanceSnapshot performanceCurrentYear = new ClientPerformanceSnapshot(client, converter, ((ReportingPeriod)periodCurrentYear).toInterval(LocalDate.now()));
        ClientPerformanceSnapshot performanceLastYear = new ClientPerformanceSnapshot(client, converter, ((ReportingPeriod)periodLastYear).toInterval(LocalDate.now()));
        Money earningsCurrentYear = performanceCurrentYear.getValue(ClientPerformanceSnapshot.CategoryType.EARNINGS);
        Money earningsLastYear = performanceLastYear.getValue(ClientPerformanceSnapshot.CategoryType.EARNINGS);
        Money earningsAll = performanceAllYears.getValue(ClientPerformanceSnapshot.CategoryType.EARNINGS);
        Money capitalGainsCurrentYear = performanceCurrentYear.getValue(ClientPerformanceSnapshot.CategoryType.CAPITAL_GAINS);
        Money capitalGainsLastYear = performanceLastYear.getValue(ClientPerformanceSnapshot.CategoryType.CAPITAL_GAINS);
        Money capitalGainsAll = performanceAllYears.getValue(ClientPerformanceSnapshot.CategoryType.CAPITAL_GAINS);
        Money realizedCapitalGainsCurrentYear = performanceCurrentYear.getValue(ClientPerformanceSnapshot.CategoryType.REALIZED_CAPITAL_GAINS);
        Money realizedCapitalGainsLastYear = performanceLastYear.getValue(ClientPerformanceSnapshot.CategoryType.REALIZED_CAPITAL_GAINS);
        Money realizedCapitalGainsAll = performanceAllYears.getValue(ClientPerformanceSnapshot.CategoryType.REALIZED_CAPITAL_GAINS);
        MutableMoney buySecurityValue = MutableMoney.of(baseCurrency);
        MutableMoney currentSecurityValue = MutableMoney.of(baseCurrency);
        MutableMoney buyTotalValue = MutableMoney.of(baseCurrency);
        MutableMoney currentTotalValue = MutableMoney.of(baseCurrency);
        SecurityPerformanceSnapshot securityPerformance = SecurityPerformanceSnapshot.create(client, (CurrencyConverter)converter, Interval.of(LocalDate.MIN, LocalDate.now()), SecurityPerformanceIndicator.Costs.class);
        List assets = performanceCurrentYear.getEndClientSnapshot().getAssetPositions().collect(Collectors.toList());
        MonetaryOperator toBaseCurrency = converter.at(LocalDate.now());
        for (AssetPosition asset : assets) {
            Money valuation = asset.getValuation().with(toBaseCurrency);
            if (asset.getSecurity() != null) {
                Money fifo = securityPerformance.getRecord(asset.getSecurity()).map(SecurityPerformanceRecord::getFifoCost).orElse(Money.of(baseCurrency, 0L)).with(toBaseCurrency);
                buySecurityValue.add(fifo);
                currentSecurityValue.add(valuation);
                buyTotalValue.add(fifo);
            } else {
                buyTotalValue.add(valuation);
            }
            currentTotalValue.add(valuation);
        }
        Money cash = performanceCurrentYear.getEndClientSnapshot().getAccounts().stream().map(AccountSnapshot::getFunds).collect(MoneyCollectors.sum(baseCurrency));
        Object object = null;
        Object var32_33 = null;
        try (CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), CSVExporter.STRATEGY);){
            this.writeHeader(printer);
            this.write(printer, Messages.VINISAppValueFundsSum, cash);
            this.write(printer, Messages.VINISAppValueSecuritiesPurchase, buySecurityValue.toMoney());
            this.write(printer, Messages.VINISAppValueSecuritiesMarket, currentSecurityValue.toMoney());
            this.write(printer, Messages.VINISAppValueTotalAssetsPurchase, buyTotalValue.toMoney());
            this.write(printer, Messages.VINISAppValueTotalAssetsMarket, currentTotalValue.toMoney());
            this.write(printer, Messages.VINISAppValueEarningsCurrentYear, earningsCurrentYear);
            this.write(printer, Messages.VINISAppValueEarningsLastYear, earningsLastYear);
            this.write(printer, Messages.VINISAppValueEarningsTotal, earningsAll);
            this.write(printer, Messages.VINISAppValueCapitalGainsCurrentYear, capitalGainsCurrentYear);
            this.write(printer, Messages.VINISAppValueCapitalGainsLastYear, capitalGainsLastYear);
            this.write(printer, Messages.VINISAppValueCapitalGainsTotal, capitalGainsAll);
            this.write(printer, Messages.VINISAppValueRealizedCapitalGainsCurrentYear, realizedCapitalGainsCurrentYear);
            this.write(printer, Messages.VINISAppValueRealizedCapitalGainsLastYear, realizedCapitalGainsLastYear);
            this.write(printer, Messages.VINISAppValueRealizedCapitalGainsTotal, realizedCapitalGainsAll);
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    private void write(CSVPrinter printer, String description, Money value) throws IOException {
        printer.print((Object)description);
        printer.print((Object)Values.Amount.format(value.getAmount()));
        printer.print((Object)value.getCurrencyCode());
        printer.println();
    }

    private void writeHeader(CSVPrinter printer) throws IOException {
        printer.print((Object)Messages.CSVColumn_Name);
        printer.print((Object)Messages.CSVColumn_Value);
        printer.print((Object)Messages.CSVColumn_Currency);
        printer.println();
    }
}

