/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.datatransfer.pdf.SwissBasedPDFExtractor;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class BankSLMPDFExtractor
extends SwissBasedPDFExtractor {
    public BankSLMPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier(this.getLabel());
        this.addBankIdentifier("Spar + Leihkasse");
        this.addBuyTransaction();
        this.addSellTransaction();
        this.addDividendTransaction();
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("abrechnung - Kauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("B.rsenabrechnung - Kauf");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> extractor = new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("date", "shares", "name", "wkn", "currency").match("Wir haben f.r Sie am (?<date>\\d+.\\d+.\\d{4}+) gekauft.").match("^(?<shares>[\\d.']+) .*$").match("^(?<name>.*)$").match("^Valor: (?<wkn>[^ ]*)$").match("Total Kurswert (?<currency>\\w{3}+) .*").assign((t, v) -> {
            t.setDate(this.asDate((String)v.get("date")));
            t.setShares(this.asShares((String)v.get("shares")));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("amount", "currency").match("Netto (?<currency>\\w{3}+) -(?<amount>[\\d.']+)").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode((String)v.get("currency"));
        }).wrap(t -> new Extractor.BuySellEntryItem((BuySellEntry)t));
        this.addForexGrossValue(extractor);
        this.addFeesSection(extractor);
        block.set(extractor);
    }

    private void addSellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("abrechnung - Verkauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("B.rsenabrechnung - Verkauf");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> extractor = new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("date", "shares", "name", "wkn", "currency").match("Wir haben f.r Sie am (?<date>\\d+.\\d+.\\d{4}+) verkauft.").match("^(?<shares>[\\d.']+) .*$").match("^(?<name>.*)$").match("^Valor: (?<wkn>[^ ]*)$").match("Total Kurswert (?<currency>\\w{3}+) .*").assign((t, v) -> {
            t.setDate(this.asDate((String)v.get("date")));
            t.setShares(this.asShares((String)v.get("shares")));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("amount", "currency").match("Netto (?<currency>\\w{3}+) (?<amount>[\\d.']+)").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode((String)v.get("currency"));
        }).wrap(t -> new Extractor.BuySellEntryItem((BuySellEntry)t));
        this.addForexGrossValue(extractor);
        this.addFeesSection(extractor);
        block.set(extractor);
    }

    private void addForexGrossValue(PDFParser.Transaction<BuySellEntry> extractor) {
        extractor.section("forexSum", "forexCurrency", "grossValue", "currency", "exchangeRate").optional().match("Total Kurswert (?<forexCurrency>\\w{3}+) (?<forexSum>[\\d.'-]+)").match("Change .../... (?<exchangeRate>[\\d.']+) (?<currency>\\w{3}+) (?<grossValue>[\\d.'-]+)").assign((t, v) -> {
            BigDecimal exchangeRate;
            Money forex;
            Money grossValue = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("grossValue")));
            Transaction.Unit unit = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, grossValue, forex = Money.of(this.asCurrencyCode((String)v.get("forexCurrency")), this.asAmount((String)v.get("forexSum"))), exchangeRate = this.asExchangeRate((String)v.get("exchangeRate")));
            if (unit.getForex().getCurrencyCode().equals(t.getPortfolioTransaction().getSecurity().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(unit);
            }
        });
    }

    private void addFeesSection(PDFParser.Transaction<BuySellEntry> extractor) {
        extractor.section("fees", "currency").match("Eidg. Umsatzabgabe (?<currency>\\w{3}+) -(?<fees>[\\d.']+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fees")))))).section("fees", "currency").optional().match("B.rsengeb.hr (?<currency>\\w{3}+) -(?<fees>[\\d.']+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fees")))))).section("fees", "currency").optional().match("B.rsengeb.hr Inland (?<currency>\\w{3}+) -(?<fees>[\\d.']+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fees")))))).section("fees", "currency").optional().match("Eigene Courtage (?<currency>\\w{3}+) -(?<fees>[\\d.']+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fees"))))));
    }

    private void addDividendTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Dividende");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Dividende");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> extractor = new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DIVIDENDS);
            return transaction;
        }).section("date", "shares", "name", "wkn", "currency").match("Am (?<date>\\d+.\\d+.\\d{4}+) wurde folgende Dividende gutgeschrieben:").match("^.*$").match("^(?<name>.*)$").match("^Valor: (?<wkn>[^ ]*)$").match("Brutto \\((?<shares>[\\d.']+) \\* ... ([\\d.']+)\\) (?<currency>\\w{3}+) ([\\d.']+)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setShares(this.asShares((String)v.get("shares")));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("amount", "currency").match("Netto (?<currency>\\w{3}+) (?<amount>[\\d.']+)").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode((String)v.get("currency"));
        }).section("fees", "currency").optional().match(".* Verrechnungssteuer (?<currency>\\w{3}+) -(?<fees>[\\d.']+)").assign((t, v) -> t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fees")))))).section("fees", "currency").optional().match(".* Quellensteuer (?<currency>\\w{3}+) -(?<fees>[\\d.']+)").assign((t, v) -> t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fees")))))).section("fees", "currency").optional().match(".* Nicht r.ckforderbare Steuern (?<currency>\\w{3}+) -(?<fees>[\\d.']+)").assign((t, v) -> t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fees")))))).section("grossValue", "forexSum", "forexCurrency", "totalValue", "currency", "exchangeRate").optional().match("Brutto \\(([\\d.']+) \\* ... ([\\d.']+)\\) (\\w{3}+) (?<grossValue>[\\d.']+)").match("Netto (?<forexCurrency>\\w{3}+) (?<forexSum>[\\d.']+)").match("Change ... / ... (?<exchangeRate>[\\d.']+) (?<currency>\\w{3}+) (?<totalValue>[\\d.'-]+)").assign((t, v) -> {
            Money totalValue = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("totalValue")));
            t.setMonetaryAmount(totalValue);
            List tax = t.getUnits().collect(Collectors.toList());
            t.clearUnits();
            Money forexGrossValue = Money.of(this.asCurrencyCode((String)v.get("forexCurrency")), this.asAmount((String)v.get("grossValue")));
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
            Money grossValue = Money.of(totalValue.getCurrencyCode(), Math.round(exchangeRate.doubleValue() * (double)forexGrossValue.getAmount()));
            Transaction.Unit unit = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, grossValue, forexGrossValue, exchangeRate);
            t.addUnit(unit);
            tax.stream().forEach(u -> {
                if (u.getAmount().getCurrencyCode().equals(t.getCurrencyCode())) {
                    t.addUnit((Transaction.Unit)u);
                } else {
                    Money txm = Money.of(t.getCurrencyCode(), Math.round(exchangeRate.doubleValue() * (double)u.getAmount().getAmount()));
                    Transaction.Unit fu = new Transaction.Unit(Transaction.Unit.Type.TAX, txm, u.getAmount(), exchangeRate);
                    t.addUnit(fu);
                }
            });
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t));
        block.set(extractor);
    }

    @Override
    public String getLabel() {
        return "Bank SLM";
    }
}

