/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFExtractorUtils;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Annotated;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MutableMoney;

public class ComdirectPDFExtractor
extends AbstractPDFExtractor {
    public ComdirectPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("comdirect");
        this.addBuyTransaction();
        this.addDividendTransaction();
        this.addSellTransaction();
        this.addExpireTransaction();
        this.addVorabsteuerTransaction();
        this.addDividendTransactionFromSteuermitteilungPDF();
        this.addFeesFromVerwahrentgeltPDF();
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wertpapierkauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^(\\* )?Wertpapierkauf *.*");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("time").optional().match("Handelszeit *: (?<time>\\d+:\\d+) Uhr.*").assign((t, v) -> type.getCurrentContext().put("time", (String)v.get("time"))).section("date").match("Gesch\u00e4ftstag *: (?<date>\\d+.\\d+.\\d{4}+) .*").assign((t, v) -> {
            if (type.getCurrentContext().get("time") != null) {
                t.setDate(this.asDate((String)v.get("date"), type.getCurrentContext().get("time")));
            } else {
                t.setDate(this.asDate((String)v.get("date")));
            }
        }).section("isin", "name", "wkn", "nameContinued").find("Wertpapier-Bezeichnung *WPKNR/ISIN *").match("^(?<name>(\\S{1,} )*) *(?<wkn>\\S*) *$").match("^(?<nameContinued>.*?)\\s{3,} *(?<isin>\\S*) *$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").optional().match("^St\\. *(?<shares>[\\d\\.]+(,\\d+)?) .*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("shares").optional().match("^ Summe *St\\. *(?<shares>[\\d\\.]+(,\\d+)?) .*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("amount", "currency").find(".*Zu Ihren Lasten( vor Steuern)? *").match(".* \\d+.\\d+.\\d{4}+ *(?<currency>\\w{3}) *(?<amount>[\\d\\.]+,\\d+).*").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("fxcurrency", "fxamount", "exchangeRate").optional().match(".*Kurswert *: *(?<fxcurrency>\\w{3}) *(?<fxamount>[\\d\\.]+,\\d+).*").match(".*Umrechn. zum Dev. kurs * (?<exchangeRate>[\\d\\.]+,\\d+) .*").assign((t, v) -> {
            String forex = this.asCurrencyCode((String)v.get("fxcurrency"));
            if (t.getPortfolioTransaction().getSecurity().getCurrencyCode().equals(forex)) {
                BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
                BigDecimal reverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                long fxAmount = this.asAmount((String)v.get("fxamount"));
                long amount = reverseRate.multiply(BigDecimal.valueOf(fxAmount)).setScale(0, RoundingMode.HALF_DOWN).longValue();
                Transaction.Unit grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, Money.of(t.getPortfolioTransaction().getCurrencyCode(), amount), Money.of(forex, fxAmount), reverseRate);
                t.getPortfolioTransaction().addUnit(grossValue);
            }
        }).section("tax").optional().match("^ *a *b *g *e *f *\u00fc *h *r *t *e *S *t *e *u *e *r *n *(?<tax>.*)$").assign((t, v) -> {
            Transaction.Unit unit = this.createTaxUnit((String)v.get("tax"));
            if (unit == null || unit.getAmount().isZero()) {
                return;
            }
            t.getPortfolioTransaction().addUnit(unit);
            MutableMoney total = MutableMoney.of(t.getPortfolioTransaction().getCurrencyCode());
            total.add(t.getPortfolioTransaction().getMonetaryAmount());
            total.add(unit.getAmount());
            t.setMonetaryAmount(total.toMoney());
        }).wrap(t -> {
            if (t.getPortfolioTransaction().getShares() == 0L) {
                throw new IllegalArgumentException(Messages.PDFMsgMissingShares);
            }
            return new Extractor.BuySellEntryItem((BuySellEntry)t);
        });
        this.addFeesSection(pdfTransaction, type);
        block.set(pdfTransaction);
        this.addTaxRefunds(type, "^(\\* )?Wertpapierkauf *.*");
    }

    private void addDividendTransaction() {
        PDFParser.DocumentType dividende = new PDFParser.DocumentType("Abrechnung Dividendengutschrift");
        this.addDocumentTyp(dividende);
        PDFParser.DocumentType ertrag = new PDFParser.DocumentType("Abrechnung Ertragsgutschrift");
        this.addDocumentTyp(ertrag);
        PDFParser.Block block = new PDFParser.Block(".*G *u *t *s *c *h *r *i *f *t *f *\u00e4 *l *l *i *g *e *r *W *e *r *t *p *a *p *i *e *r *- *E *r *t *r *\u00e4 *g *e *");
        dividende.addBlock(block);
        ertrag.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DIVIDENDS);
            return t;
        }).section("wkn", "name", "isin", "shares").optional().match("^\\s*(p\\s*e\\s*r) *\\+?[\\d .]+  (?<name>.*)      (?<wkn>.*)").match("^\\s*(S\\s*T\\s*K) *(?<shares>\\+?[\\d .]+,\\+?[\\d ]+).*    .* {4}(?<isin>.*)$").assign((t, v) -> {
            v.put("isin", this.stripBlanks((String)v.get("isin")));
            v.put("wkn", this.stripBlanks((String)v.get("wkn")));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares(this.stripBlanks((String)v.get("shares"))));
        }).section("currency", "amount", "date").find(".*Zu Ihren Gunsten vor Steuern *").match("^.*(?<date>\\d{2}.\\d{2}.\\d{4}) *(?<currency>\\w{3}) *(?<amount>[\\d\\.]+,\\d+) *$").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setDateTime(this.asDate((String)v.get("date")));
        }).section("exchangeRate").optional().match(".*zum Devisenkurs: \\w{3}\\/\\w{3} *(?<exchangeRate>[\\d\\.]+,\\d+) .*").assign((t, v) -> {
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
            dividende.getCurrentContext().put("exchangeRate", exchangeRate.toPlainString());
        }).section("currency", "gross").optional().match("^Bruttobetrag: *(?<currency>\\w{3}) *(?<gross>[\\d\\.]+,\\d+).*").assign((t, v) -> {
            String currency = this.asCurrencyCode((String)v.get("currency"));
            long gross = this.asAmount((String)v.get("gross"));
            long taxAmount = gross - t.getAmount();
            if (!t.getCurrencyCode().equals(currency)) {
                BigDecimal exchangeRate = new BigDecimal(dividende.getCurrentContext().get("exchangeRate"));
                taxAmount = gross - exchangeRate.multiply(BigDecimal.valueOf(t.getAmount())).setScale(0, RoundingMode.HALF_DOWN).longValue();
            }
            Money tax = Money.of(this.asCurrencyCode((String)v.get("currency")), taxAmount);
            PDFExtractorUtils.checkAndSetTax(tax, t, dividende);
            if (!t.getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                BigDecimal exchangeRate = new BigDecimal(dividende.getCurrentContext().get("exchangeRate"));
                BigDecimal inverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                Money grossFx = Money.of(currency, gross);
                gross = inverseRate.multiply(BigDecimal.valueOf(gross).setScale(0, RoundingMode.HALF_DOWN)).longValue();
                Money grossTx = Money.of(t.getCurrencyCode(), gross);
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, grossTx, grossFx, inverseRate));
            }
        }).wrap(Extractor.TransactionItem::new));
    }

    private void addSellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wertpapierverkauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^(\\* )?Wertpapierverkauf *.*");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("time").optional().match("Handelszeit *: (?<time>\\d+:\\d+) Uhr.*").assign((t, v) -> type.getCurrentContext().put("time", (String)v.get("time"))).section("date").match("Gesch\u00e4ftstag *: (?<date>\\d+.\\d+.\\d{4}+) .*").assign((t, v) -> {
            if (type.getCurrentContext().get("time") != null) {
                t.setDate(this.asDate((String)v.get("date"), type.getCurrentContext().get("time")));
            } else {
                t.setDate(this.asDate((String)v.get("date")));
            }
        }).section("isin", "name", "wkn", "nameContinued").find("Wertpapier-Bezeichnung *WPKNR/ISIN *").match("^(?<name>(\\S{1,} )*) *(?<wkn>\\S*) *$").match("^(?<nameContinued>.*?)\\s{3,} *(?<isin>\\S*) *$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").optional().match("^St\\. *(?<shares>[\\d\\.]+(,\\d+)?) .*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("shares").optional().match("^ Summe *St\\. *(?<shares>[\\d\\.]+(,\\d+)?) .*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("amount", "currency").find(".*(Zu Ihren Gunsten vor Steuern|Zu Ihren Lasten vor Steuern) *").match(".* \\d+.\\d+.\\d{4}+ *(?<currency>\\w{3}) *(?<amount>[\\d\\.]+,\\d+-?).*").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            if (((String)v.get("amount")).indexOf("-") != -1) {
                t.setAmount(-this.asAmount(((String)v.get("amount")).substring(0, ((String)v.get("amount")).length() - 1)));
            } else {
                t.setAmount(this.asAmount((String)v.get("amount")));
            }
        }).section("tax").optional().match("^ *a *b *g *e *f *\u00fc *h *r *t *e *S *t *e *u *e *r *n *(?<tax>.*)$").assign((t, v) -> {
            Transaction.Unit unit = this.createTaxUnit((String)v.get("tax"));
            if (unit == null || unit.getAmount().isZero()) {
                return;
            }
            t.getPortfolioTransaction().addUnit(unit);
            MutableMoney total = MutableMoney.of(t.getPortfolioTransaction().getCurrencyCode());
            total.add(t.getPortfolioTransaction().getMonetaryAmount());
            total.subtract(unit.getAmount());
            t.setMonetaryAmount(total.toMoney());
        }).wrap(Extractor.BuySellEntryItem::new);
        this.addFeesSection(pdfTransaction, type);
        block.set(pdfTransaction);
        this.addTaxRefunds(type, "^(\\* )?Wertpapierverkauf *.*");
    }

    private void addFeesSection(PDFParser.Transaction<BuySellEntry> pdfTransaction, PDFParser.DocumentType type) {
        pdfTransaction.section("fee", "currency").optional().match(".*Provision *: *(?<currency>\\w{3}) *(?<fee>[\\d\\.-]+,\\d+)-? *").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".*B.rsenplatzabh.ng. Entgelt *: *(?<currency>\\w{3}) *(?<fee>[\\d\\.-]+,\\d+)-? *").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".*Abwickl.entgelt Clearstream *: *(?<currency>\\w{3}) *(?<fee>[\\d\\.-]+,\\d+)-? *").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("exchangeRate").optional().match(".*Umrechn. zum Dev. kurs * (?<exchangeRate>[\\d\\.]+,\\d+) .*").assign((t, v) -> type.getCurrentContext().put("exchangeRate", (String)v.get("exchangeRate"))).section("fee", "currency").optional().match(".*Fremde Spesen *: *(?<currency>\\w{3}) *(?<fee>[\\d\\.-]+,\\d+)-? *").assign((t, v) -> {
            String currency = this.asCurrencyCode((String)v.get("currency"));
            if (t.getPortfolioTransaction().getCurrencyCode().equals(currency)) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))));
            } else {
                String rate = type.getCurrentContext().get("exchangeRate");
                BigDecimal exchangeRate = this.asExchangeRate(rate);
                BigDecimal reverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                long fxFee = this.asAmount((String)v.get("fee"));
                long fee = reverseRate.multiply(BigDecimal.valueOf(fxFee)).setScale(0, RoundingMode.HALF_DOWN).longValue();
                Transaction.Unit feeUnit = null;
                feeUnit = t.getPortfolioTransaction().getSecurity().getCurrencyCode().equals(currency) ? new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(t.getPortfolioTransaction().getCurrencyCode(), fee), Money.of(this.asCurrencyCode((String)v.get("currency")), fxFee), reverseRate) : new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(t.getPortfolioTransaction().getCurrencyCode(), fee));
                t.getPortfolioTransaction().addUnit(feeUnit);
            }
        }).section("fee", "currency").optional().match(".*Gesamtprovision *: *(?<currency>\\w{3}) *(?<fee>[\\d\\.-]+,\\d+)-? *").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".*Umschreibeentgelt *: *(?<currency>\\w{3}) *(?<fee>[\\d\\.-]+,\\d+)-? *").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".*Variable B.rsenspesen *: *(?<currency>\\w{3}) *(?<fee>[\\d\\.-]+,\\d+)-? *").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee"))))));
    }

    private void addTaxRefunds(PDFParser.DocumentType type, String blockMarker) {
        PDFParser.Block block = new PDFParser.Block(blockMarker);
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.TAX_REFUND);
            return t;
        }).section("date").match("Gesch\u00e4ftstag *: (?<date>\\d+.\\d+.\\d{4}+) .*").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("isin", "name", "wkn").find("Wertpapier-Bezeichnung *WPKNR/ISIN *").match("^(?<name>(\\S{1,} )*) *(?<wkn>\\S*) *$").match("(\\S{1,} )* *(?<isin>\\S*) *$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("tax").optional().match("^ *e *r *s *t *a *t *t *e *t *e *S *t *e *u *e *r *n *(?<tax>.*)$").assign((t, v) -> {
            Transaction.Unit unit = this.createTaxUnit((String)v.get("tax"));
            if (unit == null || unit.getAmount().isZero()) {
                return;
            }
            t.setMonetaryAmount(unit.getAmount());
        }).wrap(t -> t.getAmount() == 0L ? null : new Extractor.TransactionItem((AccountTransaction)t)));
    }

    private void addExpireTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("A *b *r *e *c *h *n *u *n *g *f *\u00e4 *l *l *i *g *e *r *W *e *r *t *p *a *p *i *e *r *e *");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^Einl\u00f6sung *");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("date", "name", "nameContinued", "wkn", "shares", "isin").match("^ *p *e *r *(?<date> \\d *\\d *\\. *\\d *\\d *\\. *\\d *\\d *\\d *\\d)\\s{3,}(?<name>.*)\\s{3,}(?<wkn>.*) *$").match("^ *S *T *K *(?<shares>[\\d\\. ]+(,[\\d ]+)?) *(?<nameContinued>(\\S{1,} {1,2})*) *(?<isin>[\\S ]*) *$").assign((t, v) -> {
            v.put("isin", this.stripBlanksAndUnderscores((String)v.get("isin")));
            v.put("wkn", this.stripBlanksAndUnderscores((String)v.get("wkn")));
            v.put("date", this.stripBlanksAndUnderscores((String)v.get("date")));
            v.put("shares", this.stripBlanksAndUnderscores((String)v.get("shares")));
            v.put("name", this.stripBlanksAndUnderscores((String)v.get("name")));
            v.put("nameContinued", this.stripBlanksAndUnderscores((String)v.get("nameContinued")));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setDate(this.asDate((String)v.get("date")));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("amount", "currency").match("^Kurswert Einl.sung *(?<currency>\\w{3}) *(?<amount>[\\d,]*) *$").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(Extractor.BuySellEntryItem::new);
        this.addFeesSection(pdfTransaction, type);
        block.set(pdfTransaction);
    }

    private void addVorabsteuerTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Vorabpauschale");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^\\s*Steuerliche Behandlung:.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.TAXES);
            return t;
        }).section("wkn", "name", "isin", "shares").optional().match("^(Stk.)\\W*(?<shares>\\d[\\d .,]*)(?<name>.*),\\W*(WKN / ISIN:)(?<wkn>.*)/(?<isin>.*)$").assign((t, v) -> {
            v.put("isin", this.stripBlanks((String)v.get("isin")));
            v.put("wkn", this.stripBlanks((String)v.get("wkn")));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares(this.stripBlanks((String)v.get("shares"))));
        }).section("date").match("^.*Die Belastung erfolgt mit Valuta\\s+(?<date>\\d{2}.\\d{2}.\\d{4}).*$").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("tax", "currency").optional().match("^\\s*(K\\s*a\\s*p\\s*i\\s*t\\s*a\\s*l\\s*e\\s*r\\s*t\\s*r\\s*a\\s*g\\s*s\\s*t\\s*e\\s*u\\s*e\\s*r)(?<currency>[A-Z\\s]+)(?<tax>[\\d\\s,-]+)$").assign((t, v) -> {
            v.put("currency", this.stripBlanksAndUnderscores((String)v.get("currency")));
            v.put("tax", this.stripBlanksAndUnderscores((String)v.get("tax")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))));
        }).section("tax", "currency").optional().match("^\\s*(K\\s*i\\s*r\\s*c\\s*h\\s*e\\s*n\\s*s\\s*t\\s*e\\s*u\\s*e\\s*r)(?<currency>[A-Z\\s_]+)(?<tax>[\\d\\s,-_]+)$").assign((t, v) -> {
            v.put("currency", this.stripBlanksAndUnderscores((String)v.get("currency")));
            v.put("tax", this.stripBlanksAndUnderscores((String)v.get("tax")));
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))));
        }).section("tax", "currency").optional().match("^\\s*(S\\s*o\\s*l\\s*i\\s*d\\s*a\\s*r\\s*i\\s*t\\s*\u00e4\\s*t\\s*s\\s*z\\s*u\\s*s\\s*c\\s*h\\s*l\\s*a\\s*g)(?<currency>[A-Z\\s_]+)(?<tax>[\\d\\s,-_]+)$").assign((t, v) -> {
            v.put("currency", this.stripBlanksAndUnderscores((String)v.get("currency")));
            v.put("tax", this.stripBlanksAndUnderscores((String)v.get("tax")));
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))));
        }).section("tax", "currency").match("^\\s*(a\\s*b\\s*g\\s*e\\s*f\\s*\u00fc\\s*h\\s*r\\s*t\\s*e\\s*S\\s*t\\s*e\\s*u\\s*er\\s*n)(?<currency>[A-Z\\s_]+)(?<tax>[\\d\\s,-_]+)$").assign((t, v) -> {
            v.put("currency", this.stripBlanksAndUnderscores((String)v.get("currency")));
            v.put("tax", this.stripBlanksAndUnderscores((String)v.get("tax")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("tax")));
        }).wrap(Extractor.TransactionItem::new));
    }

    private void addDividendTransactionFromSteuermitteilungPDF() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Steuerliche Behandlung: (Aus|In)l\u00e4ndische (Dividende|Investment-Aussch.ttung)");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^\\s*Steuerliche Behandlung:.*", "^Die Gutschrift erfolgt mit Valuta .*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DIVIDENDS);
            return t;
        }).section("wkn", "name", "isin", "shares").optional().match("^(Stk.)\\W*(?<shares>\\d[\\d\\.,]*)\\W+(?<name>.*),\\W*(WKN / ISIN:)(?<wkn>.*)/(?<isin>.*)$").assign((t, v) -> {
            v.put("isin", this.stripBlanks((String)v.get("isin")));
            v.put("wkn", this.stripBlanks((String)v.get("wkn")));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares(this.stripBlanks((String)v.get("shares"))));
        }).section("currency", "amount").find("^\\s*(Z\\s*u\\s*I\\s*h\\s*r\\s*e\\s*n\\s*G\\s*u\\s*n\\s*s\\s*t\\s*e\\s*n\\s*n\\s*a\\s*c\\s*h\\s*S\\s*t\\s*e\\s*u\\s*e\\s*r\\s*n\\s*:)\\s*(?<currency>[A-Z\\s]*)\\s*(?<amount>[\\d\\.\\s]*,[\\d\\s]+).*").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount(this.stripBlanks((String)v.get("amount"))));
        }).section("currency", "gross1", "gross2").match("^\\s*(Z\\s*u\\s*I\\s*h\\s*r\\s*e\\s*n\\s*G\\s*u\\s*n\\s*s\\s*t\\s*e\\s*n\\s*v\\s*o\\s*r\\s*S\\s*t\\s*e\\s*u\\s*e\\s*r\\s*n\\s*:)\\s*(?<currency>[A-Z\\s]*)\\s*(?<gross1>[\\d\\.\\s]*,[\\d\\s]+)").match("^\\s*(S\\s*t\\s*e\\s*u\\s*e\\s*r\\s*b\\s*e\\s*m\\s*e\\s*s\\s*s\\s*u\\s*n\\s*g\\s*s\\s*g\\s*r\\s*u\\s*n\\s*d\\s*l\\s*a\\s*g\\s*e\\s*(v\\s*o\\s*r\\s*V\\s*e\\s*r\\s*l\\s*u\\s*s\\s*t\\s*v\\s*e\\s*r\\s*r\\s*e\\s*c\\s*h\\s*n\\s*u\\s*n\\s*g)?)\\s*(\\(\\s*1\\s*\\))?\\s*(?<currency>[A-Z\\s]*)\\s*(?<gross2>[\\d\\.\\s]*,[\\d\\s]+)").assign((t, v) -> {
            long amount = t.getAmount();
            long gross1 = this.asAmount(this.stripBlanks((String)v.get("gross1")));
            long gross2 = this.asAmount(this.stripBlanks((String)v.get("gross2")));
            long tax = 0L;
            tax = gross1 > gross2 ? gross1 - amount : gross2 - amount;
            if (tax > 0L) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), tax)));
            }
        }).section("date").match("^(Die Gutschrift erfolgt mit Valuta) (?<date>\\d+\\.\\d+\\.\\d{4}+).*").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).wrap(Extractor.TransactionItem::new));
    }

    private void addFeesFromVerwahrentgeltPDF() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Verwahrentgelt");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^.*Verwahrentgelt.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.FEES);
            return t;
        }).section("wkn", "date").optional().match("^.*Verwahrentgelt .*, WKN (?<wkn>\\S+) (?<date>\\d+.\\d+.\\d{4}).*$").assign((t, v) -> {
            v.put("wkn", this.stripBlanks((String)v.get("wkn")));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setDateTime(this.asDate((String)v.get("date")));
        }).section("currency", "amount").match("^.* Buchung von (?<amount>\\d+,\\d+) (?<currency>\\w+) .*$").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount(this.stripBlanks((String)v.get("amount"))));
        }).wrap(Extractor.TransactionItem::new));
    }

    @Override
    public List<Extractor.Item> postProcessing(List<Extractor.Item> items) {
        Map<LocalDateTime, Map<Security, List<Extractor.Item>>> dividends = items.stream().filter(Extractor.TransactionItem.class::isInstance).map(Extractor.TransactionItem.class::cast).filter(i -> i.getSubject() instanceof AccountTransaction).filter(i -> AccountTransaction.Type.DIVIDENDS.equals((Object)((AccountTransaction)i.getSubject()).getType())).collect(Collectors.groupingBy(Extractor.Item::getDate, Collectors.groupingBy(Extractor.Item::getSecurity)));
        Iterator<Extractor.Item> iterator = items.iterator();
        while (iterator.hasNext()) {
            AccountTransaction a2;
            List<Extractor.Item> similarTransactions;
            Extractor.Item i2 = iterator.next();
            if (!this.isDividendTransaction(i2) || (similarTransactions = dividends.get(i2.getDate()).get(i2.getSecurity())).size() != 2) continue;
            AccountTransaction a1 = (AccountTransaction)similarTransactions.get(0).getSubject();
            int ownIndex = 0;
            if (i2.equals(similarTransactions.get(0))) {
                a2 = (AccountTransaction)similarTransactions.get(1).getSubject();
            } else {
                a1 = (AccountTransaction)similarTransactions.get(1).getSubject();
                a2 = (AccountTransaction)similarTransactions.get(0).getSubject();
                ownIndex = 1;
            }
            if (!a2.getUnit(Transaction.Unit.Type.TAX).isPresent() || a1.getUnit(Transaction.Unit.Type.TAX).isPresent() && !a2.getUnit(Transaction.Unit.Type.TAX).get().getAmount().isGreaterOrEqualThan(a1.getUnit(Transaction.Unit.Type.TAX).get().getAmount())) continue;
            Optional<Transaction.Unit> unitGross = a1.getUnit(Transaction.Unit.Type.GROSS_VALUE);
            if (unitGross.isPresent()) {
                a2.addUnit(unitGross.get());
            }
            iterator.remove();
            dividends.get(i2.getDate()).get(i2.getSecurity()).remove(ownIndex);
        }
        return items;
    }

    private boolean isDividendTransaction(Extractor.Item i) {
        Annotated s;
        if (i instanceof Extractor.TransactionItem && (s = ((Extractor.TransactionItem)i).getSubject()) instanceof AccountTransaction) {
            AccountTransaction a = (AccountTransaction)s;
            return AccountTransaction.Type.DIVIDENDS.equals((Object)a.getType());
        }
        return false;
    }

    private Transaction.Unit createTaxUnit(String taxString) {
        String tax = taxString.replaceAll("[_ ]*", "");
        Pattern pattern = Pattern.compile("(?<currency>\\w{3})-?(?<amount>[\\d\\.]+,\\d+)");
        Matcher matcher = pattern.matcher(tax);
        if (!matcher.matches()) {
            return null;
        }
        return new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode(matcher.group("currency")), this.asAmount(matcher.group("amount"))));
    }

    @Override
    public String getLabel() {
        return "comdirect";
    }

    private String stripBlanks(String input) {
        return input.replaceAll("\\s", "");
    }

    private String stripBlanksAndUnderscores(String input) {
        return input.replaceAll("[\\s_]", "");
    }
}

