/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Optional;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFExtractorUtils;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class DABPDFExtractor
extends AbstractPDFExtractor {
    public DABPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("DAB Bank");
        this.addBankIdentifier("BNP Paribas S.A. Niederlassung Deutschland");
        this.addBuyTransaction();
        this.addSellTransaction();
        this.addDividendTransaction();
        this.addProceedsTransaction();
    }

    @Override
    public String getPDFAuthor() {
        return "Computershare Communication Services GmbH";
    }

    @Override
    public String getLabel() {
        return "DAB Bank";
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Kauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^Kauf .*$", "Dieser Beleg wird .*$");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("isin", "name", "currency").find("Gattungsbezeichnung ISIN").match("^(?<name>.*) (?<isin>[^ ]*)$").match("STK [\\d.]+(,\\d+)? (?<currency>\\w{3}) ([\\d.]+,\\d+)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").find("Nominal Kurs").match("^STK (?<shares>[\\d.]+(,\\d+)?) (\\w{3}) ([\\d.]+,\\d+)$").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("amount", "currency").optional().find("Wert Konto-Nr\\. Betrag zu Ihren Lasten").match("^(\\d+\\.\\d+\\.\\d{4}) ([0-9]*) (?<currency>\\w{3}) (?<amount>[\\d.]+,\\d+)$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("amount", "currency", "exchangeRate").optional().find("Wert Konto-Nr\\. Devisenkurs Betrag zu Ihren Lasten").match("^(\\d+\\.\\d+\\.\\d{4}) ([0-9]*) \\w{3}\\/\\w{3} (?<exchangeRate>[\\d.,]+) (?<currency>\\w{3}) (?<amount>[\\d.]+,\\d+)$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            type.getCurrentContext().put("exchangeRate", (String)v.get("exchangeRate"));
        }).section("date").match("^Handelstag (?<date>\\d+\\.\\d+\\.\\d{4}) .*$").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).section("date", "time").optional().match("^Handelstag (?<date>\\d+\\.\\d+\\.\\d{4}) .*$").match("^Handelszeit (?<time>\\d+:\\d+).*$").assign((t, v) -> {
            if (v.get("time") != null) {
                t.setDate(this.asDate((String)v.get("date"), (String)v.get("time")));
            } else {
                t.setDate(this.asDate((String)v.get("date")));
            }
        }).section("fees", "currency").optional().match("^.* Registrierungsspesen (?<currency>\\w{3}+) (?<fees>[\\d.]+,\\d+)-$").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fees")))))).section("fees", "currency").optional().match("^.* Provision (?<currency>\\w{3}+) (?<fees>[\\d.]+,\\d+)-$").assign((t, v) -> {
            String currency = this.asCurrencyCode((String)v.get("currency"));
            if (currency.equals(t.getAccountTransaction().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(currency, this.asAmount((String)v.get("fees")))));
            } else {
                BigDecimal exchangeRate = this.asExchangeRate(type.getCurrentContext().get("exchangeRate"));
                BigDecimal inverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                long fxfees = this.asAmount((String)v.get("fees"));
                long fees = new BigDecimal(fxfees).divide(exchangeRate, 10, RoundingMode.HALF_DOWN).longValue();
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(t.getAccountTransaction().getCurrencyCode(), fees), Money.of(currency, fxfees), inverseRate));
            }
        }).section("fees", "currency").optional().match("^.* Handelsplatzentgelt (?<currency>\\w{3}) (?<fees>[\\d.]+,\\d+)-$").assign((t, v) -> {
            String currency = this.asCurrencyCode((String)v.get("currency"));
            if (currency.equals(t.getAccountTransaction().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(currency, this.asAmount((String)v.get("fees")))));
            } else {
                BigDecimal exchangeRate = this.asExchangeRate(type.getCurrentContext().get("exchangeRate"));
                BigDecimal inverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                long fxfees = this.asAmount((String)v.get("fees"));
                long fees = new BigDecimal(fxfees).divide(exchangeRate, 10, RoundingMode.HALF_DOWN).longValue();
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(t.getAccountTransaction().getCurrencyCode(), fees), Money.of(currency, fxfees), inverseRate));
            }
        }).section("amount", "currency", "exchangeRate", "forex", "forexCurrency", "curr").optional().find("^Handel.* (Ausmachender Betrag|Kurswert) (?<forexCurrency>\\w{3}) (?<forex>[\\d.]+,\\d+)-").find("Wert Konto-Nr. Devisenkurs Betrag zu Ihren Lasten").match("^(\\d+\\.\\d+\\.\\d{4}) ([0-9]*) (?<curr>\\w{3})\\/\\w{3} (?<exchangeRate>[\\d.]+,\\d+) (?<currency>\\w{3}) (?<amount>[\\d.]+,\\d+)$").assign((t, v) -> {
            Money amount = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
            t.setMonetaryAmount(amount);
            BigDecimal exchangeRate = BigDecimal.ONE.divide(this.asExchangeRate((String)v.get("exchangeRate")), 10, RoundingMode.HALF_DOWN);
            if (!amount.getCurrencyCode().equals(v.get("curr"))) {
                exchangeRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
            }
            Money forex = Money.of(this.asCurrencyCode((String)v.get("forexCurrency")), this.asAmount((String)v.get("forex")));
            Money fees = t.getPortfolioTransaction().getUnitSum(Transaction.Unit.Type.FEE);
            amount = amount.subtract(fees);
            Transaction.Unit grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, amount, forex, exchangeRate);
            t.getPortfolioTransaction().addUnit(grossValue);
        }).wrap(t -> {
            if (t.getPortfolioTransaction().getAmount() == 0L) {
                throw new IllegalArgumentException("No amount found");
            }
            return new Extractor.BuySellEntryItem((BuySellEntry)t);
        }));
    }

    private void addSellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Verkauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^Verkauf .*$", "Dieser Beleg wird .*$");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("isin", "name", "currency").find("Gattungsbezeichnung ISIN").match("^(?<name>.*) (?<isin>[^ ]*)$").match("STK [\\d.]+(,\\d+)? (?<currency>\\w{3}) ([\\d.]+,\\d+)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").find("Nominal Kurs").match("^STK (?<shares>[\\d.]+(,\\d+)?) (\\w{3}) ([\\d.]+,\\d+)$").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("amount", "currency").optional().find("Wert Konto-Nr. Betrag zu Ihren Gunsten").match("^(\\d+\\.\\d+\\.\\d{4}+) ([0-9]*) (?<currency>\\w{3}) (?<amount>[\\d.]+,\\d+)$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("amount", "currency", "exchangeRate", "forex", "forexCurrency").optional().find(".* Ausmachender Betrag (?<forexCurrency>\\w{3}) (?<forex>[\\d.]+,\\d+)").find("Wert Konto-Nr. Devisenkurs Betrag zu Ihren Gunsten").match("^(\\d+\\.\\d+\\.\\d{4}+) ([0-9]*) .../... (?<exchangeRate>[\\d.]+,\\d+) (?<currency>\\w{3}) (?<amount>[\\d.]+,\\d+)$").assign((t, v) -> {
            Money amount = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
            t.setMonetaryAmount(amount);
            BigDecimal exchangeRate = BigDecimal.ONE.divide(this.asExchangeRate((String)v.get("exchangeRate")), 10, RoundingMode.HALF_DOWN);
            Money forex = Money.of(this.asCurrencyCode((String)v.get("forexCurrency")), this.asAmount((String)v.get("forex")));
            Transaction.Unit grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, amount, forex, exchangeRate);
            t.getPortfolioTransaction().addUnit(grossValue);
        }).section("date").match("^Handelstag (?<date>\\d+\\.\\d+\\.\\d{4}+) .*$").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).section("date", "time").optional().match("^Handelstag (?<date>\\d+\\.\\d+\\.\\d{4}+) .*$").match("^Handelszeit (?<time>\\d+:\\d+).*$").assign((t, v) -> {
            if (v.get("time") != null) {
                t.setDate(this.asDate((String)v.get("date"), (String)v.get("time")));
            }
        }).section("fees", "currency").optional().match("^.*Provision (?<currency>\\w{3}) (?<fees>[\\d.]+,\\d+)-$").assign((t, v) -> {
            String currency = this.asCurrencyCode((String)v.get("currency"));
            if (currency.equals(t.getAccountTransaction().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(currency, this.asAmount((String)v.get("fees")))));
            }
        }).wrap(t -> {
            if (t.getPortfolioTransaction().getAmount() == 0L) {
                throw new IllegalArgumentException("No amount found");
            }
            return new Extractor.BuySellEntryItem((BuySellEntry)t);
        });
        this.addTaxesSectionsTransaction(type, pdfTransaction);
        PDFParser.Block taxBlock = new PDFParser.Block("zu versteuern \\(negativ\\).*");
        type.addBlock(taxBlock);
        taxBlock.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.TAX_REFUND);
            return t;
        }).section("amount", "currency", "date").match("Wert Konto-Nr. Abrechnungs-Nr. Betrag zu Ihren Gunsten").match("^(?<date>\\d+\\.\\d+\\.\\d{4}+) ([0-9]*) ([0-9]*) (?<currency>\\w{3}) (?<amount>[\\d.]+,\\d+)$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setDateTime(this.asDate((String)v.get("date")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
    }

    private void addDividendTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Dividende");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^Dividendengutschrift.*$");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> pdfTransaction = new PDFParser.Transaction<AccountTransaction>();
        pdfTransaction.subject(() -> {
            AccountTransaction entry = new AccountTransaction();
            entry.setType(AccountTransaction.Type.DIVIDENDS);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("isin", "name", "currency").find("Gattungsbezeichnung ISIN").match("^(?<name>.*) (?<isin>[^ ]*)$").match("STK ([\\d.]+(,\\d+)?) (\\d{2}\\.\\d{2}\\.\\d{4}) (\\d{2}\\.\\d{2}\\.\\d{4}) (?<currency>\\w{3}) (\\d+,\\d+)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").find("Nominal Ex-Tag Zahltag .*").match("^STK (?<shares>[\\d.]+(,\\d+)?) .*$").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("date", "amount", "currency").optional().find("Wert *Konto-Nr. *Betrag *zu *Ihren *Gunsten").match("^(?<date>\\d{2}\\.\\d{2}\\.\\d{4}) ([0-9]*) (?<currency>\\w{3}) (?<amount>[\\d.]+,\\d+)$").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("date", "amount", "currency", "forexCurrency", "exchangeRate").optional().find("Wert Konto-Nr. Devisenkurs Betrag zu Ihren Gunsten").match("^(?<date>\\d{2}\\.\\d{2}\\.\\d{4}) ([0-9]*) \\w{3}/(?<forexCurrency>\\w{3}) (?<exchangeRate>[\\d.]+,\\d+) (?<currency>\\w{3}) (?<amount>[\\d.]+,\\d+)$").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate")).setScale(10, RoundingMode.HALF_DOWN);
            BigDecimal inverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
            Money forex = Money.of(this.asCurrencyCode((String)v.get("forexCurrency")), Math.round((double)t.getAmount() / inverseRate.doubleValue()));
            Transaction.Unit unit = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, t.getMonetaryAmount(), forex, inverseRate);
            if (unit.getForex().getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                t.addUnit(unit);
            }
        }).section("forex", "localCurrency", "forexCurrency", "exchangeRate").optional().find("Wert Konto-Nr. Betrag zu Ihren Gunsten").match("^(\\d{2}.\\d{2}\\.\\d{4}) ([0-9]*) (\\w{3}) (?<forex>[\\d.]+,\\d+)$").match("Devisenkurs: (?<localCurrency>\\w{3})/(?<forexCurrency>\\w{3}) (?<exchangeRate>[\\d.]+,\\d+)").assign((t, v) -> {
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate")).setScale(10, RoundingMode.HALF_DOWN);
            Money forex = Money.of(this.asCurrencyCode((String)v.get("forexCurrency")), this.asAmount((String)v.get("forex")));
            Money localAmount = Money.of((String)v.get("localCurrency"), Math.round((double)forex.getAmount() / Double.parseDouble(((String)v.get("exchangeRate")).replace(',', '.'))));
            t.setAmount(forex.getAmount());
            t.setCurrencyCode(forex.getCurrencyCode());
            Transaction.Unit unit = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, forex, localAmount, exchangeRate);
            if (unit.getForex().getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                t.addUnit(unit);
            }
        }).section("fxCurrency", "fxAmount", "currency", "exchangeRate").optional().match("ausl.ndische Dividende \\w{3} (?<fxAmount>[\\d.]+,\\d+)").match("Devisenkurs: (?<fxCurrency>\\w{3})/(?<currency>\\w{3}) (?<exchangeRate>[\\d.]+,\\d+)").assign((t, v) -> {
            if (!t.getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                Transaction.Unit grossValue;
                BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
                if (!this.asCurrencyCode((String)v.get("fxCurrency")).equals(t.getCurrencyCode())) {
                    Money fxAmount = Money.of(this.asCurrencyCode((String)v.get("fxCurrency")), this.asAmount((String)v.get("fxAmount")));
                    long localAmount = exchangeRate.multiply(BigDecimal.valueOf(fxAmount.getAmount())).longValue();
                    Money amount = Money.of(this.asCurrencyCode((String)v.get("currency")), localAmount);
                    grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, amount, fxAmount, exchangeRate);
                } else {
                    Money amount = Money.of(this.asCurrencyCode((String)v.get("fxCurrency")), this.asAmount((String)v.get("fxAmount")));
                    long forexAmount = exchangeRate.multiply(BigDecimal.valueOf(amount.getAmount())).longValue();
                    Money fxAmount = Money.of(this.asCurrencyCode((String)v.get("currency")), forexAmount);
                    grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, amount, fxAmount, exchangeRate);
                }
                Optional<Transaction.Unit> grossUnit = t.getUnit(Transaction.Unit.Type.GROSS_VALUE);
                if (grossUnit.isPresent()) {
                    t.removeUnit(grossUnit.get());
                }
                t.addUnit(grossValue);
            }
        }).wrap(t -> {
            if (t.getAmount() == 0L) {
                throw new IllegalArgumentException("No dividend amount found.");
            }
            return new Extractor.TransactionItem((AccountTransaction)t);
        });
        this.addTaxesSectionsTransaction(type, pdfTransaction);
    }

    private void addProceedsTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Ertr\u00e4gnisgutschrift");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^Ertr\u00e4gnisgutschrift (?!aus).*$");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> pdfTransaction = new PDFParser.Transaction<AccountTransaction>();
        pdfTransaction.subject(() -> {
            AccountTransaction entry = new AccountTransaction();
            entry.setType(AccountTransaction.Type.DIVIDENDS);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("name", "isin").find("Gattungsbezeichnung ISIN").match("^(?<name>.*) (?<isin>[^ ]*)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").find("Nominal Ex-Tag Zahltag .*").match("^STK (?<shares>[\\d.]+(,\\d+)?) .*$").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("date", "amount", "currency").optional().find("Wert\\s*Konto-Nr.\\s*Betrag\\s*zu\\s*Ihren\\s*Gunsten").match("^(?<date>\\d+\\.\\d+\\.\\d{4}+)\\s*([0-9]*) (?<currency>\\w{3})\\s*(?<amount>[\\d.]+,\\d+)$").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("date", "amount", "currency").optional().find("Wert\\s*Konto-Nr.\\s*Devisenkurs\\s*Betrag\\s*zu\\s*Ihren\\s*Gunsten").match("^(?<date>\\d+\\.\\d+\\.\\d{4}+)\\s*([0-9]*)\\s*(\\w{3})\\/(\\w{3})\\s*([\\d.]+(,\\d+)?)\\s*(?<currency>\\w{3})\\s*(?<amount>[\\d.]+,\\d+)$").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(t -> {
            if (t.getAmount() == 0L) {
                throw new IllegalArgumentException("No dividend amount found.");
            }
            return new Extractor.TransactionItem((AccountTransaction)t);
        });
        this.addTaxesSectionsTransaction(type, pdfTransaction);
    }

    private <T extends PDFParser.Transaction<?>> void addTaxesSectionsTransaction(PDFParser.DocumentType documentType, T pdfTransaction) {
        pdfTransaction.section("n").optional().match("zu versteuern \\(negativ\\) (?<n>.*)").assign((t, v) -> documentType.getCurrentContext().put("negative", "X"));
        pdfTransaction.section("exchangeRate", "fxCurrency").optional().match("Devisenkurs: (\\w{3})/(?<fxCurrency>\\w{3}) (?<exchangeRate>[\\d.]+,\\d+)").assign((t, v) -> {
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
            if (this.getTransaction(t).getCurrencyCode().contentEquals(this.asCurrencyCode((String)v.get("fxCurrency")))) {
                exchangeRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
            }
            documentType.getCurrentContext().put("exchangeRate", exchangeRate.toPlainString());
        }).section("exchangeRate", "fxCurrency").optional().match("^Wert Konto-Nr. Devisenkurs Betrag zu Ihren Gunsten$").match("\\d{2}\\.\\d{2}\\.\\d{4} \\d+ (\\w{3})/(?<fxCurrency>\\w{3}) (?<exchangeRate>[\\d.]+,\\d+) .*").assign((t, v) -> {
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
            if (this.getTransaction(t).getCurrencyCode().contentEquals(this.asCurrencyCode((String)v.get("fxCurrency")))) {
                exchangeRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
            }
            documentType.getCurrentContext().put("exchangeRate", exchangeRate.toPlainString());
        }).section("tax", "currency", "label").optional().match("^(?<label>.*)US-Quellensteuer.* (?<currency>\\w{3}) (?<tax>[\\d.]+,\\d+)-?$").assign((t, v) -> {
            if (!"davon anrechenbare".equals(((String)v.get("label")).trim())) {
                Money tax = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")));
                PDFExtractorUtils.checkAndSetTax(tax, this.getTransaction(t), documentType);
            }
        }).section("tax", "currency", "label").optional().match("^(?<label>.*) Kapitalertragsteuer (?<currency>\\w{3}) (?<tax>[\\d.]+,\\d+)-?$").assign((t, v) -> {
            if (!"X".equals(documentType.getCurrentContext().get("negative")) && !"im laufenden Jahr einbehaltene".equals(v.get("label"))) {
                Money tax = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")));
                PDFExtractorUtils.checkAndSetTax(tax, this.getTransaction(t), documentType);
            }
        }).section("tax", "currency", "label").optional().match("^(?<label>.*) Solidarit\u00e4tszuschlag (?<currency>\\w{3}) (?<tax>[\\d.]+,\\d+)-?$").assign((t, v) -> {
            if (!"X".equals(documentType.getCurrentContext().get("negative")) && !"im laufenden Jahr einbehaltener".equals(v.get("label"))) {
                Money tax = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")));
                PDFExtractorUtils.checkAndSetTax(tax, this.getTransaction(t), documentType);
            }
        }).section("tax", "currency", "label").optional().match("^(?<label>.*) ?Kirchensteuer (?<currency>\\w{3}) (?<tax>[\\d.]+,\\d+)-?$").assign((t, v) -> {
            if (!"X".equals(documentType.getCurrentContext().get("negative")) && !"im laufenden Jahr einbehaltene".equals(v.get("label"))) {
                Money tax = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")));
                PDFExtractorUtils.checkAndSetTax(tax, this.getTransaction(t), documentType);
            }
        });
    }

    private Transaction getTransaction(Object t) {
        if (t instanceof Transaction) {
            return (Transaction)t;
        }
        return ((BuySellEntry)t).getPortfolioTransaction();
    }
}

