/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class DkbPDFExtractor
extends AbstractPDFExtractor {
    private static final String EXCHANGE_RATE = "exchangeRate";
    private static final String FLAG_WITHHOLDING_TAX_FOUND = "exchangeRate";

    public DkbPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("");
        this.addBuyTransaction();
        this.addSellTransaction();
        this.addInterestTransaction();
        this.addDividendTransaction();
        this.addInvestmentEarningTransaction();
        this.addRemoveTransaction();
        this.addTransferOutTransaction();
        this.addParticipationcertificateEarningTransaction();
        this.addParticipationcertificateRefundTransaction();
        this.addInvestmentPayoutTransaction();
        this.addBuyTransactionFundsSavingsPlan();
        this.addAdvanceTaxTransaction();
    }

    @Override
    public String getPDFAuthor() {
        return "DKB AG";
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wertpapier Abrechnung \\b(Kauf?.+|Ausgabe.+)\\b");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Wertpapier Abrechnung \\b(Kauf?.+|Ausgabe.+)\\b");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("notation", "shares", "name", "isin", "wkn").find("Nominale Wertpapierbezeichnung ISIN \\(WKN\\)").match("(?<notation>^St\\Dck|^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{1,})?) (?<name>.*) (?<isin>[^ ]*) (\\((?<wkn>.*)\\).*)$").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (!(notation == null || notation.startsWith("St") && notation.endsWith("ck"))) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("date", "amount").match("(^Schlusstag)(/-Zeit)? (?<date>\\d+.\\d+.\\d{4}+) (.*)").match("(^Ausmachender Betrag) (?<amount>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)(-) (?<currency>\\w{3}+)").assign((t, v) -> {
            t.setDate(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.BuySellEntryItem::new);
        this.addFeesSectionsTransaction(pdfTransaction);
    }

    private void addSellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wertpapier Abrechnung (Verkauf|R\u00fccknahme Investmentfonds)");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Wertpapier Abrechnung (Verkauf|R\u00fccknahme Investmentfonds).*");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("notation", "shares", "name", "isin", "wkn").find("Nominale Wertpapierbezeichnung ISIN \\(WKN\\)").match("(?<notation>^St\\Dck|^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{2,})?) (?<name>.*) (?<isin>[^ ]*) (\\((?<wkn>.*)\\).*)$").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (!(notation == null || notation.startsWith("St") && notation.endsWith("ck"))) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("amount", "currency").match("(^Ausmachender Betrag) (?<amount>\\d{1,3}(\\.\\d{3})*(,\\d{2})?) (?<currency>\\w{3}+)(.*)").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("date").optional().match("^Den Gegenwert buchen wir mit Valuta (?<date>\\d+.\\d+.\\d{4}+) (.*)").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).section("date").optional().match("(^Schlusstag)(/-Zeit)? (?<date>\\d+.\\d+.\\d{4}+) (.*)").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).wrap(Extractor.BuySellEntryItem::new);
        this.addTaxesSectionsTransaction(type, pdfTransaction);
        this.addFeesSectionsTransaction(pdfTransaction);
    }

    private void addInterestTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Zinsgutschrift");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Zinsgutschrift");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> pdfTransaction = new PDFParser.Transaction<AccountTransaction>();
        pdfTransaction.subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DIVIDENDS);
            return transaction;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("notation", "shares", "name", "isin", "wkn").find("Nominale Wertpapierbezeichnung ISIN \\(WKN\\)").match("(?<notation>^St\\Dck|^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{2,})?) (?<name>.*) (?<isin>[^ ]*) (\\((?<wkn>.*)\\).*)$").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (!(notation == null || notation.startsWith("St") && notation.endsWith("ck"))) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("date", "amount").match("(^Ausmachender Betrag) (?<amount>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)(.*) (?<currency>\\w{3}+)").match("(^Den Betrag buchen wir mit Wertstellung) (?<date>\\d+.\\d+.\\d{4}+) zu Gunsten des Kontos (.*)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.TransactionItem::new);
        this.addTaxesSectionsTransaction(type, pdfTransaction);
        this.addFeesSectionsTransaction(pdfTransaction);
    }

    private void addDividendTransaction() {
        PDFParser.DocumentType type = this.createDocumentType("Dividendengutschrift");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Dividendengutschrift|Ertragsgutschrift.*");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> pdfTransaction = new PDFParser.Transaction<AccountTransaction>();
        pdfTransaction.subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DIVIDENDS);
            return transaction;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("shares", "name", "nameContinued", "isin", "wkn").find("Nominale Wertpapierbezeichnung ISIN \\(WKN\\)").match("(^St\\Dck) (?<shares>[\\d,.]*) (?<name>.*) (?<isin>[^ ]*) (\\((?<wkn>.*)\\).*)$").match("(?<nameContinued>.*)").assign((t, v) -> {
            t.setShares(this.asShares((String)v.get("shares")));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("date", "amount").match("(^Ausmachender Betrag) (?<amount>\\d{1,3}(\\.\\d{3})*(,\\d{2,})?)(.*) (?<currency>\\w{3}+)").match("(^Lagerstelle) (.*)").match("(^Den Betrag buchen wir mit Wertstellung) (?<date>\\d+.\\d+.\\d{4}+) zu Gunsten des Kontos (.*)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.TransactionItem::new);
        this.addTaxesSectionsTransaction(type, pdfTransaction);
        this.addFeesSectionsTransaction(pdfTransaction);
    }

    private void addInvestmentEarningTransaction() {
        this.addTransaction("Investmentertr\u00e4ge", "Gutschrift von Investmentertr\u00e4gen", AccountTransaction.Type.DIVIDENDS);
    }

    private void addRemoveTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("ung");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Gesamtk\u00fcndigung|Teilr\u00fcckzahlung mit Nennwert\u00e4nderung|Teilliquidation mit Nennwertreduzierung|Einl\u00f6sung bei Gesamtf\u00e4lligkeit");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.getPortfolioTransaction().setType(PortfolioTransaction.Type.DELIVERY_OUTBOUND);
            entry.getAccountTransaction().setType(AccountTransaction.Type.TRANSFER_IN);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("notation", "shares", "name", "isin", "wkn").find("Nominale Wertpapierbezeichnung ISIN \\(WKN\\)").match("(?<notation>^St\\Dck|^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{2,})?) (?<name>.*) (?<isin>[^ ]*) (\\((?<wkn>.*)\\).*)$").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (!(notation == null || notation.startsWith("St") && notation.endsWith("ck"))) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            type.getCurrentContext().put("isin", (String)v.get("isin"));
        }).section("date", "amount", "sign").match("(^Ausmachender Betrag) (?<amount>\\d{1,3}(\\.\\d{3})*(,\\d{2})?[+-]) (?<currency>\\w{3}+)(.*)").match("(^Den Betrag buchen wir mit Valuta) (?<date>\\d+.\\d+.\\d{4}+) zu (?<sign>Gunsten|Lasten) des Kontos (.*)").assign((t, v) -> {
            String sign = (String)v.get("sign");
            if ("Lasten".equalsIgnoreCase(sign)) {
                t.getPortfolioTransaction().setType(PortfolioTransaction.Type.DELIVERY_INBOUND);
                t.getAccountTransaction().setType(AccountTransaction.Type.TRANSFER_OUT);
            }
            t.setDate(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.BuySellEntryItem::new);
        this.addTaxesSectionsTransaction(type, pdfTransaction);
        this.addFeesSectionsTransaction(pdfTransaction);
        this.addTaxReturnBlock(type);
    }

    private void addTransferOutTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Depotbuchung - Belastung");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Depotbuchung - Belastung");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.TRANSFER_OUT);
            return entry;
        }).section("notation", "shares", "name", "isin", "wkn").find("Nominale Wertpapierbezeichnung ISIN \\(WKN\\)").match("(?<notation>^St\\Dck|^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{2,})?) (?<name>.*) (?<isin>[^ ]*) (\\((?<wkn>.*)\\).*)$").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (!(notation == null || notation.startsWith("St") && notation.endsWith("ck"))) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("date").match("(^Valuta) (?<date>\\d+.\\d+.\\d{4}+) (.*)").assign((t, v) -> {
            t.setDate(this.asDate((String)v.get("date")));
            t.setCurrencyCode(this.asCurrencyCode(t.getPortfolioTransaction().getSecurity().getCurrencyCode()));
        }).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addParticipationcertificateEarningTransaction() {
        this.addTransaction("Genussschein", "Aussch\u00fcttung aus Genussschein", AccountTransaction.Type.DIVIDENDS);
    }

    private void addParticipationcertificateRefundTransaction() {
        this.addTransaction("Gutschrift", "Kapitalr\u00fcckzahlung", AccountTransaction.Type.DEPOSIT);
    }

    private void addInvestmentPayoutTransaction() {
        this.addTransaction("Investmentfonds", "Aussch\u00fcttung Investmentfonds", AccountTransaction.Type.DIVIDENDS);
    }

    private void addAdvanceTaxTransaction() {
        this.addTransaction("Vorabpauschale", "Vorabpauschale Investmentfonds", AccountTransaction.Type.TAXES);
    }

    private void addTransaction(String documentTypeString, String blockMarkerString, AccountTransaction.Type transactiontype) {
        PDFParser.DocumentType type = this.createDocumentType(documentTypeString);
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block(blockMarkerString);
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> pdfTransaction = new PDFParser.Transaction<AccountTransaction>();
        pdfTransaction.subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(transactiontype);
            return transaction;
        });
        block.set(pdfTransaction);
        pdfTransaction.oneOf(section -> section.attributes("shares", "name", "isin", "wkn", "currency").find("Nominale Wertpapierbezeichnung ISIN \\(WKN\\)").match("(^St\\Dck) (?<shares>[\\d,.]*) (?<name>.*)$").match(".*").match("(?<isin>[^ ]*) \\((?<wkn>.*)\\)$").match("^Ertrag pro St. [\\d,.]* (?<currency>\\w{3}+)").assign((t, v) -> {
            t.setShares(this.asShares((String)v.get("shares")));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }), section -> section.attributes("shares", "name", "nameContinued", "isin", "wkn").find("Nominale Wertpapierbezeichnung ISIN \\(WKN\\)").match("(^St\\Dck) (?<shares>[\\d,.]*) (?<name>.*) (?<isin>[^ ]*) \\((?<wkn>.*)\\)$").match("(?<nameContinued>.*)").assign((t, v) -> {
            t.setShares(this.asShares((String)v.get("shares")));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        })).section("date", "amount").match("(^Ausmachender Betrag) (?<amount>[\\d,.]*)(.*) (?<currency>\\w{3}+)").match("(^Lagerstelle) (.*)").match("(^Den Betrag buchen wir mit Wertstellung) (?<date>\\d+.\\d+.\\d{4}+) zu (Gunsten|Lasten) des Kontos (.*)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.TransactionItem::new);
        this.addTaxesSectionsTransaction(type, pdfTransaction);
        this.addFeesSectionsTransaction(pdfTransaction);
    }

    private PDFParser.DocumentType createDocumentType(String documentTypeString) {
        PDFParser.DocumentType type = new PDFParser.DocumentType(documentTypeString, (context, lines) -> {
            Pattern pattern = Pattern.compile("Devisenkurs (?<term>\\w{3}+) / (?<base>\\w{3}+) (?<exchangeRate>[\\d,.]*)(.*)");
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher m = pattern.matcher(line);
                if (m.matches()) {
                    context.put("exchangeRate", m.group("exchangeRate"));
                }
                ++n2;
            }
        });
        return type;
    }

    private void addBuyTransactionFundsSavingsPlan() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Halbjahresabrechnung Sparplan", (context, lines) -> {
            Pattern pSecurity = Pattern.compile("(?<name>.*) (?<isin>[^ ]*) (\\((?<wkn>.*)\\).*)$");
            Pattern pCurrency = Pattern.compile("^(?<currency>\\w{3}+) in .*$");
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher m = pSecurity.matcher(line);
                if (m.matches()) {
                    context.put("isin", m.group("isin"));
                    context.put("wkn", m.group("wkn"));
                    context.put("name", m.group("name"));
                }
                if ((m = pCurrency.matcher(line)).matches()) {
                    context.put("currency", m.group("currency"));
                }
                ++n2;
            }
        });
        this.addDocumentTyp(type);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        PDFParser.Block blockTransaction = new PDFParser.Block("Kauf [\\d,]+ .*");
        type.addBlock(blockTransaction);
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        });
        blockTransaction.set(pdfTransaction);
        pdfTransaction.section("amount", "shares", "date").match("^Kauf (?<amount>[\\d,]+) [\\d]{2,10}\\/.* (?<shares>[\\d,]+) (?<date>\\d+.\\d+.\\d{4}+) .*").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            t.setSecurity(this.getOrCreateSecurity(context));
            t.setDate(this.asDate((String)v.get("date")));
            t.setShares(this.asShares((String)v.get("shares")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
        }).wrap(Extractor.BuySellEntryItem::new);
    }

    private <T extends PDFParser.Transaction<?>> void addTaxesSectionsTransaction(PDFParser.DocumentType documentType, T pdfTransaction) {
        pdfTransaction.section("tax", "currency").optional().match("^Kapitalertragsteuer (.*) (\\w{3}+) (?<tax>[\\d.-]+,\\d+)(-) (?<currency>\\w{3}+)").assign((t, v) -> this.addTax(documentType, t, (Map<String, String>)v, "tax")).section("soli", "currency").optional().match("^Solidarit(.*) (\\w{3}+) (?<soli>[\\d.-]+,\\d+)(-) (?<currency>\\w{3}+)").assign((t, v) -> this.addTax(documentType, t, (Map<String, String>)v, "soli")).section("kirchenst", "currency").optional().match("^Kirchensteuer (.*) (\\w{3}+) (?<kirchenst>[\\d.-]+,\\d+)(-) (?<currency>\\w{3}+)").assign((t, v) -> this.addTax(documentType, t, (Map<String, String>)v, "kirchenst")).section("quellensteinbeh", "currency").optional().match("^Einbehaltene Quellensteuer(.*) (\\w{3}+) (?<quellensteinbeh>[\\d.]+,\\d+)(-) (?<currency>\\w{3}+)").assign((t, v) -> {
            documentType.getCurrentContext().put("exchangeRate", "true");
            this.addTax(documentType, t, (Map<String, String>)v, "quellensteinbeh");
        }).section("quellenstanr", "currency").optional().match("^Anrechenbare Quellensteuer(.*) (\\w{3}+) (?<quellenstanr>[\\d.]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> this.addTax(documentType, t, (Map<String, String>)v, "quellenstanr")).section("quellenstrueck", "currency").optional().match("^(.*)ckforderbare Quellensteuer (?<quellenstrueck>[\\d.]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> this.addTax(documentType, t, (Map<String, String>)v, "quellenstrueck"));
    }

    private void addTax(PDFParser.DocumentType documentType, Object t, Map<String, String> v, String taxtype) {
        if (this.checkWithholdingTax(documentType, taxtype)) {
            Transaction tx = this.getTransaction(t);
            String currency = this.asCurrencyCode(v.get("currency"));
            long amount = this.asAmount(v.get(taxtype));
            if (!currency.equals(tx.getCurrencyCode()) && documentType.getCurrentContext().containsKey("exchangeRate")) {
                BigDecimal rate = BigDecimal.ONE.divide(this.asExchangeRate(documentType.getCurrentContext().get("exchangeRate")), 10, RoundingMode.HALF_DOWN);
                currency = tx.getCurrencyCode();
                amount = rate.multiply(BigDecimal.valueOf(amount)).setScale(0, RoundingMode.HALF_DOWN).longValue();
            }
            tx.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(currency, amount)));
        }
    }

    private boolean checkWithholdingTax(PDFParser.DocumentType documentType, String taxtype) {
        return Boolean.valueOf(documentType.getCurrentContext().get("exchangeRate")) == false || !"quellenstanr".equalsIgnoreCase(taxtype) && !"quellenstrueck".equalsIgnoreCase(taxtype);
    }

    private <T extends PDFParser.Transaction<?>> void addFeesSectionsTransaction(T pdfTransaction) {
        pdfTransaction.section("fee", "currency").optional().match("(^Provision) (?<fee>\\d{1,3}(\\.\\d{3})*(,\\d{2})?[-]) (?<currency>\\w{3}+)").assign((t, v) -> this.getTransaction(t).addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match("(^Transaktionsentgelt B\u00f6rse) (?<fee>\\d{1,3}(\\.\\d{3})*(,\\d{2})?[-]) (?<currency>\\w{3}+)").assign((t, v) -> this.getTransaction(t).addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".*Namensaktien (?<fee>\\d{1,3}(\\.\\d{3})*(,\\d{2})?[-]) (?<currency>\\w{3}+)").assign((t, v) -> this.getTransaction(t).addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match("(^\u00dcbertragungs-/Liefergeb\u00fchr) (?<fee>\\d{1,3}(\\.\\d{3})*(,\\d{2})?[-]) (?<currency>\\w{3}+)").assign((t, v) -> this.getTransaction(t).addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee"))))));
    }

    private Transaction getTransaction(Object t) {
        if (t instanceof Transaction) {
            return (Transaction)t;
        }
        return ((BuySellEntry)t).getPortfolioTransaction();
    }

    private void addTaxReturnBlock(PDFParser.DocumentType type) {
        PDFParser.Block block = new PDFParser.Block("^Kapitalertragsteuer (.*) (\\w{3}+) ([\\d.-]+,\\d+)(\\+) (\\w{3}+)(.*)");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction entry = new AccountTransaction();
            entry.setType(AccountTransaction.Type.TAX_REFUND);
            return entry;
        }).section("tax", "currency").optional().match("^Kapitalertragsteuer (.*) (\\w{3}+) (?<tax>[\\d.-]+,\\d+)(\\+) (?<currency>\\w{3}+)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("tax")));
        }).section("soli", "currency").optional().match("^Solidarit(.*) (\\w{3}+) (?<soli>[\\d.-]+,\\d+)(\\+) (?<currency>\\w{3}+)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(t.getAmount() + this.asAmount((String)v.get("soli")));
        }).section("kirchenst", "currency").optional().match("^Kirchensteuer (.*) (\\w{3}+) (?<kirchenst>[\\d.-]+,\\d+)(\\+) (?<currency>\\w{3}+)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(t.getAmount() + this.asAmount((String)v.get("kirchenst")));
        }).section("date").match("(^Den Betrag buchen wir mit Valuta) (?<date>\\d+.\\d+.\\d{4}+) zu Lasten des Kontos (.*)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            v.put("isin", type.getCurrentContext().get("isin"));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).wrap(Extractor.TransactionItem::new));
    }

    @Override
    public String getLabel() {
        return "DKB";
    }
}

